/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Quat4f;
import hmi.math.Vec3f;

public final class QuatCurve {
    private QuatCurve() {
    }

    public static void hermite(float[] qStart, float[] qEnd, float[] wStart, float[] wEnd, float t, float[] q) {
        double b1 = 1.0 - Math.pow(1.0 - (double)t, 3.0);
        double b2 = 3.0 * (double)t * (double)t - 2.0 * (double)t * (double)t * (double)t;
        double b3 = t * t * t;
        float[] w1 = Vec3f.getZero();
        float[] w2 = Vec3f.getZero();
        float[] w3 = Vec3f.getZero();
        float[] qTemp1 = Quat4f.getQuat4f();
        float[] qTemp2 = Quat4f.getQuat4f();
        float[] qTemp3 = Quat4f.getQuat4f();
        Vec3f.scale(0.33333334f, w1, wStart);
        Vec3f.scale(0.33333334f, w3, wEnd);
        Quat4f.exp(qTemp1, w1);
        Quat4f.conjugate(qTemp1);
        Quat4f.mulConjugateRight(qTemp1, qStart);
        Quat4f.mul(qTemp1, qEnd);
        Quat4f.exp(qTemp2, w3);
        Quat4f.conjugate(qTemp2);
        Quat4f.mul(qTemp1, qTemp2);
        Quat4f.normalize(qTemp1);
        Quat4f.log(w2, qTemp1);
        Vec3f.scale((float)b1, w1);
        Vec3f.scale((float)b2, w2);
        Vec3f.scale((float)b3, w3);
        Quat4f.exp(qTemp1, w1);
        Quat4f.exp(qTemp2, w2);
        Quat4f.exp(qTemp3, w3);
        Quat4f.set(q, qStart);
        Quat4f.mul(q, qTemp1);
        Quat4f.mul(q, qTemp2);
        Quat4f.mul(q, qTemp3);
    }

    public static void hermite(float[] qStart, int qStartIndex, float[] qEnd, int qEndIndex, float[] wStart, int wStartIndex, float[] wEnd, int wEndIndex, float t, float[] q, int qIndex) {
        double b1 = 1.0 - Math.pow(1.0 - (double)t, 3.0);
        double b2 = 3.0 * (double)t * (double)t - 2.0 * (double)t * (double)t * (double)t;
        double b3 = t * t * t;
        float[] w1 = Vec3f.getZero();
        float[] w2 = Vec3f.getZero();
        float[] w3 = Vec3f.getZero();
        float[] qTemp1 = Quat4f.getQuat4f();
        float[] qTemp2 = Quat4f.getQuat4f();
        float[] qTemp3 = Quat4f.getQuat4f();
        Vec3f.scale(0.33333334f, w1, 0, wStart, wStartIndex);
        Vec3f.scale(0.33333334f, w3, 0, wEnd, wEndIndex);
        Quat4f.exp(qTemp1, w1);
        Quat4f.conjugate(qTemp1);
        Quat4f.mulConjugateRight(qTemp1, 0, qStart, qStartIndex);
        Quat4f.mul(qTemp1, 0, qEnd, qEndIndex);
        Quat4f.exp(qTemp2, w3);
        Quat4f.conjugate(qTemp2);
        Quat4f.mul(qTemp1, qTemp2);
        Quat4f.normalize(qTemp1);
        Quat4f.log(w2, qTemp1);
        Vec3f.scale((float)b1, w1);
        Vec3f.scale((float)b2, w2);
        Vec3f.scale((float)b3, w3);
        Quat4f.exp(qTemp1, w1);
        Quat4f.exp(qTemp2, w2);
        Quat4f.exp(qTemp3, w3);
        Quat4f.set(q, qIndex, qStart, qStartIndex);
        Quat4f.mul(q, qIndex, qTemp1, 0);
        Quat4f.mul(q, qIndex, qTemp2, 0);
        Quat4f.mul(q, qIndex, qTemp3, 0);
    }
}

