/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.NumMath;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.math.Vec4f;
import org.junit.Assert;
import org.junit.Test;

public class Quat4fTest {
    @Test
    public void testEpsilonEquivalent() {
        float[] q1 = new float[4];
        float[] q2 = new float[4];
        Quat4f.setFromAxisAngleDegrees(q1, 1.0f, 1.0f, 0.5f, 45.0f);
        Quat4f.set(q2, q1);
        int i = 0;
        while (i < 4) {
            q2[i] = -q2[i];
            ++i;
        }
        Assert.assertTrue((boolean)Quat4f.epsilonRotationEquivalent(q1, q2, 1.0E-6f));
        Assert.assertTrue((boolean)Quat4f.epsilonRotationEquivalent(q1, q2[0], q2[1], q2[2], q2[3], 1.0E-6f));
    }

    @Test
    public void testEpsilonEquivalentIndexed() {
        float[] q = new float[4];
        float[] q1 = new float[5];
        float[] q2 = new float[6];
        Quat4f.setFromAxisAngleDegrees(q, 1.0f, 1.0f, 0.5f, 45.0f);
        Quat4f.set(q1, 1, q, 0);
        Quat4f.set(q2, 2, q1, 1);
        int i = 0;
        while (i < 4) {
            q2[i + 2] = -q2[i + 2];
            ++i;
        }
        Assert.assertTrue((boolean)Quat4f.epsilonRotationEquivalent(q1, 1, q2, 2, 1.0E-6f));
    }

    @Test
    public void setFromAxisAngle4f() {
        float[] aa = new float[4];
        float[] q = new float[4];
        Quat4f.set(aa, 2.0f, 0.0f, 0.0f, 1.0f);
        Quat4f.setFromAxisAngle4f(q, aa);
        Assert.assertTrue(((double)Quat4f.length(q) < 1.000001 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Quat4f.length(q) > 0.999999 ? 1 : 0) != 0);
        Quat4f.set(aa, 2.0f, 0.0f, 0.0f, 10.0f);
        Quat4f.setFromAxisAngle4f(q, aa);
        Assert.assertTrue(((double)Quat4f.length(q) < 1.000001 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Quat4f.length(q) > 0.999999 ? 1 : 0) != 0);
        Quat4f.set(aa, 1.0f, 0.0f, 0.0f, 2.0f);
        Quat4f.setFromAxisAngle4f(q, aa);
        Assert.assertTrue(((double)Quat4f.length(q) < 1.000001 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Quat4f.length(q) > 0.999999 ? 1 : 0) != 0);
    }

    @Test
    public void setFromEulerAngles() {
    }

    @Test
    public void testExpAndLog() {
        float[] q = new float[4];
        float[] q2 = new float[4];
        float[] v = new float[3];
        float[] v2 = new float[3];
        Vec3f.set(v, 0.0f, 0.0f, 0.0f);
        Quat4f.exp(q, v);
        Assert.assertTrue((boolean)Quat4f.isIdentity(q));
        Quat4f.setFromAxisAngle4f(q, 1.0f, 0.0f, 0.0f, 0.01f);
        Vec3f.set(v2, 0.01f, 0.0f, 0.0f);
        Quat4f.log(v, q);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(v, v2, 1.0E-7f));
        Quat4f.setIdentity(q);
        Quat4f.log(v, q);
        Vec3f.set(v2, 0.0f, 0.0f, 0.0f);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(v, v2, 1.0E-7f));
        Quat4f.setFromAxisAngle4f(q, 1.0f, 0.0f, 0.0f, 1.0E-5f);
        Vec3f.set(v2, 1.0E-5f, 0.0f, 0.0f);
        Quat4f.log(v, q);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(v, v2, 1.0E-7f));
        Quat4f.setFromAxisAngle4f(q, 0.4f, 0.2f, 0.8f, 0.54f);
        Quat4f.log(v, q);
        Quat4f.exp(q2, v);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q, q2, 1.0E-7f));
    }

    @Test
    public void setFromMat3f() {
        float[] m = new float[9];
        float[] q1 = new float[4];
        float[] q2 = new float[4];
        float[] aa = new float[4];
        Vec4f.set(aa, 1.0f, 0.0f, 0.0f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat3f.setFromAxisAngleScale(m, aa, 1.0f);
        Quat4f.setFromMat3f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
        Vec4f.set(aa, 0.0f, 1.0f, 0.0f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat3f.setFromAxisAngleScale(m, aa, 1.0f);
        Quat4f.setFromMat3f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
        Vec4f.set(aa, 0.0f, 0.0f, 1.0f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat3f.setFromAxisAngleScale(m, aa, 1.0f);
        Quat4f.setFromMat3f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
        Vec4f.set(aa, 0.5f, 0.3f, 0.4f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat3f.setFromAxisAngleScale(m, aa, 1.0f);
        Quat4f.setFromMat3f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
    }

    @Test
    public void setFromMat4f() {
        float[] m = new float[16];
        float[] q1 = new float[4];
        float[] q2 = new float[4];
        float[] aa = new float[4];
        Mat4f.setIdentity(m);
        Vec4f.set(aa, 1.0f, 0.0f, 0.0f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat4f.setRotation(m, q1);
        Quat4f.setFromMat4f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
        Vec4f.set(aa, 0.0f, 1.0f, 0.0f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat4f.setRotation(m, q1);
        Quat4f.setFromMat4f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
        Vec4f.set(aa, 0.0f, 0.0f, 1.0f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat4f.setRotation(m, q1);
        Quat4f.setFromMat4f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
        Vec4f.set(aa, 0.5f, 0.3f, 0.4f, (float)Math.PI);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat4f.setRotation(m, q1);
        Quat4f.setFromMat4f(q2, m);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, q2, 0.001f));
    }

    @Test
    public void setFromVectors() {
        float[] a = Vec3f.getVec3f(1.0f, 0.0f, 0.0f);
        float[] b = Vec3f.getVec3f(0.0f, 1.0f, 0.0f);
        float[] q = Quat4f.getQuat4f();
        Quat4f.setFromVectors(q, a, b);
        Quat4f.transformVec3f(q, a);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, b, 1.0E-7f));
        Vec3f.set(a, 0.0f, 1.0f, 0.0f);
        Vec3f.set(b, 0.0f, 0.0f, 1.0f);
        Quat4f.setFromVectors(q, a, b);
        Quat4f.transformVec3f(q, a);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, b, 1.0E-7f));
        Vec3f.set(a, 0.0f, 0.0f, 1.0f);
        Vec3f.set(b, 1.0f, 0.0f, 0.0f);
        Quat4f.setFromVectors(q, a, b);
        Quat4f.transformVec3f(q, a);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, b, 1.0E-7f));
        Vec3f.set(a, 1.0f, 0.0f, 0.0f);
        Vec3f.set(b, 0.0f, -1.0f, 0.0f);
        Quat4f.setFromVectors(q, a, b);
        Quat4f.transformVec3f(q, a);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, b, 1.0E-7f));
        Vec3f.set(a, 0.25f, 0.0f, 0.0f);
        Vec3f.set(b, 0.0f, -1.0f, 0.0f);
        Quat4f.setFromVectors(q, a, b);
        Quat4f.transformVec3f(q, a);
        Vec3f.scale(4.0f, a);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(a, b, 1.0E-7f));
    }

    @Test
    public void add() {
        float[] a4 = new float[]{3.003f, 4.004f, 5.005f, 6.006f};
        float[] b4 = new float[]{1.0f, 6.0f, 3.0f, 4.0f};
        float[] expect4 = new float[]{4.003f, 10.004f, 8.005f, 10.006f};
        Quat4f.add(a4, b4);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(a4, expect4, 1.0E-6f));
    }

    @Test
    public void sub() {
        float[] a4 = new float[]{3.003f, 4.004f, 5.005f, 8.006f};
        float[] b4 = new float[]{1.0f, 6.0f, 3.0f, 4.0f};
        float[] expect4 = new float[]{2.003f, -1.996f, 2.005f, 4.006f};
        Quat4f.sub(a4, b4);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(a4, expect4, 1.0E-6f));
    }

    @Test
    public void equals() {
        float[] a4 = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        float[] b4 = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        float[] c4 = new float[]{2.0f, 2.0f, 3.0f, 4.0f};
        float[] d4 = new float[]{1.0f, 4.0f, 3.0f, 4.0f};
        float[] e4 = new float[]{1.0f, 2.0f, 6.0f, 4.0f};
        float[] f4 = new float[]{1.0f, 2.0f, 3.0f, 5.0f};
        Assert.assertTrue((boolean)Quat4f.equals(a4, b4));
        Assert.assertTrue((!Quat4f.equals(a4, c4) ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.equals(a4, d4) ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.equals(a4, e4) ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.equals(a4, f4) ? 1 : 0) != 0);
    }

    @Test
    public void epsilonEquals() {
        float[] a4 = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        float[] b4 = new float[]{1.01f, 2.02f, 3.03f, 4.04f};
        float[] c4 = new float[]{2.0f, 2.0f, 3.0f, 4.0f};
        float[] d4 = new float[]{1.0f, 4.0f, 3.0f, 4.0f};
        float[] e4 = new float[]{1.0f, 2.0f, 6.0f, 4.0f};
        float[] f4 = new float[]{1.0f, 2.0f, 3.0f, 5.0f};
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(a4, b4, 0.05f));
        Assert.assertTrue((!Quat4f.epsilonEquals(a4, b4, 0.02f) ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.epsilonEquals(a4, c4, 0.1f) ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.epsilonEquals(a4, d4, 0.1f) ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.epsilonEquals(a4, e4, 0.1f) ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.epsilonEquals(a4, f4, 0.1f) ? 1 : 0) != 0);
    }

    @Test
    public void set() {
        float[] a4 = new float[4];
        float[] expect4 = new float[]{2.0f, 1.0f, 6.0f, 4.0f};
        Quat4f.set(a4, 2.0f, 1.0f, 6.0f, 4.0f);
        Assert.assertTrue((boolean)Quat4f.equals(a4, expect4));
    }

    @Test
    public void setIdentity() {
        float[] a4 = new float[4];
        float[] expect4 = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
        Quat4f.setIdentity(a4);
        Assert.assertTrue((boolean)Quat4f.equals(a4, expect4));
    }

    @Test
    public void mul() {
        float[] qRotY180 = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        float[] qRotZ180 = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float cos45 = (float)Math.cos(0.7853981633974483);
        float sin45 = (float)Math.sin(0.7853981633974483);
        float[] qRotY90 = new float[]{cos45, 0.0f, sin45, 0.0f};
        float[] qRotZ90 = new float[]{cos45, 0.0f, 0.0f, sin45};
        float[] expect = new float[4];
        float[] result = new float[4];
        Quat4f.mul(result, qRotY180, qRotZ180);
        Quat4f.set(expect, 0.0f, 1.0f, 0.0f, 0.0f);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(result, expect, 1.0E-5f));
        Quat4f.mul(result, qRotZ180, qRotY180);
        Quat4f.set(expect, 0.0f, -1.0f, 0.0f, 0.0f);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(result, expect, 1.0E-5f));
        Quat4f.mul(result, qRotY90, qRotZ90);
        Quat4f.set(expect, 0.5f, 0.5f, 0.5f, 0.5f);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(result, expect, 1.0E-5f));
        Quat4f.mul(result, qRotZ90, qRotY90);
        Quat4f.set(expect, 0.5f, -0.5f, 0.5f, 0.5f);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(result, expect, 1.0E-5f));
        float[] q1 = new float[]{1.0f, 2.0f, 3.0f, 4.0f};
        float[] q2 = new float[]{5.0f, 6.0f, 7.0f, 8.0f};
        float[] expect3 = new float[]{-60.0f, 12.0f, 30.0f, 24.0f};
        Quat4f.mul(result, q1, q2);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(result, expect3, 1.0E-5f));
        Quat4f.mul(q1, q2);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q1, expect3, 1.0E-5f));
        float[] q11 = new float[]{88.0f, 99.0f, 1.0f, 2.0f, 3.0f, 4.0f};
        float[] q22 = new float[]{77.0f, 5.0f, 6.0f, 7.0f, 8.0f};
        float[] expect33 = new float[]{-60.0f, 12.0f, 30.0f, 24.0f};
        float[] resultr = new float[10];
        Quat4f.mul(resultr, 5, q11, 2, q22, 1);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(resultr, 5, expect33, 0, 1.0E-5f));
    }

    @Test
    public void conjugate() {
        float[] a1 = new float[]{1.0f, 3.0f, 2.0f, 1.0f, 6.0f, 4.0f, 88.0f};
        float[] expect1 = new float[]{2.0f, -1.0f, -6.0f, -4.0f};
        Quat4f.conjugate(a1, 2);
        Assert.assertTrue((boolean)Quat4f.equals(a1, 2, expect1, 0));
        float[] a2 = new float[]{2.0f, 1.0f, 6.0f, 4.0f};
        float[] expect2 = new float[]{2.0f, -1.0f, -6.0f, -4.0f};
        Quat4f.conjugate(a2);
        Assert.assertTrue((boolean)Quat4f.equals(a2, expect2));
        float[] a3 = new float[]{2.0f, 1.0f, 6.0f, 4.0f};
        float[] b3 = new float[4];
        float[] expect3 = new float[]{2.0f, -1.0f, -6.0f, -4.0f};
        Quat4f.conjugate(b3, a3);
        Assert.assertTrue((boolean)Quat4f.equals(b3, expect3));
    }

    @Test
    public void mulConjugateRight() {
        float[] q0 = new float[4];
        float[] q1 = new float[4];
        float[] qRes = new float[4];
        Quat4f.setFromAxisAngle4f(q0, 0.2f, 0.4f, 0.8f, 0.78f);
        Quat4f.setFromAxisAngle4f(q1, 0.34f, 0.1f, 0.2f, 0.3f);
        Quat4f.mulConjugateRight(qRes, q0, q1);
        Quat4f.conjugate(q1);
        Quat4f.mul(q0, q1);
        Assert.assertTrue((boolean)Quat4f.equals(q0, qRes));
        Quat4f.setFromAxisAngle4f(q0, 0.8f, 0.21f, 0.3f, 1.0f);
        Quat4f.mulConjugateRight(q0, q0);
        System.out.println(Quat4f.toString(q0));
        Quat4f.setIdentity(q1);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q0, q1, 1.0E-6f));
    }

    @Test
    public void inverse() {
    }

    @Test
    public void normalize() {
    }

    @Test
    public void interpolate() {
    }

    @Test
    public void transformVec3() {
    }

    @Test
    public void pow() {
        float[] qin = new float[4];
        float[] qout = new float[4];
        float[] q1 = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
        float[] aa = new float[]{1.0f, 0.0f, 0.0f, 2.0f};
        Quat4f.setFromAxisAngle4f(qin, aa);
        Quat4f.pow(qout, 1.0f, qin);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(qin, qout, 1.0E-7f));
        Assert.assertTrue(((double)Quat4f.length(qout) < 1.000001 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Quat4f.length(qout) > 0.999999 ? 1 : 0) != 0);
        Quat4f.pow(qout, 0.0f, qin);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(qout, q1, 1.0E-11f));
        Quat4f.pow(qout, 10.0f, qin);
        Assert.assertTrue(((double)Quat4f.length(qout) < 1.000001 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Quat4f.length(qout) > 0.999999 ? 1 : 0) != 0);
        Assert.assertTrue((!Quat4f.epsilonEquals(qout, qin, 1.0E-11f) ? 1 : 0) != 0);
        Quat4f.set(qin, 1.0f, 0.0f, 0.0f, 0.0f);
        Quat4f.pow(qout, 10.0f, qin);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(qout, qin, 1.0E-11f));
    }

    @Test
    public void setAngularVelocityFromQuat4f() {
        float[] avel = new float[3];
        float[] q = new float[4];
        float[] qrate = new float[4];
        Quat4f.setFromAxisAngle4f(q, 1.0f, 1.0f, 0.0f, 2.0f);
        Vec4f.set(qrate, 0.1f, 0.1f, 0.01f, 1.0E-4f);
        Quat4f.setAngularVelocityFromQuat4f(avel, q, qrate);
        Quat4f.conjugate(q);
        Quat4f.mul(qrate, q);
        Vec4f.scale(2.0f, qrate);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(qrate, 1, avel, 0, 1.0E-4f));
        float[] qv = new float[4000];
        float[] qvdiff = new float[4000];
        float[] av = new float[3];
        int i = 0;
        while (i < 1000) {
            Quat4f.setFromAxisAngle4f(qv, i * 4, 1.0f, 0.0f, 0.0f, 1.5f * (float)Math.sin((float)i * 0.01f));
            ++i;
        }
        NumMath.diff(qvdiff, qv, 0.01f, 4);
        i = 0;
        while (i < 999) {
            Quat4f.setAngularVelocityFromQuat4f(avel, 0, qv, i * 4, qvdiff, i * 4);
            Vec3f.set(av, 1.5f * (float)Math.cos((float)i * 0.01f), 0.0f, 0.0f);
            Assert.assertTrue((boolean)Vec3f.epsilonEquals(av, avel, 8.0E-5f));
            ++i;
        }
    }

    @Test
    public void setAngularAccelerationFromQuat4f() {
        float[] aacc = new float[3];
        float[] q = new float[4];
        float[] qrate = new float[4];
        float[] qratediff = new float[4];
        Quat4f.setFromAxisAngle4f(q, 1.0f, 1.0f, 0.0f, 2.0f);
        Vec4f.set(qrate, 0.1f, 0.1f, 0.01f, 1.0E-4f);
        Vec4f.set(qratediff, 0.2f, 0.4f, -0.01f, 2.0E-4f);
        Quat4f.setAngularAccelerationFromQuat4f(aacc, q, qratediff);
        float[] qinv = new float[4];
        float[] qRes = new float[4];
        Quat4f.conjugate(qinv, q);
        Quat4f.mul(qRes, qratediff, qinv);
        Vec4f.scale(2.0f, qRes);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(qRes, 1, aacc, 0, 1.0E-4f));
        float[] qv = new float[4000];
        float[] qvdiff = new float[4000];
        float[] qvdiff2 = new float[4000];
        float[] ac = new float[3];
        int i = 0;
        while (i < 1000) {
            Quat4f.setFromAxisAngle4f(qv, i * 4, 1.0f, 0.0f, 0.0f, 1.5f * (float)Math.sin((float)i * 0.01f));
            ++i;
        }
        NumMath.diff(qvdiff, qv, 0.01f, 4);
        NumMath.diff2(qvdiff2, qv, 0.01f, 4);
        i = 1;
        while (i < 999) {
            Quat4f.setAngularAccelerationFromQuat4f(aacc, 0, qv, i * 4, qvdiff2, i * 4);
            Vec3f.set(ac, -1.5f * (float)Math.sin((float)i * 0.01f), 0.0f, 0.0f);
            Assert.assertTrue((boolean)Vec3f.epsilonEquals(aacc, ac, 0.02f));
            ++i;
        }
        i = 0;
        while (i < 1000) {
            Quat4f.setFromAxisAngle4f(qv, i * 4, 0.0f, 1.0f, 0.0f, 1.5f * (float)Math.sin((float)i * 0.01f));
            ++i;
        }
        NumMath.diff(qvdiff, qv, 0.01f, 4);
        NumMath.diff2(qvdiff2, qv, 0.01f, 4);
        i = 1;
        while (i < 999) {
            Quat4f.setAngularAccelerationFromQuat4f(aacc, 0, qv, i * 4, qvdiff2, i * 4);
            Vec3f.set(ac, 0.0f, -1.5f * (float)Math.sin((float)i * 0.01f), 0.0f);
            Assert.assertTrue((boolean)Vec3f.epsilonEquals(aacc, ac, 0.02f));
            ++i;
        }
        i = 1;
        while (i < 1000) {
            Quat4f.setFromAxisAngle4f(qv, i * 4, 0.0f, 0.0f, 1.0f, 1.5f * (float)Math.sin((float)i * 0.01f));
            ++i;
        }
        NumMath.diff(qvdiff, qv, 0.01f, 4);
        NumMath.diff2(qvdiff2, qv, 0.01f, 4);
        i = 1;
        while (i < 999) {
            Quat4f.setAngularAccelerationFromQuat4f(aacc, 0, qv, i * 4, qvdiff2, i * 4);
            Vec3f.set(ac, 0.0f, 0.0f, -1.5f * (float)Math.sin((float)i * 0.01f));
            Assert.assertTrue((boolean)Vec3f.epsilonEquals(aacc, ac, 0.02f));
            ++i;
        }
        i = 0;
        while (i < 1000) {
            Quat4f.setFromAxisAngle4f(qv, i * 4, 2.0f / ((float)(i + 1) * 0.01f), -0.05f * (float)i, 0.75f + (float)Math.sin(0.5 + (double)((float)i * 0.01f)), 1.5f * (float)Math.sin((float)i * 0.01f));
            ++i;
        }
        NumMath.diff(qvdiff, qv, 0.01f, 4);
        NumMath.diff2(qvdiff2, qv, 0.01f, 4);
        float[] aVel = new float[3000];
        float[] aVelDiff = new float[3000];
        int i2 = 0;
        while (i2 < 999) {
            Quat4f.setAngularVelocityFromQuat4f(aVel, i2 * 3, qv, i2 * 4, qvdiff, i2 * 4);
            ++i2;
        }
        NumMath.diff(aVelDiff, aVel, 0.01f, 3);
        i2 = 2;
        while (i2 < 998) {
            Quat4f.setAngularAccelerationFromQuat4f(aacc, 0, qv, i2 * 4, qvdiff2, i2 * 4);
            Assert.assertTrue((boolean)Vec3f.epsilonEquals(aVelDiff, i2 * 3, aacc, 0, 0.025f));
            ++i2;
        }
    }

    @Test
    public void lengthSq() {
    }

    @Test
    public void length() {
    }
}

