/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.math.Vec4f;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Mat4fTest {
    float[] m;
    float[] m1;
    float[] m2;
    float[] mexpect;

    @Before
    public void setUp() {
        this.m = new float[16];
        this.m1 = new float[16];
        this.m2 = new float[16];
        this.mexpect = new float[16];
    }

    public void initZero(float[] m) {
        Mat4f.set(m, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public void initId(float[] m) {
        Mat4f.set(m, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void init1(float[] m) {
        Mat4f.set(m, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f, 16.0f);
    }

    public void showM() {
        System.out.println("m=\n" + Mat4f.toString(this.m));
    }

    public void showMexpect() {
        System.out.println("mexpect=\n" + Mat4f.toString(this.mexpect));
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testScale() {
        this.init1(this.m);
        Mat4f.scale(this.m, 2.0f);
        Mat4f.set(this.mexpect, 2.0f, 4.0f, 6.0f, 4.0f, 10.0f, 12.0f, 14.0f, 8.0f, 18.0f, 20.0f, 22.0f, 12.0f, 13.0f, 14.0f, 15.0f, 16.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
    }

    @Test
    public void testFrom3x3() {
        float[] m3x3 = new float[9];
        Mat3f.set(m3x3, 1.0f, 2.0f, 3.0f, 5.0f, 6.0f, 7.0f, 9.0f, 10.0f, 11.0f);
        float[] mexpect = new float[16];
        Mat4f.set(mexpect, 1.0f, 2.0f, 3.0f, 0.0f, 5.0f, 6.0f, 7.0f, 0.0f, 9.0f, 10.0f, 11.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        float[] m4x4 = Mat4f.from3x3(m3x3);
        Assert.assertTrue((boolean)Mat4f.equals(m4x4, mexpect));
    }

    @Test
    public void testGetScalingMatrix() {
        float[] scale = new float[]{2.0f, 3.0f, 4.0f};
        this.m = Mat4f.getScalingMatrix(scale);
        Mat4f.set(this.mexpect, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
    }

    @Test
    public void testGetTranslationMatrix() {
        float[] trans = new float[]{2.0f, 3.0f, 4.0f};
        this.m = Mat4f.getTranslationMatrix(trans);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 1.0f, 0.0f, 3.0f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
    }

    @Test
    public void testSetFloatArrayFloatArray() {
        this.initZero(this.m1);
        this.init1(this.m2);
        this.init1(this.mexpect);
        Mat4f.set(this.m1, this.m2);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m1, this.mexpect, 1.0E-4f));
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m2, this.mexpect, 1.0E-4f));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSkewMatrixErrorArguments1() {
        float angle = 90.0f;
        float[] rvec = new float[]{0.0f, 1.0f, 0.0f};
        float[] tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSkewMatrixErrorArguments2() {
        float angle = -90.0f;
        float[] rvec = new float[]{0.0f, 1.0f, 0.0f};
        float[] tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testGetSkewMatrixBasics() {
        float angle = 0.0f;
        float[] rvec = new float[]{0.0f, 1.0f, 0.0f};
        float[] tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(null, angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        angle = 45.0f;
        rvec = new float[]{0.0f, 1.0f, 0.0f};
        tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        angle = 60.0f;
        rvec = new float[]{0.0f, 1.0f, 0.0f};
        tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        float rt3 = (float)Math.sqrt(3.0);
        Mat4f.set(this.mexpect, 1.0f, rt3, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        angle = 89.0f;
        rvec = new float[]{0.0f, 1.0f, 0.0f};
        tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 57.289f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 0.01f));
        angle = 45.0f;
        rvec = new float[]{0.0f, 0.0f, 1.0f};
        tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        angle = 45.0f;
        rvec = new float[]{1.0f, 0.0f, 0.0f};
        tvec = new float[]{0.0f, 1.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        angle = -45.0f;
        rvec = new float[]{1.0f, 0.0f, 0.0f};
        tvec = new float[]{0.0f, 1.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
    }

    @Test
    public void testGetSkewMatrixNonOrthogonal() {
        float angle = 15.0f;
        float[] rvec = new float[]{1.0f, 1.0f, 0.0f};
        float[] tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        float rt3 = (float)Math.sqrt(3.0);
        Mat4f.set(this.mexpect, 1.0f, rt3 - 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        angle = 90.0f;
        rvec = new float[]{-1.0f, 1.0f, 0.0f};
        tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 2.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        angle = 105.0f;
        rvec = new float[]{-1.0f, 1.0f, 0.0f};
        tvec = new float[]{1.0f, 0.0f, 0.0f};
        this.m = Mat4f.getSkewMatrix(angle, rvec, tvec);
        Mat4f.set(this.mexpect, 1.0f, 1.0f + rt3, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
    }

    @Test
    public void testGetLookAtMatrix() {
        float[] eyePos = new float[]{0.0f, 0.0f, 0.0f};
        float[] centerPos = new float[]{0.0f, 0.0f, -1.0f};
        float[] upVec = new float[]{0.0f, 1.0f, 0.0f};
        this.m = Mat4f.getLookAtMatrix(eyePos, centerPos, upVec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        eyePos = new float[]{0.0f, 0.0f, 2.0f};
        centerPos = new float[]{0.0f, 0.0f, -1.0f};
        upVec = new float[]{0.0f, 1.0f, 0.0f};
        this.m = Mat4f.getLookAtMatrix(eyePos, centerPos, upVec);
        Mat4f.set(this.mexpect, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, -2.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
        eyePos = new float[]{2.0f, 0.0f, 0.0f};
        centerPos = new float[]{0.0f, 0.0f, 0.0f};
        upVec = new float[]{0.0f, 1.0f, 0.0f};
        this.m = Mat4f.getLookAtMatrix(eyePos, centerPos, upVec);
        Mat4f.set(this.mexpect, 0.0f, 0.0f, -1.0f, -2.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(this.m, this.mexpect, 1.0E-4f));
    }

    @Test
    public void testSetRotationFromQuat() {
        float[] m = new float[15];
        float x = 0.2f;
        float y = 0.3f;
        float z = (float)Math.sqrt(1.0f - x * x - y * y);
        float phi = 3.0f;
        float[] aa = new float[4];
        Vec4f.set(aa, x, y, z, phi);
        float[] q = new float[4];
        Quat4f.setFromAxisAngle4f(q, aa);
        Mat4f.setRotation(m, q);
        float[] qq = new float[4];
        Quat4f.setFromMat4f(qq, m);
        Assert.assertTrue((boolean)Vec4f.epsilonEquals(q, qq, 0.001f));
    }

    @Test
    public void testSetRotationFromAxisAngle() {
        float[] m = new float[15];
        float x = 0.2f;
        float y = 0.3f;
        float z = (float)Math.sqrt(1.0f - x * x - y * y);
        float phi = 3.0f;
        float[] aa = new float[4];
        Vec4f.set(aa, x, y, z, phi);
        float[] q = new float[4];
        Quat4f.setFromAxisAngle4f(q, aa);
        Mat4f.setRotation(m, q);
        float[] qq = new float[4];
        Quat4f.setFromMat4f(qq, m);
        Assert.assertTrue((boolean)Vec4f.epsilonEquals(q, qq, 0.001f));
    }

    @Test
    public void testDecomposeToVec3fQuat4Mat3f() {
        float x = 0.2f;
        float y = 0.3f;
        float z = (float)Math.sqrt(1.0f - x * x - y * y);
        float phi = 3.0f;
        float[] aa = new float[4];
        Vec4f.set(aa, x, y, z, phi);
        float[] q = new float[4];
        Quat4f.setFromAxisAngle4f(q, aa);
        Mat4f.setRotation(this.m, q);
        float[] t = new float[]{1.0f, 2.0f, 3.0f};
        Mat4f.setTranslation(this.m, t);
        float[] scalefactors = new float[]{5.0f, 6.0f, 7.0f};
        Mat4f.nonUniformScale(this.m, scalefactors);
        float[] tdc = new float[3];
        float[] qdc = new float[4];
        float[] smatrixdc = new float[9];
        float epsilon = 1.0E-4f;
        Mat4f.decomposeToTRSMat3f(this.m, tdc, qdc, smatrixdc, epsilon);
        float[] smexpected = new float[9];
        Mat3f.set(smexpected, 5.0f, 0.0f, 0.0f, 0.0f, 6.0f, 0.0f, 0.0f, 0.0f, 7.0f);
        Assert.assertTrue((boolean)Vec4f.epsilonEquals(q, qdc, 1.0E-4f));
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(t, tdc, 1.0E-7f));
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(smatrixdc, smexpected, 0.001f));
    }

    @Test
    public void testTransposeFloatArrayFloatArray() {
        float[] m1 = new float[16];
        int i = 0;
        while (i < 16) {
            m1[i] = i;
            ++i;
        }
        float[] m2 = new float[16];
        Mat4f.transpose(m2, m1);
        Mat4f.transpose(m2);
        int i2 = 0;
        while (i2 < 16) {
            Assert.assertTrue((m1[i2] == m2[i2] ? 1 : 0) != 0);
            ++i2;
        }
    }

    @Test
    public void testOrthogonalInverse() {
        float[] q = new float[4];
        float[] v = new float[]{1.0f, 2.0f, 3.0f};
        float[] m1 = new float[16];
        float[] m2 = new float[16];
        float[] m = new float[16];
        Quat4f.setFromAxisAngle4f(q, 1.0f, 1.0f, -2.0f, 1.2f);
        Mat4f.setFromTRS(m1, v, q, 1.0f);
        Mat4f.invertRigid(m2, m1);
        Mat4f.mul(m, m1, m2);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(Mat4f.ID, m, 1.0E-5f));
        Mat4f.mul(m, m2, m1);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(Mat4f.ID, m, 1.0E-5f));
        Mat4f.set(m2, m1);
        Mat4f.invertRigid(m1);
        Mat4f.mul(m, m2, m1);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(Mat4f.ID, m, 1.0E-5f));
        Mat4f.mul(m, m1, m2);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(Mat4f.ID, m, 1.0E-5f));
    }

    @Test
    public void testAffineInverse() {
        float[] m = Mat4f.getMat4f();
        float[] m_inv = Mat4f.getMat4f();
        float[] m_scale = Mat4f.getIdentity();
        float[] m_rotate = Mat4f.getIdentity();
        float[] m_scale_inv = Mat4f.getIdentity();
        float[] m_rotate_inv = Mat4f.getIdentity();
        float[] m_expected = Mat4f.getMat4f();
        float[] axis = new float[]{2.0f, 3.0f, 1.0f};
        float angle = 30.0f;
        float[] scale_factors = new float[]{33.0f, 22.0f, 55.0f};
        float[] scale_factors_inv = new float[]{0.030303031f, 0.045454547f, 0.018181818f};
        Mat4f.setRotationFromAxisAngleDegrees(m_rotate, axis, angle);
        Mat4f.setRotationFromAxisAngleDegrees(m_rotate_inv, axis, -angle);
        Mat4f.nonUniformScale(m_scale, scale_factors);
        Mat4f.nonUniformScale(m_scale_inv, scale_factors_inv);
        Mat4f.mul(m, m_rotate, m_scale);
        Mat4f.mul(m_expected, m_scale_inv, m_rotate_inv);
        Mat4f.invertAffine(m_inv, m);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(m_inv, m_expected, 1.0E-7f));
    }

    @Test
    public void testTranformAffineMatrix() {
        float[] m = new float[16];
        float[] m_expected = new float[16];
        float[] A = new float[16];
        float[] X_axis = new float[]{1.0f, 0.0f, 0.0f};
        float[] Y_axis = new float[]{0.0f, 1.0f, 0.0f};
        float[] Z_axis = new float[]{0.0f, 0.0f, 1.0f};
        float hpi = 1.5707964f;
        float qpi = 0.7853982f;
        Mat4f.setIdentity(A);
        Mat4f.setRotationFromAxisAngle(m, Y_axis, qpi);
        Mat4f.set(m_expected, m);
        Mat4f.transformAffineMatrix(A, m);
        Assert.assertTrue((boolean)Mat4f.equals(m, m_expected));
        Mat4f.setRotationFromAxisAngle(A, X_axis, -hpi);
        Mat4f.setRotationFromAxisAngle(m, Y_axis, qpi);
        Mat4f.setRotationFromAxisAngle(m_expected, Z_axis, -qpi);
        Mat4f.transformAffineMatrix(A, m);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(m, m_expected, 1.0E-6f));
    }
}

