/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.math.Vec4f;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Mat3fTest {
    public float[] m;
    public float[] mexpect;

    @Before
    public void setUp() {
        this.m = new float[9];
        this.mexpect = new float[9];
    }

    @After
    public void tearDown() {
    }

    @Test
    public void set() {
    }

    @Test
    public void setFromQuatScale() {
        float[] m = new float[9];
        float x = 0.2f;
        float y = 0.3f;
        float z = (float)Math.sqrt(1.0f - x * x - y * y);
        float phi = 3.0f;
        float[] aa = new float[4];
        Vec4f.set(aa, x, y, z, phi);
        float[] q = new float[4];
        Quat4f.setFromAxisAngle4f(q, aa);
        Mat3f.setFromQuatScale(m, q, 1.0f);
        float[] qq = new float[4];
        Quat4f.setFromMat3f(qq, m);
        Assert.assertTrue((boolean)Vec4f.epsilonEquals(q, qq, 0.001f));
    }

    @Test
    public void setFromAxisAngleScale() {
        float[] m = new float[9];
        float[] m1 = new float[9];
        float[] m2 = new float[9];
        float[] aa = new float[]{0.55f, 0.55f, 0.55f, 3.1415f};
        float[] q1 = new float[4];
        Mat3f.setFromAxisAngleScale(m, aa, 1.0f);
        Vec4f.set(aa, 0.5f, 0.3f, 0.4f, (float)Math.PI);
        Mat3f.setFromAxisAngleScale(m1, aa, 1.0f);
        Quat4f.setFromAxisAngle4f(q1, aa);
        Mat3f.setFromQuatScale(m2, q1, 1.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(m1, m2, 0.001f));
    }

    @Test
    public void setZero() {
    }

    @Test
    public void setIdentity() {
    }

    @Test
    public void setElement() {
    }

    @Test
    public void getElement() {
    }

    @Test
    public void getRow() {
    }

    @Test
    public void getColumn() {
    }

    @Test
    public void mul() {
    }

    public void showM() {
        System.out.println("m=\n" + Mat3f.toString(this.m));
    }

    public void showMexpect() {
        System.out.println("mexpect=\n" + Mat3f.toString(this.mexpect));
    }

    @Test
    public void transform() {
    }

    @Test
    public void testFrom4x4() {
        float[] m4x4 = new float[16];
        Mat4f.set(m4x4, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f, 12.0f, 13.0f, 14.0f, 15.0f, 16.0f);
        float[] m3x3 = Mat3f.from4x4(m4x4);
        float[] mexpect = new float[9];
        Mat3f.set(mexpect, 1.0f, 2.0f, 3.0f, 5.0f, 6.0f, 7.0f, 9.0f, 10.0f, 11.0f);
        Assert.assertTrue((boolean)Mat3f.equals(m3x3, mexpect));
    }

    @Test
    public void testAdjugate_transpose() {
        Mat3f.set(this.m, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f);
        float[] adj = new float[9];
        float det = Mat3f.adjugateTranspose(adj, this.m);
        Mat3f.set(this.mexpect, -3.0f, 6.0f, -3.0f, 6.0f, -12.0f, 6.0f, -3.0f, 6.0f, -3.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(adj, this.mexpect, 0.001f));
        float detExpect = 0.0f;
        Assert.assertTrue(((double)Math.abs(det - detExpect) < 1.0E-4 ? 1 : 0) != 0);
        Mat3f.set(this.m, 1.0f, 2.0f, 1.0f, 3.0f, 2.0f, 1.0f, 1.0f, 2.0f, 3.0f);
        det = Mat3f.adjugateTranspose(adj, this.m);
        Mat3f.set(this.mexpect, 4.0f, -8.0f, 4.0f, -4.0f, 2.0f, 0.0f, 0.0f, 2.0f, -4.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(adj, this.mexpect, 0.001f));
        detExpect = -8.0f;
        Assert.assertTrue(((double)Math.abs(det - detExpect) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testAdjugate_transposeMat4f() {
        float[] m4 = Mat4f.getMat4f();
        Mat4f.set(m4, 1.0f, 2.0f, 3.0f, 66.6f, 4.0f, 5.0f, 6.0f, 66.6f, 7.0f, 8.0f, 9.0f, 66.6f, 66.6f, 66.6f, 66.6f, 66.6f);
        float[] adj = new float[9];
        float det = Mat3f.adjugateTransposeMat4f(adj, m4);
        Mat3f.set(this.mexpect, -3.0f, 6.0f, -3.0f, 6.0f, -12.0f, 6.0f, -3.0f, 6.0f, -3.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(adj, this.mexpect, 0.001f));
        float detExpect = 0.0f;
        Assert.assertTrue(((double)Math.abs(det - detExpect) < 1.0E-4 ? 1 : 0) != 0);
        Mat4f.set(m4, 1.0f, 2.0f, 1.0f, 66.6f, 3.0f, 2.0f, 1.0f, 66.6f, 1.0f, 2.0f, 3.0f, 66.6f, 66.6f, 66.6f, 66.6f, 66.6f);
        det = Mat3f.adjugateTransposeMat4f(adj, m4);
        Mat3f.set(this.mexpect, 4.0f, -8.0f, 4.0f, -4.0f, 2.0f, 0.0f, 0.0f, 2.0f, -4.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(adj, this.mexpect, 0.001f));
        detExpect = -8.0f;
        Assert.assertTrue(((double)Math.abs(det - detExpect) < 1.0E-4 ? 1 : 0) != 0);
    }

    @Test
    public void testNorm() {
        Mat3f.set(this.m, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 1.0f, 2.0f, 3.0f, 2.0f);
        float n_1 = Mat3f.norm1(this.m);
        float n_2 = Mat3f.norm2(this.m);
        float n_inf = Mat3f.normInf(this.m);
        Assert.assertTrue((n_1 == 23.0f ? 1 : 0) != 0);
        Assert.assertTrue((n_inf == 5.0f ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(n_2 - 8.544f) < 0.001 ? 1 : 0) != 0);
    }

    @Test
    public void testAdjugate() {
        Mat3f.set(this.m, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f);
        float[] adj = new float[9];
        float det = Mat3f.adjugate(adj, this.m);
        Mat3f.set(this.mexpect, -3.0f, 6.0f, -3.0f, 6.0f, -12.0f, 6.0f, -3.0f, 6.0f, -3.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(adj, this.mexpect, 0.001f));
        float detExpect = 0.0f;
        Assert.assertTrue(((double)Math.abs(det - detExpect) < 0.001 ? 1 : 0) != 0);
        Mat3f.set(this.m, 1.0f, 2.0f, 1.0f, 3.0f, 2.0f, 1.0f, 1.0f, 2.0f, 3.0f);
        det = Mat3f.adjugate(adj, this.m);
        Mat3f.set(this.mexpect, 4.0f, -4.0f, 0.0f, -8.0f, 2.0f, 2.0f, 4.0f, 0.0f, -4.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(adj, this.mexpect, 0.001f));
        detExpect = -8.0f;
        Assert.assertTrue(((double)Math.abs(det - detExpect) < 0.001 ? 1 : 0) != 0);
    }

    @Test
    public void testPolarDecompose() {
        float ca = (float)Math.cos(0.6);
        float sa = (float)Math.sin(0.6);
        Mat3f.set(this.m, 1.0f, 0.0f, 0.0f, 0.0f, ca, -sa, 0.0f, sa, ca);
        float[] Q = new float[9];
        float[] S = new float[9];
        float[] Qexpect = new float[9];
        float[] Sexpect = new float[9];
        Mat3f.set(Qexpect, 1.0f, 0.0f, 0.0f, 0.0f, ca, -sa, 0.0f, sa, ca);
        Mat3f.set(Sexpect, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        float epsilon = 1.0E-4f;
        Mat3f.polarDecompose(this.m, Q, S);
        Mat3f.ScalingType scaleType = Mat3f.getScalingType(S);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(Q, Qexpect, 0.001f));
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(S, Sexpect, 0.001f));
        Assert.assertTrue((scaleType == Mat3f.ScalingType.IDENTITY ? 1 : 0) != 0);
        float[] scales = new float[]{2.0f, 3.0f, 4.0f};
        float[] scale = Mat3f.getScalingMatrix(scales);
        Mat3f.mul(this.m, scale);
        Mat3f.set(Qexpect, 1.0f, 0.0f, 0.0f, 0.0f, ca, -sa, 0.0f, sa, ca);
        Mat3f.set(Sexpect, 2.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 4.0f);
        Mat3f.polarDecompose(this.m, Q, S);
        scaleType = Mat3f.getScalingType(S);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(Q, Qexpect, 0.001f));
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(S, Sexpect, 0.001f));
        Assert.assertTrue((scaleType == Mat3f.ScalingType.ALIGNED ? 1 : 0) != 0);
        Mat3f.set(this.m, 1.0f, 0.0f, 0.0f, 0.0f, ca, -sa, 0.0f, sa, ca);
        scales = new float[]{777.0f, 777.0f, 777.0f};
        scale = Mat3f.getScalingMatrix(scales);
        Mat3f.mul(this.m, scale);
        Mat3f.set(Qexpect, 1.0f, 0.0f, 0.0f, 0.0f, ca, -sa, 0.0f, sa, ca);
        Mat3f.set(Sexpect, 777.0f, 0.0f, 0.0f, 0.0f, 777.0f, 0.0f, 0.0f, 0.0f, 777.0f);
        Mat3f.polarDecompose(this.m, Q, S);
        scaleType = Mat3f.getScalingType(S);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(Q, Qexpect, 0.001f));
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(S, Sexpect, 0.001f));
        Assert.assertTrue((scaleType == Mat3f.ScalingType.ALIGNED ? 1 : 0) != 0);
        Mat3f.set(this.m, 1.0f, 0.0f, 0.0f, 0.0f, ca, -sa, 0.0f, sa, ca);
        Mat3f.set(scale, 2.0f, 0.0f, 0.0f, 0.0f, 4.0f, 0.0f, 0.0f, 0.0f, 5.0f);
        float[] scaleRotation = new float[9];
        float[] inverseScaleRotation = new float[9];
        float[] axis = new float[]{1.0f, 1.0f, 1.0f};
        float angle = 0.62831855f;
        Mat3f.setFromAxisAngleScale(scaleRotation, axis, angle, 1.0f);
        Mat3f.invert(inverseScaleRotation, scaleRotation);
        Mat3f.mul(scale, scaleRotation, scale);
        Mat3f.mul(scale, scale, inverseScaleRotation);
        Mat3f.mul(this.m, scale);
        Mat3f.set(Qexpect, 1.0f, 0.0f, 0.0f, 0.0f, ca, -sa, 0.0f, sa, ca);
        scaleType = Mat3f.polarDecompose(this.m, Q, S, epsilon);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(Q, Qexpect, 0.001f));
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(S, scale, 0.001f));
        Assert.assertTrue((scaleType == Mat3f.ScalingType.SKEW ? 1 : 0) != 0);
    }

    @Test
    public void testTransformTranspose() {
        float[] a = new float[3];
        float[] b = new float[3];
        float[] m = new float[9];
        float[] mT = new float[9];
        Vec3f.set(b, 1.0f, 2.0f, 3.0f);
        float[] aa = new float[]{0.55f, 0.55f, 0.55f, 3.0f};
        Mat3f.setFromAxisAngleScale(m, aa, 1.0f);
        Mat3f.transformTranspose(m, a, b);
        Mat3f.transpose(mT, m);
        Mat3f.transformVec3f(mT, b);
        Assert.assertTrue((boolean)Vec3f.equals(a, b));
    }

    @Test
    public void getIdentity() {
        float[] result = Mat3f.getIdentity();
        Assert.assertTrue((boolean)Mat3f.isIdentity(result));
    }

    @Test
    public void skew() {
        float[] a = new float[3];
        float[] b = new float[3];
        float[] c = new float[3];
        float[] d = new float[3];
        float[] m = new float[9];
        int i = 0;
        while (i < 3) {
            a[i] = i;
            b[i] = 9 - i;
            ++i;
        }
        Mat3f.skew(m, a);
        Mat3f.transform(m, c, b);
        Vec3f.cross(d, a, b);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(c, d, 5.0E-4f));
    }

    @Test
    public void testInvert() {
        float[] m = new float[9];
        float[] minv = new float[9];
        int i = 0;
        while (i < 9) {
            m[i] = (float)Math.sqrt(i + 1);
            ++i;
        }
        float det = Mat3f.invert(minv, m);
        Mat3f.mul(m, minv);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(m, Mat3f.getIdentity(), 5.0E-4f));
        Mat3f.set(m, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f);
        det = Mat3f.invert(minv, m);
        Assert.assertTrue((det == 0.0f ? 1 : 0) != 0);
    }

    @Test
    public void mulTransposeRight() {
        float[] m = new float[9];
        float[] mT = new float[9];
        float[] dest = new float[9];
        float[] dest2 = new float[9];
        int i = 0;
        while (i < 9) {
            m[i] = i + 1;
            ++i;
        }
        i = 0;
        while (i < 9) {
            mT[i] = -i - 2;
            ++i;
        }
        Mat3f.mulTransposeRight(dest, m, mT);
        Mat3f.transpose(mT);
        Mat3f.mul(dest2, m, mT);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(dest, dest2, 5.0E-4f));
    }

    @Test
    public void transpose() {
        float[] m1 = new float[9];
        int i = 0;
        while (i < 9) {
            m1[i] = i;
            ++i;
        }
        float[] m2 = new float[9];
        Mat3f.transpose(m2, m1);
        Mat3f.transpose(m2);
        int i2 = 0;
        while (i2 < 9) {
            Assert.assertTrue((m1[i2] == m2[i2] ? 1 : 0) != 0);
            ++i2;
        }
    }

    @Test
    public void testIsDiagonal() {
        float[] m = new float[9];
        Mat3f.set(m, 1.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 3.0f);
        Assert.assertTrue((boolean)Mat3f.isDiagonal(m, 0.01f));
        Mat3f.set(m, 1.0f, 1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 3.0f);
        Assert.assertFalse((boolean)Mat3f.isDiagonal(m, 0.01f));
        Mat3f.set(m, 1.0f, 1.0E-5f, 1.0E-6f, 1.0E-6f, 2.0f, 1.0E-6f, 1.0E-6f, 1.0E-6f, 3.0f);
        Assert.assertTrue((boolean)Mat3f.isDiagonal(m, 0.001f));
        Assert.assertFalse((boolean)Mat3f.isDiagonal(m, 1.0E-7f));
        Mat3f.set(m, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        Assert.assertTrue((boolean)Mat3f.isDiagonal(m, 0.01f));
    }

    @Test
    public void testIsSymmetric() {
        float[] m = new float[9];
        Mat3f.set(m, 1.0f, 2.0f, 3.0f, 2.0f, 4.0f, 5.0f, 3.0f, 5.0f, 6.0f);
        Assert.assertTrue((boolean)Mat3f.isSymmetric(m, 1.0E-4f));
        Mat3f.set(m, 1.0f, 6.0f, 3.0f, 2.0f, 4.0f, 5.0f, 3.0f, 5.0f, 6.0f);
        Assert.assertFalse((boolean)Mat3f.isSymmetric(m, 1.0E-4f));
        Mat3f.set(m, 1.0f, 2.0f, 7.0f, 2.0f, 4.0f, 5.0f, 3.0f, 5.0f, 6.0f);
        Assert.assertFalse((boolean)Mat3f.isSymmetric(m, 1.0E-4f));
        Mat3f.set(m, 1.0f, 6.0f, 3.0f, 2.0f, 4.0f, 8.0f, 3.0f, 5.0f, 6.0f);
        Assert.assertFalse((boolean)Mat3f.isSymmetric(m, 1.0E-4f));
    }

    @Test
    public void setRot() {
        float a = 0.7f;
        float[] q = new float[4];
        float[] m2 = new float[9];
        float[] m1 = new float[9];
        Mat3f.setXRot(m2, a);
        Quat4f.setFromAxisAngle4f(q, 1.0f, 0.0f, 0.0f, a);
        Mat3f.setFromQuatScale(m1, q, 1.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(m1, m2, 1.0E-7f));
        a = 1.0f;
        Mat3f.setYRot(m2, a);
        Quat4f.setFromAxisAngle4f(q, 0.0f, 1.0f, 0.0f, a);
        Mat3f.setFromQuatScale(m1, q, 1.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(m1, m2, 1.0E-7f));
        a = 1.0f;
        Mat3f.setZRot(m2, a);
        Quat4f.setFromAxisAngle4f(q, 0.0f, 0.0f, 1.0f, a);
        Mat3f.setFromQuatScale(m1, q, 1.0f);
        Assert.assertTrue((boolean)Mat3f.epsilonEquals(m1, m2, 1.0E-7f));
    }
}

