/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Vec3f;

public final class Mat3f {
    public static final int ROW_SIZE = 3;
    public static final int COL_SIZE = 3;
    public static final int MAT3F_SIZE = 9;
    public static final double DEGREEPERRAD = 180.0;
    public static final int M00 = 0;
    public static final int M01 = 1;
    public static final int M02 = 2;
    public static final int M10 = 3;
    public static final int M11 = 4;
    public static final int M12 = 5;
    public static final int M20 = 6;
    public static final int M21 = 7;
    public static final int M22 = 8;
    private static final float NORMALIZE_THRESHOLD = 0.001f;
    public static final float TOL = 1.0E-6f;
    private static final float POLARDECOMPOSESMOOTHFACTOR = 1.0E-4f;
    private static final float MINIMAL_SKEW_ANGLE = 1.0E-6f;

    private Mat3f() {
    }

    public static float[] getMat3f() {
        return new float[9];
    }

    @Deprecated
    public static ScalingType getScalingTypeVec3f(float[] scaleVec) {
        if (scaleVec[0] != scaleVec[1] || scaleVec[0] != scaleVec[2]) {
            return ScalingType.ALIGNED;
        }
        if (scaleVec[0] == 1.0f) {
            return ScalingType.IDENTITY;
        }
        return ScalingType.UNIFORM;
    }

    public static float[] getScalingMatrix(float[] s) {
        return new float[]{s[0], 0.0f, 0.0f, 0.0f, s[1], 0.0f, 0.0f, 0.0f, s[2]};
    }

    public static void scale(float[] m, float s) {
        m[0] = m[0] * s;
        m[1] = m[1] * s;
        m[2] = m[2] * s;
        m[3] = m[3] * s;
        m[4] = m[4] * s;
        m[5] = m[5] * s;
        m[6] = m[6] * s;
        m[7] = m[7] * s;
        m[8] = m[8] * s;
    }

    public static void scale(float[] dst, float[] src, float s) {
        dst[0] = src[0] * s;
        dst[1] = src[1] * s;
        dst[2] = src[2] * s;
        dst[3] = src[3] * s;
        dst[4] = src[4] * s;
        dst[5] = src[5] * s;
        dst[6] = src[6] * s;
        dst[7] = src[7] * s;
        dst[8] = src[8] * s;
    }

    public static void scale(float[] dst, int dstIndex, float[] src, int srcIndex, float s) {
        dst[0 + dstIndex] = src[0 + srcIndex] * s;
        dst[1 + dstIndex] = src[1 + srcIndex] * s;
        dst[2 + dstIndex] = src[2 + srcIndex] * s;
        dst[3 + dstIndex] = src[3 + srcIndex] * s;
        dst[4 + dstIndex] = src[4 + srcIndex] * s;
        dst[5 + dstIndex] = src[5 + srcIndex] * s;
        dst[6 + dstIndex] = src[6 + srcIndex] * s;
        dst[7 + dstIndex] = src[7 + srcIndex] * s;
        dst[8 + dstIndex] = src[8 + srcIndex] * s;
    }

    public static void scale(float[] m, int iIndex, float s) {
        int n = iIndex + 0;
        m[n] = m[n] * s;
        int n2 = iIndex + 1;
        m[n2] = m[n2] * s;
        int n3 = iIndex + 2;
        m[n3] = m[n3] * s;
        int n4 = iIndex + 3;
        m[n4] = m[n4] * s;
        int n5 = iIndex + 4;
        m[n5] = m[n5] * s;
        int n6 = iIndex + 5;
        m[n6] = m[n6] * s;
        int n7 = iIndex + 6;
        m[n7] = m[n7] * s;
        int n8 = iIndex + 7;
        m[n8] = m[n8] * s;
        int n9 = iIndex + 8;
        m[n9] = m[n9] * s;
    }

    public static void scale(float[] m, int iIndex, double s) {
        int n = iIndex + 0;
        m[n] = (float)((double)m[n] * s);
        int n2 = iIndex + 1;
        m[n2] = (float)((double)m[n2] * s);
        int n3 = iIndex + 2;
        m[n3] = (float)((double)m[n3] * s);
        int n4 = iIndex + 3;
        m[n4] = (float)((double)m[n4] * s);
        int n5 = iIndex + 4;
        m[n5] = (float)((double)m[n5] * s);
        int n6 = iIndex + 5;
        m[n6] = (float)((double)m[n6] * s);
        int n7 = iIndex + 6;
        m[n7] = (float)((double)m[n7] * s);
        int n8 = iIndex + 7;
        m[n8] = (float)((double)m[n8] * s);
        int n9 = iIndex + 8;
        m[n9] = (float)((double)m[n9] * s);
    }

    public static void scale(float[] m, double s) {
        m[0] = (float)((double)m[0] * s);
        m[1] = (float)((double)m[1] * s);
        m[2] = (float)((double)m[2] * s);
        m[3] = (float)((double)m[3] * s);
        m[4] = (float)((double)m[4] * s);
        m[5] = (float)((double)m[5] * s);
        m[6] = (float)((double)m[6] * s);
        m[7] = (float)((double)m[7] * s);
        m[8] = (float)((double)m[8] * s);
    }

    public static void set(float[] dst, int dstIndex, float[] src, int srcIndex) {
        int i = 0;
        while (i < 9) {
            dst[dstIndex + i] = src[srcIndex + i];
            ++i;
        }
    }

    public static void set(float[] dst, float src00, float src01, float src02, float src10, float src11, float src12, float src20, float src21, float src22) {
        dst[0] = src00;
        dst[1] = src01;
        dst[2] = src02;
        dst[3] = src10;
        dst[4] = src11;
        dst[5] = src12;
        dst[6] = src20;
        dst[7] = src21;
        dst[8] = src22;
    }

    public static void set(float[] dst, int dIndex, float src00, float src01, float src02, float src10, float src11, float src12, float src20, float src21, float src22) {
        dst[dIndex + 0] = src00;
        dst[dIndex + 1] = src01;
        dst[dIndex + 2] = src02;
        dst[dIndex + 3] = src10;
        dst[dIndex + 4] = src11;
        dst[dIndex + 5] = src12;
        dst[dIndex + 6] = src20;
        dst[dIndex + 7] = src21;
        dst[dIndex + 8] = src22;
    }

    public static void set(float[] dst, float[] src) {
        int i = 0;
        while (i < 9) {
            dst[i] = src[i];
            ++i;
        }
    }

    public static void setXRot(float[] m, float angle) {
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        m[0] = 1.0f;
        m[1] = 0.0f;
        m[2] = 0.0f;
        m[3] = 0.0f;
        m[4] = ca;
        m[5] = -sa;
        m[6] = 0.0f;
        m[7] = sa;
        m[8] = ca;
    }

    public static void setXRotDegrees(float[] m, float angle) {
        Mat3f.setXRot(m, (float)Math.toRadians(angle));
    }

    public static void setYRot(float[] m, float angle) {
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        m[0] = ca;
        m[1] = 0.0f;
        m[2] = sa;
        m[3] = 0.0f;
        m[4] = 1.0f;
        m[5] = 0.0f;
        m[6] = -sa;
        m[7] = 0.0f;
        m[8] = ca;
    }

    public static void setYRotDegrees(float[] m, float angle) {
        Mat3f.setXRot(m, (float)Math.toRadians(angle));
    }

    public static void setZRot(float[] m, float angle) {
        float ca = (float)Math.cos(angle);
        float sa = (float)Math.sin(angle);
        m[0] = ca;
        m[1] = -sa;
        m[2] = 0.0f;
        m[3] = sa;
        m[4] = ca;
        m[5] = 0.0f;
        m[6] = 0.0f;
        m[7] = 0.0f;
        m[8] = 1.0f;
    }

    public static void setZRotDegrees(float[] m, float angle) {
        Mat3f.setZRot(m, (float)Math.toRadians(angle));
    }

    public static void setFromQuatScale(float[] m, float[] q, float s) {
        m[0] = (float)((double)s * (1.0 - 2.0 * (double)q[2] * (double)q[2] - 2.0 * (double)q[3] * (double)q[3]));
        m[1] = (float)((double)s * (2.0 * (double)q[1] * (double)q[2] - 2.0 * (double)q[0] * (double)q[3]));
        m[2] = (float)((double)s * (2.0 * (double)q[0] * (double)q[2] + 2.0 * (double)q[1] * (double)q[3]));
        m[3] = (float)((double)s * (2.0 * (double)q[1] * (double)q[2] + 2.0 * (double)q[0] * (double)q[3]));
        m[4] = (float)((double)s * (1.0 - 2.0 * (double)q[1] * (double)q[1] - 2.0 * (double)q[3] * (double)q[3]));
        m[5] = (float)((double)s * (2.0 * (double)q[2] * (double)q[3] - 2.0 * (double)q[0] * (double)q[1]));
        m[6] = (float)((double)s * (2.0 * (double)q[1] * (double)q[3] - 2.0 * (double)q[0] * (double)q[2]));
        m[7] = (float)((double)s * (2.0 * (double)q[0] * (double)q[1] + 2.0 * (double)q[2] * (double)q[3]));
        m[8] = (float)((double)s * (1.0 - 2.0 * (double)q[1] * (double)q[1] - 2.0 * (double)q[2] * (double)q[2]));
    }

    public static void setFromQuatScale(float[] m, int mIndex, float[] q, int qIndex, float s) {
        m[mIndex] = (float)((double)s * (1.0 - 2.0 * (double)q[qIndex + 2] * (double)q[qIndex + 2] - 2.0 * (double)q[qIndex + 3] * (double)q[qIndex + 3]));
        m[mIndex + 1] = (float)((double)s * (2.0 * (double)q[qIndex + 1] * (double)q[qIndex + 2] - 2.0 * (double)q[qIndex + 0] * (double)q[qIndex + 3]));
        m[mIndex + 2] = (float)((double)s * (2.0 * (double)q[qIndex + 0] * (double)q[qIndex + 2] + 2.0 * (double)q[qIndex + 1] * (double)q[qIndex + 3]));
        m[mIndex + 3] = (float)((double)s * (2.0 * (double)q[qIndex + 1] * (double)q[qIndex + 2] + 2.0 * (double)q[qIndex + 0] * (double)q[qIndex + 3]));
        m[mIndex + 4] = (float)((double)s * (1.0 - 2.0 * (double)q[1] * (double)q[qIndex + 1] - 2.0 * (double)q[qIndex + 3] * (double)q[qIndex + 3]));
        m[mIndex + 5] = (float)((double)s * (2.0 * (double)q[qIndex + 2] * (double)q[qIndex + 3] - 2.0 * (double)q[qIndex + 0] * (double)q[qIndex + 1]));
        m[mIndex + 6] = (float)((double)s * (2.0 * (double)q[qIndex + 1] * (double)q[qIndex + 3] - 2.0 * (double)q[qIndex + 0] * (double)q[qIndex + 2]));
        m[mIndex + 7] = (float)((double)s * (2.0 * (double)q[qIndex + 0] * (double)q[qIndex + 1] + 2.0 * (double)q[qIndex + 2] * (double)q[qIndex + 3]));
        m[mIndex + 8] = (float)((double)s * (1.0 - 2.0 * (double)q[qIndex + 1] * (double)q[qIndex + 1] - 2.0 * (double)q[qIndex + 2] * (double)q[qIndex + 2]));
    }

    public static void setFromAxisAngleScale(float[] m, float[] axis, float angle, float scale) {
        float a0 = axis[0];
        float a1 = axis[1];
        float a2 = axis[2];
        float axisLenSq = a0 * a0 + a1 * a1 + a2 * a2;
        float qs = (float)Math.cos((double)angle / 2.0);
        float sn = (float)Math.sin((double)angle / 2.0);
        if (Math.abs(axisLenSq - 1.0f) > 0.001f) {
            sn *= (float)(1.0 / Math.sqrt(axisLenSq));
        }
        float qx = a0 * sn;
        float qy = a1 * sn;
        float qz = a2 * sn;
        m[0] = (float)((double)scale * (1.0 - 2.0 * (double)qy * (double)qy - 2.0 * (double)qz * (double)qz));
        m[1] = (float)((double)scale * (2.0 * (double)qx * (double)qy - 2.0 * (double)qs * (double)qz));
        m[2] = (float)((double)scale * (2.0 * (double)qs * (double)qy + 2.0 * (double)qx * (double)qz));
        m[3] = (float)((double)scale * (2.0 * (double)qx * (double)qy + 2.0 * (double)qs * (double)qz));
        m[4] = (float)((double)scale * (1.0 - 2.0 * (double)qx * (double)qx - 2.0 * (double)qz * (double)qz));
        m[5] = (float)((double)scale * (2.0 * (double)qy * (double)qz - 2.0 * (double)qs * (double)qx));
        m[6] = (float)((double)scale * (2.0 * (double)qx * (double)qz - 2.0 * (double)qs * (double)qy));
        m[7] = (float)((double)scale * (2.0 * (double)qs * (double)qx + 2.0 * (double)qy * (double)qz));
        m[8] = (float)((double)scale * (1.0 - 2.0 * (double)qx * (double)qx - 2.0 * (double)qy * (double)qy));
    }

    public static void setFromAxisAngleScale(float[] m, float[] aa, float scale) {
        float a0 = aa[0];
        float a1 = aa[1];
        float a2 = aa[2];
        float halfangle = aa[3] / 2.0f;
        float axisLenSq = a0 * a0 + a1 * a1 + a2 * a2;
        float qs = (float)Math.cos(halfangle);
        float sn = (float)Math.sin(halfangle);
        if (Math.abs(axisLenSq - 1.0f) > 0.001f) {
            sn *= (float)(1.0 / Math.sqrt(axisLenSq));
        }
        float qx = a0 * sn;
        float qy = a1 * sn;
        float qz = a2 * sn;
        m[0] = (float)((double)scale * (1.0 - 2.0 * (double)qy * (double)qy - 2.0 * (double)qz * (double)qz));
        m[1] = (float)((double)scale * (2.0 * (double)qx * (double)qy - 2.0 * (double)qs * (double)qz));
        m[2] = (float)((double)scale * (2.0 * (double)qs * (double)qy + 2.0 * (double)qx * (double)qz));
        m[3] = (float)((double)scale * (2.0 * (double)qx * (double)qy + 2.0 * (double)qs * (double)qz));
        m[4] = (float)((double)scale * (1.0 - 2.0 * (double)qx * (double)qx - 2.0 * (double)qz * (double)qz));
        m[5] = (float)((double)scale * (2.0 * (double)qy * (double)qz - 2.0 * (double)qs * (double)qx));
        m[6] = (float)((double)scale * (2.0 * (double)qx * (double)qz - 2.0 * (double)qs * (double)qy));
        m[7] = (float)((double)scale * (2.0 * (double)qs * (double)qx + 2.0 * (double)qy * (double)qz));
        m[8] = (float)((double)scale * (1.0 - 2.0 * (double)qx * (double)qx - 2.0 * (double)qy * (double)qy));
    }

    public static void setZero(float[] m) {
        int i = 0;
        while (i < 9) {
            m[i] = 0.0f;
            ++i;
        }
    }

    public static void setIdentity(float[] m) {
        int i = 1;
        while (i < 8) {
            m[i] = 0.0f;
            ++i;
        }
        m[0] = 1.0f;
        m[4] = 1.0f;
        m[8] = 1.0f;
    }

    public static void setIdentity(float[] m, int index) {
        int i = 1;
        while (i < 8) {
            m[i + index] = 0.0f;
            ++i;
        }
        m[0 + index] = 1.0f;
        m[4 + index] = 1.0f;
        m[8 + index] = 1.0f;
    }

    public static float[] getIdentity() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static boolean isIdentity(float[] m) {
        return m[0] == 1.0f && m[1] == 0.0f && m[2] == 0.0f && m[3] == 0.0f && m[4] == 1.0f && m[5] == 0.0f && m[6] == 0.0f && m[7] == 0.0f && m[8] == 1.0f;
    }

    public static boolean isZero(float[] m) {
        return m[0] == 0.0f && m[1] == 0.0f && m[2] == 0.0f && m[3] == 0.0f && m[4] == 0.0f && m[5] == 0.0f && m[6] == 0.0f && m[7] == 0.0f && m[8] == 0.0f;
    }

    public static void setElement(float[] m, int i, int j, float value) {
        m[3 * i + j] = value;
    }

    public static float getElement(float[] m, int i, int j) {
        return m[3 * i + j];
    }

    public static void getRow(float[] m, int i, float[] row) {
        int offset = 3 * i;
        row[0] = m[offset];
        row[1] = m[offset + 1];
        row[2] = m[offset + 2];
    }

    public static void setRow(float[] m, int i, float[] row) {
        int offset = 3 * i;
        m[offset] = row[0];
        m[offset + 1] = row[1];
        m[offset + 2] = row[2];
    }

    public static void getColumn(float[] m, int j, float[] col) {
        col[0] = m[j];
        col[1] = m[j + 3];
        col[2] = m[j + 6];
    }

    public static void mul(float[] dest, int dIndex, float[] a, int aIndex, float[] b, int bIndex) {
        float mt00 = a[aIndex + 0] * b[bIndex + 0] + a[aIndex + 1] * b[bIndex + 3] + a[aIndex + 2] * b[bIndex + 6];
        float mt01 = a[aIndex + 0] * b[bIndex + 1] + a[aIndex + 1] * b[bIndex + 4] + a[aIndex + 2] * b[bIndex + 7];
        float mt02 = a[aIndex + 0] * b[bIndex + 2] + a[aIndex + 1] * b[bIndex + 5] + a[aIndex + 2] * b[bIndex + 8];
        float mt10 = a[aIndex + 3] * b[bIndex + 0] + a[aIndex + 4] * b[bIndex + 3] + a[aIndex + 5] * b[bIndex + 6];
        float mt11 = a[aIndex + 3] * b[bIndex + 1] + a[aIndex + 4] * b[bIndex + 4] + a[aIndex + 5] * b[bIndex + 7];
        float mt12 = a[aIndex + 3] * b[bIndex + 2] + a[aIndex + 4] * b[bIndex + 5] + a[aIndex + 5] * b[bIndex + 8];
        float mt20 = a[aIndex + 6] * b[bIndex + 0] + a[aIndex + 7] * b[bIndex + 3] + a[aIndex + 8] * b[bIndex + 6];
        float mt21 = a[aIndex + 6] * b[bIndex + 1] + a[aIndex + 7] * b[bIndex + 4] + a[aIndex + 8] * b[bIndex + 7];
        float mt22 = a[aIndex + 6] * b[bIndex + 2] + a[aIndex + 7] * b[bIndex + 5] + a[aIndex + 8] * b[bIndex + 8];
        dest[dIndex + 0] = mt00;
        dest[dIndex + 1] = mt01;
        dest[dIndex + 2] = mt02;
        dest[dIndex + 3] = mt10;
        dest[dIndex + 4] = mt11;
        dest[dIndex + 5] = mt12;
        dest[dIndex + 6] = mt20;
        dest[dIndex + 7] = mt21;
        dest[dIndex + 8] = mt22;
    }

    public static void mulTransposeRight(float[] dest, float[] a, float[] b) {
        float bt00 = b[0];
        float bt11 = b[4];
        float bt22 = b[8];
        float bt10 = b[1];
        float bt01 = b[3];
        float bt20 = b[2];
        float bt02 = b[6];
        float bt21 = b[5];
        float bt12 = b[7];
        float mt00 = a[0] * bt00 + a[1] * bt10 + a[2] * bt20;
        float mt01 = a[0] * bt01 + a[1] * bt11 + a[2] * bt21;
        float mt02 = a[0] * bt02 + a[1] * bt12 + a[2] * bt22;
        float mt10 = a[3] * bt00 + a[4] * bt10 + a[5] * bt20;
        float mt11 = a[3] * bt01 + a[4] * bt11 + a[5] * bt21;
        float mt12 = a[3] * bt02 + a[4] * bt12 + a[5] * bt22;
        float mt20 = a[6] * bt00 + a[7] * bt10 + a[8] * bt20;
        float mt21 = a[6] * bt01 + a[7] * bt11 + a[8] * bt21;
        float mt22 = a[6] * bt02 + a[7] * bt12 + a[8] * bt22;
        dest[0] = mt00;
        dest[1] = mt01;
        dest[2] = mt02;
        dest[3] = mt10;
        dest[4] = mt11;
        dest[5] = mt12;
        dest[6] = mt20;
        dest[7] = mt21;
        dest[8] = mt22;
    }

    public static void mulTransposeRight(float[] dest, int dstIndex, float[] a, int aIndex, float[] b, int bIndex) {
        float bt00 = b[0 + bIndex];
        float bt11 = b[4 + bIndex];
        float bt22 = b[8 + bIndex];
        float bt10 = b[1 + bIndex];
        float bt01 = b[3 + bIndex];
        float bt20 = b[2 + bIndex];
        float bt02 = b[6 + bIndex];
        float bt21 = b[5 + bIndex];
        float bt12 = b[7 + bIndex];
        float mt00 = a[0 + aIndex] * bt00 + a[1 + aIndex] * bt10 + a[2 + aIndex] * bt20;
        float mt01 = a[0 + aIndex] * bt01 + a[1 + aIndex] * bt11 + a[2 + aIndex] * bt21;
        float mt02 = a[0 + aIndex] * bt02 + a[1 + aIndex] * bt12 + a[2 + aIndex] * bt22;
        float mt10 = a[3 + aIndex] * bt00 + a[4 + aIndex] * bt10 + a[5 + aIndex] * bt20;
        float mt11 = a[3 + aIndex] * bt01 + a[4 + aIndex] * bt11 + a[5 + aIndex] * bt21;
        float mt12 = a[3 + aIndex] * bt02 + a[4 + aIndex] * bt12 + a[5 + aIndex] * bt22;
        float mt20 = a[6 + aIndex] * bt00 + a[7 + aIndex] * bt10 + a[8 + aIndex] * bt20;
        float mt21 = a[6 + aIndex] * bt01 + a[7 + aIndex] * bt11 + a[8 + aIndex] * bt21;
        float mt22 = a[6 + aIndex] * bt02 + a[7 + aIndex] * bt12 + a[8 + aIndex] * bt22;
        dest[0 + dstIndex] = mt00;
        dest[1 + dstIndex] = mt01;
        dest[2 + dstIndex] = mt02;
        dest[3 + dstIndex] = mt10;
        dest[4 + dstIndex] = mt11;
        dest[5 + dstIndex] = mt12;
        dest[6 + dstIndex] = mt20;
        dest[7 + dstIndex] = mt21;
        dest[8 + dstIndex] = mt22;
    }

    public static void mul(float[] dest, float[] a, float[] b) {
        float mt00 = a[0] * b[0] + a[1] * b[3] + a[2] * b[6];
        float mt01 = a[0] * b[1] + a[1] * b[4] + a[2] * b[7];
        float mt02 = a[0] * b[2] + a[1] * b[5] + a[2] * b[8];
        float mt10 = a[3] * b[0] + a[4] * b[3] + a[5] * b[6];
        float mt11 = a[3] * b[1] + a[4] * b[4] + a[5] * b[7];
        float mt12 = a[3] * b[2] + a[4] * b[5] + a[5] * b[8];
        float mt20 = a[6] * b[0] + a[7] * b[3] + a[8] * b[6];
        float mt21 = a[6] * b[1] + a[7] * b[4] + a[8] * b[7];
        float mt22 = a[6] * b[2] + a[7] * b[5] + a[8] * b[8];
        dest[0] = mt00;
        dest[1] = mt01;
        dest[2] = mt02;
        dest[3] = mt10;
        dest[4] = mt11;
        dest[5] = mt12;
        dest[6] = mt20;
        dest[7] = mt21;
        dest[8] = mt22;
    }

    public static void mul(float[] dest, float[] m) {
        Mat3f.mul(dest, dest, m);
    }

    public static void mul(float[] dest, int destIndex, float[] m, int mIndex) {
        Mat3f.mul(dest, destIndex, dest, destIndex, m, mIndex);
    }

    public static void transform(float[] m, int mIndex, float[] dest, int destIndex, float srcx, float srcy, float srcz) {
        dest[destIndex] = m[mIndex + 0] * srcx + m[mIndex + 1] * srcy + m[mIndex + 2] * srcz;
        dest[destIndex + 1] = m[mIndex + 3] * srcx + m[mIndex + 4] * srcy + m[mIndex + 5] * srcz;
        dest[destIndex + 2] = m[mIndex + 6] * srcx + m[mIndex + 7] * srcy + m[mIndex + 8] * srcz;
    }

    public static void transform(float[] m, float[] dest, int destIndex, float srcx, float srcy, float srcz) {
        dest[destIndex] = m[0] * srcx + m[1] * srcy + m[2] * srcz;
        dest[destIndex + 1] = m[3] * srcx + m[4] * srcy + m[5] * srcz;
        dest[destIndex + 2] = m[6] * srcx + m[7] * srcy + m[8] * srcz;
    }

    public static void transform(float[] m, int mIndex, float[] dest, int destIndex, float[] src, int srcIndex) {
        float vx = m[mIndex + 0] * src[srcIndex] + m[mIndex + 1] * src[srcIndex + 1] + m[mIndex + 2] * src[srcIndex + 2];
        float vy = m[mIndex + 3] * src[srcIndex] + m[mIndex + 4] * src[srcIndex + 1] + m[mIndex + 5] * src[srcIndex + 2];
        float vz = m[mIndex + 6] * src[srcIndex] + m[mIndex + 7] * src[srcIndex + 1] + m[mIndex + 8] * src[srcIndex + 2];
        dest[destIndex] = vx;
        dest[destIndex + 1] = vy;
        dest[destIndex + 2] = vz;
    }

    public static void transform(float[] m, int mIndex, float[] dst, int dstIndex) {
        float vx = m[mIndex + 0] * dst[dstIndex] + m[mIndex + 1] * dst[dstIndex + 1] + m[mIndex + 2] * dst[dstIndex + 2];
        float vy = m[mIndex + 3] * dst[dstIndex] + m[mIndex + 4] * dst[dstIndex + 1] + m[mIndex + 5] * dst[dstIndex + 2];
        float vz = m[mIndex + 6] * dst[dstIndex] + m[mIndex + 7] * dst[dstIndex + 1] + m[mIndex + 8] * dst[dstIndex + 2];
        dst[dstIndex] = vx;
        dst[dstIndex + 1] = vy;
        dst[dstIndex + 2] = vz;
    }

    public static void transform(float[] m, float[] dest, float[] src) {
        float vx = m[0] * src[0] + m[1] * src[1] + m[2] * src[2];
        float vy = m[3] * src[0] + m[4] * src[1] + m[5] * src[2];
        float vz = m[6] * src[0] + m[7] * src[1] + m[8] * src[2];
        dest[0] = vx;
        dest[1] = vy;
        dest[2] = vz;
    }

    public static void transform(float[] m, float[] dst) {
        float vx = m[0] * dst[0] + m[1] * dst[1] + m[2] * dst[2];
        float vy = m[3] * dst[0] + m[4] * dst[1] + m[5] * dst[2];
        float vz = m[6] * dst[0] + m[7] * dst[1] + m[8] * dst[2];
        dst[0] = vx;
        dst[1] = vy;
        dst[2] = vz;
    }

    public static boolean equals(float[] a, float[] b) {
        int i = 0;
        while (i < 9) {
            float diff = a[i] - b[i];
            if (Float.isNaN(diff)) {
                return false;
            }
            if (diff != 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean epsilonEquals(float[] a, int aIndex, float[] b, int bIndex, float epsilon) {
        int i = 0;
        while (i < 9) {
            float diff = a[i + aIndex] - b[i + bIndex];
            if (Float.isNaN(diff)) {
                return false;
            }
            float f = diff < 0.0f ? -diff : diff;
            if (f > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        int i = 0;
        while (i < 9) {
            float diff = a[i] - b[i];
            if (Float.isNaN(diff)) {
                return false;
            }
            float f = diff < 0.0f ? -diff : diff;
            if (f > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void transformTranspose(float[] m, float[] dst, float[] src) {
        float vx = m[0] * src[0] + m[3] * src[1] + m[6] * src[2];
        float vy = m[1] * src[0] + m[4] * src[1] + m[7] * src[2];
        float vz = m[2] * src[0] + m[5] * src[1] + m[8] * src[2];
        dst[0] = vx;
        dst[1] = vy;
        dst[2] = vz;
    }

    public static void transformTranspose(float[] m, int mIndex, float[] dst, int dstIndex, float[] src, int srcIndex) {
        float vx = m[mIndex + 0] * src[srcIndex] + m[mIndex + 3] * src[srcIndex + 1] + m[mIndex + 6] * src[srcIndex + 2];
        float vy = m[mIndex + 1] * src[srcIndex] + m[mIndex + 4] * src[srcIndex + 1] + m[mIndex + 7] * src[srcIndex + 2];
        float vz = m[mIndex + 2] * src[srcIndex] + m[mIndex + 5] * src[srcIndex + 1] + m[mIndex + 8] * src[srcIndex + 2];
        dst[dstIndex] = vx;
        dst[dstIndex + 1] = vy;
        dst[dstIndex + 2] = vz;
    }

    public static void transpose(float[] dest, float[] m) {
        dest[0] = m[0];
        dest[4] = m[4];
        dest[8] = m[8];
        float tmp = m[1];
        dest[1] = m[3];
        dest[3] = tmp;
        tmp = m[2];
        dest[2] = m[6];
        dest[6] = tmp;
        tmp = m[5];
        dest[5] = m[7];
        dest[7] = tmp;
    }

    public static void transpose(float[] m) {
        float tmp = m[1];
        m[1] = m[3];
        m[3] = tmp;
        tmp = m[2];
        m[2] = m[6];
        m[6] = tmp;
        tmp = m[5];
        m[5] = m[7];
        m[7] = tmp;
    }

    public static void add(float[] dest, float[] a) {
        int i = 0;
        while (i < 9) {
            int n = i;
            dest[n] = dest[n] + a[i];
            ++i;
        }
    }

    public static void sub(float[] dest, float[] a) {
        int i = 0;
        while (i < 9) {
            int n = i;
            dest[n] = dest[n] - a[i];
            ++i;
        }
    }

    public static void add(float[] dest, int destIndex, float[] a, int aIndex) {
        int i = 0;
        while (i < 9) {
            int n = i + destIndex;
            dest[n] = dest[n] + a[i + aIndex];
            ++i;
        }
    }

    public static void sub(float[] dest, int destIndex, float[] a, int aIndex) {
        int i = 0;
        while (i < 9) {
            int n = i + destIndex;
            dest[n] = dest[n] - a[i + aIndex];
            ++i;
        }
    }

    public static void add(float[] dest, float[] a, float[] b) {
        int i = 0;
        while (i < 9) {
            dest[i] = a[i] + b[i];
            ++i;
        }
    }

    public static void sub(float[] dest, float[] a, float[] b) {
        int i = 0;
        while (i < 9) {
            dest[i] = a[i] - b[i];
            ++i;
        }
    }

    public static void sub(float[] dest, int destIndex, float[] a, int aIndex, float[] b, int bIndex) {
        int i = 0;
        while (i < 9) {
            dest[i + destIndex] = a[i + aIndex] - b[i + bIndex];
            ++i;
        }
    }

    public static void add(float[] dest, int destIndex, float[] a, int aIndex, float[] b, int bIndex) {
        int i = 0;
        while (i < 9) {
            dest[i + destIndex] = a[i + aIndex] + b[i + bIndex];
            ++i;
        }
    }

    public static double det(float[] m) {
        return m[0] * (m[4] * m[8] - m[5] * m[7]) + m[1] * (m[5] * m[6] - m[3] * m[8]) + m[2] * (m[3] * m[7] - m[4] * m[6]);
    }

    public static float adjugateTranspose(float[] dest, float[] m) {
        Vec3f.cross(dest, 0, m, 3, m, 6);
        Vec3f.cross(dest, 3, m, 6, m, 0);
        Vec3f.cross(dest, 6, m, 0, m, 3);
        return m[0] * dest[0] + m[1] * dest[1] + m[2] * dest[2];
    }

    protected static float adjugateTransposeMat4f(float[] dest, float[] m) {
        Vec3f.cross(dest, 0, m, 4, m, 8);
        Vec3f.cross(dest, 3, m, 8, m, 0);
        Vec3f.cross(dest, 6, m, 0, m, 4);
        return m[0] * dest[0] + m[1] * dest[1] + m[2] * dest[2];
    }

    public static float adjugate(float[] dest, float[] m) {
        dest[0] = m[8] * m[4] - m[7] * m[5];
        dest[1] = -m[8] * m[1] + m[7] * m[2];
        dest[2] = m[5] * m[1] - m[4] * m[2];
        dest[3] = -m[8] * m[3] + m[6] * m[5];
        dest[4] = m[8] * m[0] - m[6] * m[2];
        dest[5] = -m[5] * m[0] + m[3] * m[2];
        dest[6] = m[7] * m[3] - m[6] * m[4];
        dest[7] = -m[7] * m[0] + m[6] * m[1];
        dest[8] = m[4] * m[0] - m[3] * m[1];
        return m[0] * dest[0] + m[1] * dest[3] + m[2] * dest[6];
    }

    public static float invert(float[] dest, float[] m) {
        float det = Mat3f.adjugate(dest, m);
        if (det == 0.0f) {
            return 0.0f;
        }
        Mat3f.scale(dest, 1.0f / det);
        return det;
    }

    public static float invertTranspose(float[] dest, float[] m) {
        float det = Mat3f.adjugateTranspose(dest, m);
        if (det == 0.0f) {
            return 0.0f;
        }
        Mat3f.scale(dest, 1.0f / det);
        return det;
    }

    public static float invertTransposeMat4f(float[] dest3x3, float[] m4x4) {
        float det = Mat3f.adjugateTransposeMat4f(dest3x3, m4x4);
        if (det == 0.0f) {
            return 0.0f;
        }
        Mat3f.scale(dest3x3, 1.0f / det);
        return det;
    }

    public static float norm1(float[] m) {
        float sum = 0.0f;
        int i = 0;
        while (i < 9) {
            sum += m[i] < 0.0f ? -m[i] : m[i];
            ++i;
        }
        return sum;
    }

    public static float norm2(float[] m) {
        float sum = 0.0f;
        int i = 0;
        while (i < 9) {
            sum += m[i] * m[i];
            ++i;
        }
        return (float)Math.sqrt(sum);
    }

    public static float normInf(float[] m) {
        float max = 0.0f;
        int i = 0;
        while (i < 9) {
            float mx;
            float f = mx = m[i] < 0.0f ? -m[i] : m[i];
            if (mx > max) {
                max = mx;
            }
            ++i;
        }
        return max;
    }

    public static float[] from4x4(float[] m4x4) {
        float[] m3x3 = new float[9];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                m3x3[3 * i + j] = m4x4[4 * i + j];
                ++j;
            }
            ++i;
        }
        return m3x3;
    }

    public static void convertTo3x3(float[] m) {
        m[3] = m[4];
        m[4] = m[5];
        m[5] = m[6];
        m[6] = m[8];
        m[7] = m[9];
        m[8] = m[10];
    }

    public static boolean isDiagonal(float[] m, float epsilon) {
        return Math.abs(m[1]) < epsilon && Math.abs(m[2]) < epsilon && Math.abs(m[3]) < epsilon && Math.abs(m[5]) < epsilon && Math.abs(m[6]) < epsilon && Math.abs(m[7]) < epsilon;
    }

    public static void getDiagonal(float[] matrix3f, float[] vec3f) {
        vec3f[0] = matrix3f[0];
        vec3f[1] = matrix3f[4];
        vec3f[2] = matrix3f[8];
    }

    public static void setDiagonal(float[] matrix3f, float[] vec3f) {
        matrix3f[0] = vec3f[0];
        matrix3f[4] = vec3f[1];
        matrix3f[8] = vec3f[2];
    }

    public static boolean isSymmetric(float[] m, float epsilon) {
        return Math.abs(m[1] - m[3]) < epsilon && Math.abs(m[2] - m[6]) < epsilon && Math.abs(m[5] - m[7]) < epsilon;
    }

    public static boolean isOrthogonal(float[] m, float epsilon) {
        float ip = m[0] * m[0] + m[3] * m[3] + m[6] * m[6];
        if (Math.abs(ip - 1.0f) > epsilon) {
            return false;
        }
        ip = m[1] * m[1] + m[4] * m[4] + m[7] * m[7];
        if (Math.abs(ip - 1.0f) > epsilon) {
            return false;
        }
        ip = m[2] * m[2] + m[5] * m[5] + m[8] * m[8];
        if (Math.abs(ip - 1.0f) > epsilon) {
            return false;
        }
        ip = m[0] * m[1] + m[3] * m[4] + m[6] * m[7];
        if (Math.abs(ip) > epsilon) {
            return false;
        }
        ip = m[0] * m[2] + m[3] * m[5] + m[6] * m[8];
        if (Math.abs(ip) > epsilon) {
            return false;
        }
        ip = m[1] * m[2] + m[4] * m[5] + m[7] * m[8];
        return !(Math.abs(ip) > epsilon);
    }

    public static double polarDecompose(float[] m, float[] q, float[] s) {
        float ne1;
        float[] mk = Mat3f.getMat3f();
        float[] mkInvT = Mat3f.getMat3f();
        float[] ek = Mat3f.getMat3f();
        Mat3f.set(mk, m);
        float n1 = Mat3f.norm1(mk);
        float nInf = Mat3f.normInf(mk);
        do {
            float det;
            if ((det = Mat3f.invertTranspose(mkInvT, mk)) == 0.0f) {
                return 0.0;
            }
            float nInv1 = Mat3f.norm1(mkInvT);
            float nInvInf = Mat3f.normInf(mkInvT);
            float r = nInv1 * nInvInf / (n1 * nInf);
            float gamma = (float)Math.sqrt(Math.sqrt(r));
            float g1 = 0.5f * gamma;
            float g2 = 0.5f / gamma;
            Mat3f.set(ek, mk);
            Mat3f.scale(mk, g1);
            Mat3f.scale(mkInvT, g2);
            Mat3f.add(mk, mkInvT);
            Mat3f.sub(ek, mk);
            ne1 = Mat3f.norm1(ek);
            n1 = Mat3f.norm1(mk);
            nInf = Mat3f.normInf(mk);
        } while (ne1 > 1.0E-6f * n1);
        Mat3f.set(q, mk);
        Mat3f.transpose(mk);
        Mat3f.mul(s, mk, m);
        Mat3f.transpose(ek, s);
        Mat3f.add(s, ek);
        Mat3f.scale(s, 0.5f);
        return Mat3f.det(q);
    }

    @Deprecated
    public static ScalingType polarDecompose(float[] m, float[] q, float[] s, float epsilon) {
        float ne1;
        float[] mk = Mat3f.getMat3f();
        float[] mkInvT = Mat3f.getMat3f();
        float[] ek = Mat3f.getMat3f();
        Mat3f.set(mk, m);
        float n1 = Mat3f.norm1(mk);
        float nInf = Mat3f.normInf(mk);
        do {
            float det;
            if ((det = Mat3f.invertTranspose(mkInvT, mk)) == 0.0f) {
                return ScalingType.UNDEFINED;
            }
            float nInv1 = Mat3f.norm1(mkInvT);
            float nInvInf = Mat3f.normInf(mkInvT);
            float r = nInv1 * nInvInf / (n1 * nInf);
            float gamma = (float)Math.sqrt(Math.sqrt(r));
            float g1 = 0.5f * gamma;
            float g2 = 0.5f / gamma;
            Mat3f.set(ek, mk);
            Mat3f.scale(mk, g1);
            Mat3f.scale(mkInvT, g2);
            Mat3f.add(mk, mkInvT);
            Mat3f.sub(ek, mk);
            ne1 = Mat3f.norm1(ek);
            n1 = Mat3f.norm1(mk);
            nInf = Mat3f.normInf(mk);
        } while (ne1 > 1.0E-6f * n1);
        Mat3f.set(q, mk);
        Mat3f.transpose(mk);
        Mat3f.mul(s, mk, m);
        Mat3f.transpose(ek, s);
        Mat3f.add(s, ek);
        Mat3f.scale(s, 0.5f);
        float eps = 1.0E-4f;
        Mat3f.smooth(s, eps);
        return Mat3f.getScalingType(s);
    }

    public static void smooth(float[] m, float eps) {
        int i = 0;
        while (i < 9) {
            if (Math.abs(m[i]) < eps) {
                m[i] = 0.0f;
            } else if (Math.abs(m[i] - 1.0f) < eps) {
                m[i] = 1.0f;
            } else if (Math.abs(m[i] + 1.0f) < eps) {
                m[i] = -1.0f;
            }
            ++i;
        }
    }

    public static ScalingType getScalingType(float[] m) {
        if (m[1] != 0.0f || m[2] != 0.0f || m[5] != 0.0f || m[3] != 0.0f || m[6] != 0.0f || m[7] != 0.0f) {
            return ScalingType.SKEW;
        }
        if (m[0] == 1.0f && m[4] == 1.0f && m[8] == 1.0f) {
            return ScalingType.IDENTITY;
        }
        return ScalingType.ALIGNED;
    }

    public static void skew(float[] m, float[] v) {
        m[0] = 0.0f;
        m[1] = -v[2];
        m[2] = v[1];
        m[3] = v[2];
        m[4] = 0.0f;
        m[5] = -v[0];
        m[6] = -v[1];
        m[7] = v[0];
        m[8] = 0.0f;
    }

    public static void skew(float[] m, float vx, float vy, float vz) {
        m[0] = 0.0f;
        m[1] = -vz;
        m[2] = vy;
        m[3] = vz;
        m[4] = 0.0f;
        m[5] = -vx;
        m[6] = -vy;
        m[7] = vx;
        m[8] = 0.0f;
    }

    public static void skew(float[] m, int mIndex, float[] v, int vIndex) {
        m[mIndex + 0] = 0.0f;
        m[mIndex + 1] = -v[2 + vIndex];
        m[mIndex + 2] = v[1 + vIndex];
        m[mIndex + 3] = v[vIndex + 2];
        m[mIndex + 4] = 0.0f;
        m[mIndex + 5] = -v[vIndex];
        m[mIndex + 6] = -v[vIndex + 1];
        m[mIndex + 7] = v[vIndex];
        m[mIndex + 8] = 0.0f;
    }

    public static float[] getSkewMatrix(float angle, float[] rvec, float[] tvec) {
        return Mat3f.getSkewMatrix(null, angle, rvec, tvec);
    }

    public static float[] getSkewMatrix(float[] matrix, float angle, float[] rvec, float[] tvec) {
        float[] e0 = Vec3f.getVec3f();
        float[] e1 = Vec3f.getVec3f();
        Vec3f.normalize(e1, tvec);
        float rv1 = Vec3f.dot(rvec, e1);
        Vec3f.set(e0, rvec);
        Vec3f.scaleAdd(e0, -rv1, e1);
        float rv0 = Vec3f.dot(rvec, e0);
        float cosa = (float)Math.cos((double)angle * Math.PI / 180.0);
        float sina = (float)Math.sin((double)angle * Math.PI / 180.0);
        float rr0 = rv0 * cosa - rv1 * sina;
        float rr1 = rv0 * sina + rv1 * cosa;
        if (rr0 < 1.0E-6f) {
            throw new IllegalArgumentException("Mat4f.getSkewMatrix: illegal angle (" + angle + ")");
        }
        float d = rr1 / rr0 - rv1 / rv0;
        if (matrix == null) {
            matrix = new float[9];
        }
        Mat3f.set(matrix, d * e1[0] * e0[0] + 1.0f, d * e1[0] * e0[1], d * e1[0] * e0[2], d * e1[1] * e0[0], d * e1[1] * e0[1] + 1.0f, d * e1[1] * e0[2], d * e1[2] * e0[0], d * e1[2] * e0[1], d * e1[2] * e0[2] + 1.0f);
        return matrix;
    }

    public static void transformVec3f(float[] m, float[] dest) {
        Mat3f.transform(m, dest, dest);
    }

    public static void transformVec3f(float[] m, float[] dst, int destIndex) {
        float vx = m[0] * dst[destIndex] + m[1] * dst[destIndex + 1] + m[2] * dst[destIndex + 2];
        float vy = m[3] * dst[destIndex] + m[4] * dst[destIndex + 1] + m[5] * dst[destIndex + 2];
        float vz = m[6] * dst[destIndex] + m[7] * dst[destIndex + 1] + m[8] * dst[destIndex + 2];
        dst[destIndex] = vx;
        dst[destIndex + 1] = vy;
        dst[destIndex + 2] = vz;
    }

    public static void transformVec3f(float[] m, int mIndex, float[] dest, int dIndex) {
        Mat3f.transform(m, mIndex, dest, dIndex, dest, dIndex);
    }

    public static String toString(float[] m) {
        return Mat3f.toStringTabbed(m, 0);
    }

    public static String toString(float[] m, int mIndex) {
        return Mat3f.toStringTabbed(m, mIndex, 0);
    }

    public static String toString(float[] m, int tab, int fieldwidth, int precision) {
        return Mat3f.toString(m, tab, "%" + fieldwidth + "." + precision + "f");
    }

    public static String toString(float[] m, int tab, String fmt) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < 3) {
            buf.append('\n');
            int t = 0;
            while (t < tab) {
                buf.append(' ');
                ++t;
            }
            int j = 0;
            while (j < 3) {
                float mval = m[3 * i + j];
                buf.append(String.format(fmt, Float.valueOf(mval)));
                buf.append("  ");
                ++j;
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toStringTabbed(float[] m, int tab) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < 3) {
            buf.append('\n');
            int t = 0;
            while (t < tab) {
                buf.append(' ');
                ++t;
            }
            int j = 0;
            while (j < 3) {
                buf.append(m[3 * i + j]);
                buf.append("  ");
                ++j;
            }
            ++i;
        }
        return buf.toString();
    }

    public static String toStringTabbed(float[] m, int mIndex, int tab) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < 3) {
            buf.append('\n');
            int t = 0;
            while (t < tab) {
                buf.append(' ');
                ++t;
            }
            int j = 0;
            while (j < 3) {
                buf.append(m[3 * i + j + mIndex]);
                buf.append("  ");
                ++j;
            }
            ++i;
        }
        return buf.toString();
    }

    public static enum ScalingType {
        IDENTITY,
        UNIFORM,
        ALIGNED,
        SKEW,
        UNDEFINED;

    }
}

