/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public final class Mat {
    private Mat() {
    }

    public static boolean LUDecompose(float[] matrix, int m, int n, int[] p) {
        int psign = 1;
        float[] s = new float[m];
        int i = 0;
        while (i < m) {
            p[i] = i;
            s[i] = 0.0f;
            int j = 0;
            while (j < n) {
                s[i] = Math.max(s[i], Math.abs(matrix[i * n + j]));
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < m) {
            float pivot;
            int pivotIndex = k;
            float pivotMax = 0.0f;
            int i2 = k;
            while (i2 < m) {
                int ri = p[i2];
                float piv = Math.abs(matrix[ri * n + k]) / s[ri];
                if (piv > pivotMax) {
                    pivotIndex = i2;
                    pivotMax = piv;
                }
                ++i2;
            }
            int pr = p[pivotIndex];
            if (pivotIndex != k) {
                p[pivotIndex] = p[k];
                p[k] = pr;
                psign = -psign;
            }
            if ((pivot = matrix[pr * n + k]) == 0.0f) {
                return false;
            }
            int i3 = k + 1;
            while (i3 < m) {
                float z;
                matrix[p[i3] * n + k] = z = matrix[p[i3] * n + k] / pivot;
                int j = k + 1;
                while (j < n) {
                    int n2 = p[i3] * n + j;
                    matrix[n2] = matrix[n2] - z * matrix[pr * n + j];
                    ++j;
                }
                ++i3;
            }
            ++k;
        }
        return true;
    }

    public static float[] solveLUSystem(float[] LU, int[] p, float[] b) {
        int j;
        int ri;
        int n = b.length;
        float[] x = new float[n];
        int i = 0;
        while (i < n) {
            ri = p[i];
            j = 0;
            while (j < i) {
                int n2 = ri;
                b[n2] = b[n2] - LU[ri * n + j] * b[p[j]];
                ++j;
            }
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            ri = p[i];
            x[i] = b[ri];
            j = i + 1;
            while (j < n) {
                int n3 = i;
                x[n3] = x[n3] - LU[ri * n + j] * x[j];
                ++j;
            }
            int n4 = i;
            x[n4] = x[n4] / LU[ri * n + i];
            --i;
        }
        return x;
    }

    public static void invertMatrix(float[] A, int n, float[] Ainv) {
        float[] LU = new float[n * n];
        Mat.set(LU, A, n, n);
        int[] p = new int[n];
        Mat.LUDecompose(LU, n, n, p);
        float[] b = new float[n];
        int j = 0;
        while (j < n) {
            int i = 0;
            while (i < n) {
                b[i] = 0.0f;
                ++i;
            }
            b[j] = 1.0f;
            float[] u = Mat.solveLUSystem(LU, p, b);
            int i2 = 0;
            while (i2 < n) {
                Ainv[i2 * n + j] = u[i2];
                ++i2;
            }
            ++j;
        }
    }

    public static void set(float[] dest, float[] src, int m, int n) {
        int i = 0;
        while (i < m * n) {
            dest[i] = src[i];
            ++i;
        }
    }

    public static void getLUfactors(float[] matrix, int m, int[] p, float[] L, float[] U) {
        int i = 0;
        while (i < m) {
            int ri = p[i] * m;
            int j = 0;
            while (j < m) {
                if (j < i) {
                    L[i * m + j] = matrix[ri + j];
                    U[i * m + j] = 0.0f;
                } else if (j == i) {
                    L[i * m + j] = 1.0f;
                    U[i * m + j] = matrix[ri + j];
                } else {
                    L[i * m + j] = 0.0f;
                    U[i * m + j] = matrix[ri + j];
                }
                ++j;
            }
            ++i;
        }
    }

    public static int[] invertPermutation(int[] p) {
        int m = p.length;
        int[] invp = new int[m];
        int i = 0;
        while (i < m) {
            invp[p[i]] = i;
            ++i;
        }
        return invp;
    }

    public static float[] getPermutationMatrix(int[] p) {
        int m = p.length;
        float[] pmatrix = new float[m * m];
        int i = 0;
        while (i < m) {
            pmatrix[i * m + p[i]] = 1.0f;
            ++i;
        }
        return pmatrix;
    }

    public static float[] getInvertedPermutationMatrix(int[] p) {
        int m = p.length;
        float[] invpmatrix = new float[m * m];
        int i = 0;
        while (i < m) {
            invpmatrix[p[i] * m + i] = 1.0f;
            ++i;
        }
        return invpmatrix;
    }

    public static float[] permute(int[] p, float[] b) {
        int m = p.length;
        float[] bp = new float[m];
        int i = 0;
        while (i < m) {
            bp[i] = b[p[i]];
            ++i;
        }
        return bp;
    }

    public static void tridiagonalSolve(float[] a, float[] b, float[] c, float[] d, float[] x) {
        int n = a.length;
        c[0] = c[0] / b[0];
        d[0] = d[0] / b[0];
        int i = 1;
        while (i < n) {
            float id = 1.0f / (b[i] - c[i - 1] * a[i]);
            c[i] = c[i] * id;
            d[i] = (d[i] - a[i] * d[i - 1]) * id;
            ++i;
        }
        x[n - 1] = d[n - 1];
        i = n - 2;
        while (i != -1) {
            x[i] = d[i] - c[i] * x[i + 1];
            --i;
        }
    }

    public static void mul(float[] dst, float[] a, int an, float[] b, int bn) {
        int am = a.length / an;
        int bm = b.length / bn;
        assert (dst.length >= am * bn);
        assert (an == bm);
        int i = 0;
        while (i < am) {
            int j = 0;
            while (j < bn) {
                dst[i * bn + j] = 0.0f;
                int k = 0;
                while (k < an) {
                    int n = i * bn + j;
                    dst[n] = dst[n] + a[i * an + k] * b[k * bn + j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

