/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public final class HermiteSpline {
    private float[] interpolationPoints;
    private float m0;
    private float mn;

    public HermiteSpline() {
    }

    public HermiteSpline(float[] val) {
        this.m0 = 0.0f;
        this.mn = 0.0f;
        this.interpolationPoints = val;
    }

    public HermiteSpline(float[] val, float startSpeed, float endSpeed) {
        this.m0 = startSpeed;
        this.mn = endSpeed;
        this.interpolationPoints = val;
    }

    private static double H0(double t) {
        return 2.0 * Math.pow(t, 3.0) - 3.0 * Math.pow(t, 2.0) + 1.0;
    }

    private static double H1(double t) {
        return Math.pow(t, 3.0) - 2.0 * Math.pow(t, 2.0) + t;
    }

    private static double H2(double t) {
        return -2.0 * Math.pow(t, 3.0) + 3.0 * Math.pow(t, 2.0);
    }

    private static double H3(double t) {
        return Math.pow(t, 3.0) - Math.pow(t, 2.0);
    }

    public float eval(float t) {
        int tInt = (int)t;
        int t_1 = tInt - 1;
        int t_2 = tInt + 2;
        if (tInt >= this.interpolationPoints.length - 1) {
            return this.interpolationPoints[this.interpolationPoints.length - 1];
        }
        float m_0 = t_1 == -1 ? this.m0 : 0.5f * (this.interpolationPoints[tInt + 1] - this.interpolationPoints[t_1]);
        float m_1 = t_2 >= this.interpolationPoints.length ? this.mn : 0.5f * (this.interpolationPoints[t_2] - this.interpolationPoints[tInt]);
        return HermiteSpline.getValueCustomSpeed(t - (float)tInt, this.interpolationPoints[tInt], this.interpolationPoints[tInt + 1], m_0, m_1);
    }

    public static float getValueCustomSpeed(float t, float p0, float p1, float m0, float m1) {
        return (float)(HermiteSpline.H0(t) * (double)p0 + HermiteSpline.H1(t) * (double)m0 + HermiteSpline.H2(t) * (double)p1 + HermiteSpline.H3(t) * (double)m1);
    }

    public static float getValue(float t, float p_1, float p0, float p1, float p2) {
        return (float)(HermiteSpline.H0(t) * (double)p0 + HermiteSpline.H1(t) * 0.5 * (double)(p1 - p_1) + HermiteSpline.H2(t) * (double)p1 + HermiteSpline.H3(t) * 0.5 * (double)(p2 - p0));
    }

    public void setInterpolationPoints(float[] interpolationPoints) {
        this.interpolationPoints = interpolationPoints;
    }

    public void setM0(float m0) {
        this.m0 = m0;
    }

    public void setMn(float mn) {
        this.mn = mn;
    }
}

