/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.CubicSpline;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CubicSplineTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testEval() {
        float[] points = new float[]{1.0f, 2.0f, 3.0f, 4.0f, -7.0f, 5.0f, 10.0f, 3.0f, 6.5f, 100.0f};
        CubicSpline cs = new CubicSpline(points);
        int i = 0;
        while (i < points.length) {
            float val = cs.eval((float)i / (float)points.length) - points[i];
            Assert.assertTrue(((double)(val * val) < 1.0E-6 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testEvalDiff() {
    }

    @Test
    public void testEvalDiff2() {
        float[] points = new float[]{1.0f, 2.0f, 3.0f, 4.0f, -7.0f, 5.0f, 10.0f, 3.0f, 6.5f, 100.0f};
        CubicSpline cs = new CubicSpline(points);
        float val = cs.evalDiff2(0.0f);
        Assert.assertTrue(((double)(val * val) < 1.0E-6 ? 1 : 0) != 0);
        val = cs.evalDiff2(1.0f);
        Assert.assertTrue(((double)(val * val) < 1.0E-6 ? 1 : 0) != 0);
    }

    @Test
    public void testSinusSpline() {
        float[] points = new float[1000];
        int i = 0;
        while (i < 1000) {
            float t = (float)i * 0.01f;
            points[i] = (float)Math.sin(t);
            ++i;
        }
        CubicSpline cs = new CubicSpline(points);
        int i2 = 0;
        while (i2 < 10000) {
            float interp;
            float real = (float)Math.sin((float)i2 * 0.001f);
            Assert.assertTrue(((double)Math.abs(real - (interp = cs.eval((float)i2 / 10000.0f))) < 0.01 ? 1 : 0) != 0);
            float realDiff = (float)Math.cos((float)i2 * 0.001f);
            float interpDiff = cs.evalDiff((float)i2 / 10000.0f, 0.01f);
            Assert.assertTrue(((double)Math.abs(realDiff - interpDiff) < 0.01 ? 1 : 0) != 0);
            if (!((float)i2 * 0.1f >= 998.0f)) {
                float interpDiff2;
                float realDiff2 = -((float)Math.sin((float)i2 * 0.001f));
                Assert.assertTrue(((double)Math.abs(realDiff2 - (interpDiff2 = cs.evalDiff2((float)i2 / 10000.0f, 0.01f))) < 0.15 ? 1 : 0) != 0);
            }
            ++i2;
        }
    }
}

