/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public class BSpline2f {
    private float[] points = null;
    private int offsetPoints;
    private float[] controlPoints = null;
    private int offsetControlPoints;
    private final float[] controlPoint1A = new float[2];
    private final float[] controlPoint2A = new float[2];
    private final float[] a = new float[4];
    private final float[] b = new float[4];
    private int segments = 32;
    private float[] xCoords;
    private float[] yCoords;

    public BSpline2f() {
    }

    public BSpline2f(float[] points, int offsetPoints, float[] controlPoints, int offsetControlPoints, int segments) {
        this.points = points;
        this.offsetPoints = offsetPoints;
        this.controlPoints = controlPoints;
        this.offsetControlPoints = offsetControlPoints;
        this.segments = segments;
        this.updateAbsolute();
        this.updateBSpline();
        this.calculateSpline();
    }

    public BSpline2f(BSpline2f bSpline2f) {
        this.points = bSpline2f.getPoints();
        this.offsetPoints = bSpline2f.getOffsetPoints();
        this.controlPoints = bSpline2f.getControlPoints();
        this.offsetControlPoints = bSpline2f.getOffsetControlPoints();
        this.segments = bSpline2f.getSegments();
        this.updateAbsolute();
        this.updateBSpline();
        this.calculateSpline();
    }

    public void updateBSpline() {
        this.updateAbsolute();
        this.a[0] = -this.points[this.offsetPoints] + 3.0f * this.controlPoint1A[0] - 3.0f * this.controlPoint2A[0] + this.points[this.offsetPoints + 2];
        this.a[1] = 3.0f * this.points[this.offsetPoints] - 6.0f * this.controlPoint1A[0] + 3.0f * this.controlPoint2A[0];
        this.a[2] = -3.0f * this.points[this.offsetPoints] + 3.0f * this.controlPoint1A[0];
        this.a[3] = this.points[this.offsetPoints];
        this.b[0] = -this.points[this.offsetPoints + 1] + 3.0f * this.controlPoint1A[1] - 3.0f * this.controlPoint2A[1] + this.points[this.offsetPoints + 3];
        this.b[1] = 3.0f * this.points[this.offsetPoints + 1] - 6.0f * this.controlPoint1A[1] + 3.0f * this.controlPoint2A[1];
        this.b[2] = -3.0f * this.points[this.offsetPoints + 1] + 3.0f * this.controlPoint1A[1];
        this.b[3] = this.points[this.offsetPoints + 1];
    }

    public void calculateSpline() {
        this.xCoords = new float[this.segments];
        this.yCoords = new float[this.segments];
        this.xCoords[0] = this.a[3];
        this.yCoords[0] = this.b[3];
        int i = 1;
        while (i < this.segments - 1) {
            float t = (float)i / (float)this.segments;
            this.xCoords[i] = this.a[3] + t * (this.a[2] + t * (this.a[1] + t * this.a[0]));
            this.yCoords[i] = this.b[3] + t * (this.b[2] + t * (this.b[1] + t * this.b[0]));
            ++i;
        }
        this.xCoords[this.segments - 1] = this.points[this.offsetPoints + 2];
        this.yCoords[this.segments - 1] = this.points[this.offsetPoints + 3];
    }

    public float[] getSplineCoord(float offset) {
        return new float[]{this.a[3] + offset * (this.a[2] + offset * (this.a[1] + offset * this.a[0])), this.b[3] + offset * (this.b[2] + offset * (this.b[1] + offset * this.b[0]))};
    }

    public void getSplineCoord(float offset, float[] target2f) {
        target2f[0] = this.a[3] + offset * (this.a[2] + offset * (this.a[1] + offset * this.a[0]));
        target2f[1] = this.b[3] + offset * (this.b[2] + offset * (this.b[1] + offset * this.b[0]));
    }

    public void updateAbsolute() {
        this.controlPoint1A[0] = this.points[this.offsetPoints] + this.controlPoints[this.offsetControlPoints];
        this.controlPoint1A[1] = this.points[this.offsetPoints + 1] + this.controlPoints[this.offsetControlPoints + 1];
        this.controlPoint2A[0] = this.points[this.offsetPoints + 2] + this.controlPoints[this.offsetControlPoints + 2];
        this.controlPoint2A[1] = this.points[this.offsetPoints + 3] + this.controlPoints[this.offsetControlPoints + 3];
    }

    public float[] getControlPoint1A() {
        return this.controlPoint1A;
    }

    public float[] getControlPoint2A() {
        return this.controlPoint2A;
    }

    public int getSegments() {
        return this.segments;
    }

    public float[] getXCoords() {
        return this.xCoords;
    }

    public float[] getYCoords() {
        return this.yCoords;
    }

    public float[] getPoints() {
        return this.points;
    }

    public void setPoints(float[] points) {
        this.points = points;
    }

    public int getOffsetPoints() {
        return this.offsetPoints;
    }

    public void setOffsetPoints(int offsetPoints) {
        this.offsetPoints = offsetPoints;
    }

    public float[] getControlPoints() {
        return this.controlPoints;
    }

    public void setControlPoints(float[] controlPoints) {
        this.controlPoints = controlPoints;
    }

    public int getOffsetControlPoints() {
        return this.offsetControlPoints;
    }

    public void setOffsetControlPoints(int offsetControlPoints) {
        this.offsetControlPoints = offsetControlPoints;
    }

    public void setSegments(int segments) {
        this.segments = segments;
    }

    public float getPoint1X() {
        return this.points[this.offsetPoints];
    }

    public float getPoint1Y() {
        return this.points[this.offsetPoints + 1];
    }

    public float getPoint2X() {
        return this.points[this.offsetPoints + 2];
    }

    public float getPoint2Y() {
        return this.points[this.offsetPoints + 3];
    }

    public float getControlPoint1X() {
        return this.controlPoints[this.offsetControlPoints];
    }

    public float getControlPoint1Y() {
        return this.controlPoints[this.offsetControlPoints + 1];
    }

    public float getControlPoint2X() {
        return this.controlPoints[this.offsetControlPoints + 2];
    }

    public float getControlPoint2Y() {
        return this.controlPoints[this.offsetControlPoints + 3];
    }

    public void setPoint1X(float value) {
        this.points[this.offsetPoints] = value;
    }

    public void setPoint1Y(float value) {
        this.points[this.offsetPoints + 1] = value;
    }

    public void setPoint2X(float value) {
        this.points[this.offsetPoints + 2] = value;
    }

    public void setPoint2Y(float value) {
        this.points[this.offsetPoints + 3] = value;
    }

    public void setControlPoint1X(float value) {
        this.controlPoints[this.offsetControlPoints] = value;
    }

    public void setControlPoint1Y(float value) {
        this.controlPoints[this.offsetControlPoints + 1] = value;
    }

    public void setControlPoint2X(float value) {
        this.controlPoints[this.offsetControlPoints + 2] = value;
    }

    public void setControlPoint2Y(float value) {
        this.controlPoints[this.offsetControlPoints + 3] = value;
    }
}

