/*
 * Decompiled with CFR 0.152.
 */
package hmi.math.digitalfilter;

public final class Butterworth {
    private Butterworth() {
    }

    public static void butterworth(float[] fin, float fc, float fs, int pass, float[] fout) {
        double c = Math.pow(Math.pow(2.0, 1.0 / (double)pass) - 1.0, 0.25);
        double sigmaC = Math.tan(Math.PI * (double)fc / (double)fs) / c;
        double k1 = Math.sqrt(2.0 * sigmaC);
        double k2 = sigmaC * sigmaC;
        double a0 = k2 / (1.0 + k1 + k2);
        double a1 = 2.0 * a0;
        double a2 = a0;
        double k3 = 2.0 * a0 / k2;
        double b1 = -2.0 * a0 + k3;
        double b2 = 1.0 - 2.0 * a0 - k3;
        int length = fin.length;
        fout[0] = fin[0];
        fout[1] = fin[1];
        int i = 3;
        while (i < length) {
            fout[i] = (float)(a0 * (double)fin[i] + a1 * (double)fin[i - 1] + a2 * (double)fin[i - 2] + b1 * (double)fout[i - 1] + b2 * (double)fout[i - 2]);
            ++i;
        }
    }

    public static void butterworth(float[] fin, float fc, float fs, int pass, int width, float[] fout) {
        double c = Math.pow(Math.pow(2.0, 1.0 / (double)pass) - 1.0, 0.25);
        double sigmaC = Math.tan(Math.PI * (double)fc / (double)fs) / c;
        double k1 = Math.sqrt(2.0 * sigmaC);
        double k2 = sigmaC * sigmaC;
        double a0 = k2 / (1.0 + k1 + k2);
        double a1 = 2.0 * a0;
        double a2 = a0;
        double k3 = 2.0 * a0 / k2;
        double b1 = -2.0 * a0 + k3;
        double b2 = 1.0 - 2.0 * a0 - k3;
        int length = fin.length / width;
        int i = 0;
        while (i < width * 2) {
            fout[i] = fin[i];
            ++i;
        }
        i = 2;
        while (i < length) {
            int j = 0;
            while (j < width) {
                fout[i * width + j] = (float)(a0 * (double)fin[i * width + j] + a1 * (double)fin[(i - 1) * width + j] + a2 * (double)fin[(i - 2) * width + j] + b1 * (double)fout[(i - 1) * width + j] + b2 * (double)fout[(i - 2) * width + j]);
                ++j;
            }
            ++i;
        }
    }
}

