/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public final class Vecf {
    private Vecf() {
    }

    public static float[] getVecf(int len) {
        return new float[len];
    }

    public static float[] getVecf(float[] vecf) {
        float[] result = new float[vecf.length];
        System.arraycopy(vecf, 0, result, 0, vecf.length);
        return result;
    }

    public static boolean equals(float[] a, float[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            float diff = a[i] - b[i];
            if (Float.isNaN(diff)) {
                return false;
            }
            float f = diff < 0.0f ? -diff : diff;
            if (f > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toString(float[] config) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (config == null) {
            buf.append("null");
        } else {
            int len = config.length;
            if (len > 0) {
                buf.append(config[0]);
            }
            int i = 1;
            while (i < len) {
                buf.append(", ");
                buf.append(config[i]);
                ++i;
            }
        }
        buf.append(')');
        return buf.toString();
    }

    public static void set(float[] dst, float[] src) {
        int i = 0;
        while (i < dst.length) {
            dst[i] = src[i];
            ++i;
        }
    }

    public static void add(float[] dst, float[] a, float[] b) {
        int i = 0;
        while (i < dst.length) {
            dst[i] = a[i] + b[i];
            ++i;
        }
    }

    public static void add(float[] dst, float[] a) {
        int i = 0;
        while (i < dst.length) {
            int n = i;
            dst[n] = dst[n] + a[i];
            ++i;
        }
    }

    public static void sub(float[] dst, float[] a, float[] b) {
        int i = 0;
        while (i < dst.length) {
            dst[i] = a[i] - b[i];
            ++i;
        }
    }

    public static void sub(float[] dst, float[] a) {
        int i = 0;
        while (i < dst.length) {
            int n = i;
            dst[n] = dst[n] - a[i];
            ++i;
        }
    }

    public static void scale(float scale, float[] dst) {
        int i = 0;
        while (i < dst.length) {
            int n = i++;
            dst[n] = dst[n] * scale;
        }
    }

    public static void scale(float scale, float[] dst, float[] src) {
        int i = 0;
        while (i < dst.length) {
            dst[i] = scale * src[i];
            ++i;
        }
    }

    public static void pmul(float[] dst, float[] a, float[] b) {
        int i = 0;
        while (i < dst.length) {
            dst[i] = a[i] * b[i];
            ++i;
        }
    }

    public static void negate(float[] dst, float[] src) {
        int i = 0;
        while (i < dst.length) {
            dst[i] = -src[i];
            ++i;
        }
    }

    public static void negate(float[] dst) {
        int i = 0;
        while (i < dst.length) {
            dst[i] = -dst[i];
            ++i;
        }
    }

    public static float dot(float[] a, float[] b) {
        float d = 0.0f;
        int i = 0;
        while (i < a.length) {
            d += a[i] * b[i];
            ++i;
        }
        return d;
    }

    public static float lengthSq(float[] a) {
        return Vecf.dot(a, a);
    }

    public static float length(float[] a) {
        return (float)Math.sqrt(Vecf.dot(a, a));
    }

    public static void interpolate(float[] dst, float[] a, float[] b, float alpha) {
        int i = 0;
        while (i < a.length) {
            dst[i] = (1.0f - alpha) * a[i] + alpha * b[i];
            ++i;
        }
    }

    public static void normalize(float[] dst, float[] a) {
        float linv = 1.0f / Vecf.length(a);
        Vecf.scale(linv, dst, a);
    }

    public static void normalize(float[] a) {
        float linv = 1.0f / Vecf.length(a);
        Vecf.scale(linv, a);
    }
}

