/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public class TCBSpline {
    private float[] interpolationPoints;
    private float[] interpolationTimes;
    private float[] tension;
    private float[] continuity;
    private float[] bias;
    private float m0;
    private float mn;

    public TCBSpline() {
    }

    public TCBSpline(float[] val, float[] time, float[] t, float[] c, float[] b, float startSpeed, float endSpeed) {
        this.m0 = startSpeed;
        this.mn = endSpeed;
        this.interpolationTimes = time;
        this.interpolationPoints = val;
        this.tension = t;
        this.continuity = c;
        this.bias = b;
    }

    private static double h0(double t) {
        return 2.0 * Math.pow(t, 3.0) - 3.0 * Math.pow(t, 2.0) + 1.0;
    }

    private static double h1(double t) {
        return Math.pow(t, 3.0) - 2.0 * Math.pow(t, 2.0) + t;
    }

    private static double h2(double t) {
        return -2.0 * Math.pow(t, 3.0) + 3.0 * Math.pow(t, 2.0);
    }

    private static double h3(double t) {
        return Math.pow(t, 3.0) - Math.pow(t, 2.0);
    }

    public float eval(float t) {
        float ds1;
        float n1;
        float dd0;
        int index = -2;
        int i = 0;
        while (i < this.interpolationTimes.length) {
            if (this.interpolationTimes[i] > t) {
                index = i - 1;
                break;
            }
            ++i;
        }
        if (index >= this.interpolationPoints.length - 1 || index == -2) {
            return this.interpolationPoints[this.interpolationPoints.length - 1];
        }
        if (index < 0) {
            return this.interpolationPoints[0];
        }
        float n0 = this.interpolationTimes[index + 1] - this.interpolationTimes[index];
        if (index == 0) {
            dd0 = this.m0;
        } else {
            dd0 = (1.0f - this.tension[index]) * (1.0f + this.continuity[index]) * (1.0f + this.bias[index]) * 0.5f * (this.interpolationPoints[index] - this.interpolationPoints[index - 1]) + (1.0f - this.tension[index]) * (1.0f - this.continuity[index]) * (1.0f - this.bias[index]) * 0.5f * (this.interpolationPoints[index + 1] - this.interpolationPoints[index]);
            n1 = this.interpolationTimes[index] - this.interpolationTimes[index - 1];
            dd0 *= 2.0f * n1 / (n1 + n0);
        }
        if (index + 2 > this.interpolationPoints.length - 1) {
            ds1 = this.mn;
        } else {
            ds1 = (1.0f - this.tension[index + 1]) * (1.0f - this.continuity[index + 1]) * (1.0f + this.bias[index + 1]) * 0.5f * (this.interpolationPoints[index + 1] - this.interpolationPoints[index]) + (1.0f - this.tension[index + 1]) * (1.0f + this.continuity[index + 1]) * (1.0f - this.bias[index + 1]) * 0.5f * (this.interpolationPoints[index + 2] - this.interpolationPoints[index + 1]);
            n1 = this.interpolationTimes[index + 2] - this.interpolationTimes[index + 1];
            ds1 *= 2.0f * n1 / (n0 + n1);
        }
        float tinterp = t - this.interpolationTimes[index];
        return TCBSpline.getValueCustomSpeed(tinterp /= n0, this.interpolationPoints[index], this.interpolationPoints[index + 1], dd0, ds1);
    }

    public static float getValueCustomSpeed(float t, float p0, float p1, float m0, float m1) {
        return (float)(TCBSpline.h0(t) * (double)p0 + TCBSpline.h1(t) * (double)m0 + TCBSpline.h2(t) * (double)p1 + TCBSpline.h3(t) * (double)m1);
    }

    public void setInterpolationPoints(float[] interpolationPoints) {
        this.interpolationPoints = interpolationPoints;
    }

    public void setM0(float m0) {
        this.m0 = m0;
    }

    public void setMn(float mn) {
        this.mn = mn;
    }

    public void setBias(float[] bias) {
        this.bias = bias;
    }

    public void setContinuity(float[] continuity) {
        this.continuity = continuity;
    }

    public void setInterpolationTimes(float[] interpolationTimes) {
        this.interpolationTimes = interpolationTimes;
    }

    public void setTension(float[] tension) {
        this.tension = tension;
    }
}

