/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat3f;
import hmi.math.SpatialArticulatedBodyInertiaTensor;
import hmi.math.SpatialInertiaTensor;
import hmi.math.SpatialTransform;
import hmi.math.Vec3f;
import org.junit.Assert;
import org.junit.Test;

public class SpatialArticulatedBodyInertiaTensorTest {
    @Test
    public void testXstarIXinv() {
        float[] X = SpatialTransform.getSpatialTransform();
        SpatialTransform.setFromMat3fVec3f(X, Mat3f.getIdentity(), Vec3f.getVec3f());
        float[] I = SpatialInertiaTensor.getSpatialInertiaTensor();
        float[] pos = Vec3f.getVec3f();
        Vec3f.set(pos, 1.0f, 2.0f, 3.0f);
        float[] rotI = new float[9];
        float d = 1.0f;
        float h = 2.0f;
        float w = 3.0f;
        rotI[0] = 0.083333336f * (h * h + d * d);
        rotI[4] = 0.083333336f * (w * w + d * d);
        rotI[8] = 0.083333336f * (h * h + w * w);
        SpatialInertiaTensor.set(I, rotI, pos, 1.0f);
        float[] Ia = SpatialArticulatedBodyInertiaTensor.getSpatialArticulatedBodyInertiaTensor();
        SpatialArticulatedBodyInertiaTensor.setFromSpatialInertiaTensor(Ia, I);
        float[] Idest = SpatialArticulatedBodyInertiaTensor.getSpatialArticulatedBodyInertiaTensor();
        SpatialArticulatedBodyInertiaTensor.xstarIXinv(Idest, X, Ia);
        System.out.println("I:\n " + SpatialInertiaTensor.toString(I));
        System.out.println("Ia:\n " + SpatialArticulatedBodyInertiaTensor.toString(Ia));
        System.out.println("Idest:\n " + SpatialArticulatedBodyInertiaTensor.toString(Idest));
        Assert.assertTrue((boolean)SpatialArticulatedBodyInertiaTensor.epsilonEquals(Idest, Ia, 1.0E-4f));
    }
}

