/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.NumMath;
import hmi.math.Quat4f;
import hmi.math.QuatCurve;
import hmi.math.Vec3f;
import org.junit.Assert;
import org.junit.Test;

public class QuatCurveTest {
    @Test
    public void hermite() {
        float[] q0 = new float[4];
        float[] q1 = new float[4];
        float[] w = new float[3];
        float[] w0 = new float[3];
        float[] w1 = new float[3];
        float[] q = new float[4];
        Vec3f.set(w0, 0.0f, 0.0f, 0.0f);
        Vec3f.set(w1, 0.0f, 0.0f, 0.0f);
        Quat4f.setFromAxisAngle4f(q0, 0.2f, 0.4f, 0.8f, 0.78f);
        Quat4f.setFromAxisAngle4f(q1, 0.34f, 0.1f, 0.2f, 0.3f);
        QuatCurve.hermite(q0, q1, w0, w1, 0.0f, q);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q, q0, 1.0E-5f));
        QuatCurve.hermite(q0, q1, w0, w1, 1.0f, q);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q, q1, 1.0E-5f));
        Vec3f.set(w0, 1.0f, 2.0f, 3.0f);
        Vec3f.set(w1, 3.0f, 1.0f, 1.0f);
        QuatCurve.hermite(q0, q1, w0, w1, 1.0f, q);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q, q1, 1.0E-5f));
        Quat4f.setFromAxisAngle4f(q0, 1.0f, 0.0f, 0.0f, 0.01f);
        Quat4f.setFromAxisAngle4f(q1, 1.0f, 0.0f, 0.0f, 0.78f);
        Vec3f.set(w0, 0.5f, 0.0f, 0.0f);
        Vec3f.set(w1, 0.8f, 0.0f, 0.0f);
        float[] qt0 = new float[4];
        float[] qt1 = new float[4];
        float[] qt2 = new float[4];
        float[] qrate = new float[4];
        QuatCurve.hermite(q0, q1, w0, w1, 0.0f, qt0);
        QuatCurve.hermite(q0, q1, w0, w1, 1.0E-5f, qt1);
        QuatCurve.hermite(q0, q1, w0, w1, 2.0E-5f, qt2);
        int i = 0;
        while (i < 4) {
            qrate[i] = NumMath.diff(qt0[i], qt2[i], 1.0E-5f);
            ++i;
        }
        Quat4f.setAngularVelocityFromQuat4f(w, qt1, qrate);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(w, w0, 0.01f));
        QuatCurve.hermite(q0, q1, w0, w1, 0.998f, qt0);
        QuatCurve.hermite(q0, q1, w0, w1, 0.999f, qt1);
        QuatCurve.hermite(q0, q1, w0, w1, 1.0f, qt2);
        i = 0;
        while (i < 4) {
            qrate[i] = NumMath.diff(qt0[i], qt2[i], 0.001f);
            ++i;
        }
        Quat4f.setAngularVelocityFromQuat4f(w, qt1, qrate);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(w, w1, 0.01f));
        float[] qStart = new float[4];
        float[] qEnd = new float[4];
        Quat4f.setFromAxisAngle4f(qStart, 1.0f, 0.0f, 0.0f, 2.3561945f);
        Quat4f.setFromAxisAngle4f(qEnd, 1.0f, 0.0f, 0.0f, 1.5707964f);
        float[] wStart = new float[3];
        float[] wEnd = new float[3];
        Vec3f.set(wStart, 2.3561945f, 0.0f, 0.0f);
        Vec3f.set(wEnd, -0.19634955f, 0.0f, 0.0f);
        QuatCurve.hermite(qStart, qEnd, wStart, wEnd, 0.998f, qt0);
        QuatCurve.hermite(qStart, qEnd, wStart, wEnd, 0.999f, qt1);
        QuatCurve.hermite(qStart, qEnd, wStart, wEnd, 1.0f, qt2);
        int i2 = 0;
        while (i2 < 4) {
            qrate[i2] = NumMath.diff(qt0[i2], qt2[i2], 0.001f);
            ++i2;
        }
        Quat4f.setAngularVelocityFromQuat4f(w, qt1, qrate);
        Assert.assertTrue((boolean)Vec3f.epsilonEquals(w, wEnd, 0.01f));
        Quat4f.set(qStart, 0.8036457f, -0.5951081f, 5.4295924E-8f, -8.3679566E-7f);
        Quat4f.setIdentity(qEnd);
        Vec3f.setZero(wStart);
        Vec3f.setZero(wEnd);
        QuatCurve.hermite(qStart, 0, qEnd, 0, wStart, 0, wEnd, 0, 1.0f, q, 0);
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q, qEnd, 0.01f));
        Quat4f.set(qStart, 0.9553366f, 0.0f, 0.0f, 0.29552022f);
        Quat4f.set(qEnd, 0.9553365f, 0.0f, 0.0f, 0.29552022f);
        Vec3f.setZero(wStart);
        Vec3f.setZero(wEnd);
        QuatCurve.hermite(qStart, 0, qEnd, 0, wStart, 0, wEnd, 0, 1.0f, q, 0);
        System.out.println(Quat4f.toString(q));
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q, qEnd, 0.01f));
        QuatCurve.hermite(qStart, qEnd, wStart, wEnd, 0.0f, q);
        System.out.println(Quat4f.toString(q));
        Assert.assertTrue((boolean)Quat4f.epsilonEquals(q, qEnd, 0.01f));
    }
}

