/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Vec3f;
import hmi.math.Vec4f;

public final class Quat4f {
    public static final int QUAT4F_SIZE = 4;
    public static final int S = 0;
    public static final int X = 1;
    public static final int Y = 2;
    public static final int Z = 3;
    public static final int s = 0;
    public static final int x = 1;
    public static final int y = 2;
    public static final int z = 3;
    public static final double EPS2 = 1.0E-7;
    public static final double EPS = 1.0E-6;
    public static final double MACHINE_EPS = 1.2E-7;
    public static final double EPSEXPMAP = 0.019;
    public static final double SLERPEPSILON = 0.001;
    private static final float PI_DEGREES = 180.0f;

    private Quat4f() {
    }

    public static float[] getQuat4f() {
        return new float[4];
    }

    public static void exp(float[] q, float[] v) {
        double alpha = Vec3f.length(v);
        double a = alpha <= 0.019 ? 0.5 + alpha * alpha / 48.0 : Math.sin(alpha * 0.5) / alpha;
        Quat4f.set(q, (float)Math.cos(alpha * 0.5), (float)(a * (double)v[0]), (float)(a * (double)v[1]), (float)(a * (double)v[2]));
    }

    public static void log(float[] v, float[] q) {
        double alpha = 2.0 * Math.acos(q[0]);
        double a = alpha <= 0.019 ? 1.0 / (0.5 + alpha * alpha / 48.0) : alpha / Math.sin(alpha * 0.5);
        Vec3f.set(v, (float)(a * (double)q[1]), (float)(a * (double)q[2]), (float)(a * (double)q[3]));
    }

    public static float[] getQuat4f(float s, float x, float y, float z) {
        return new float[]{s, x, y, z};
    }

    public static float[] getIdentity() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    }

    public static float[] getQuat4f(float[] q) {
        return new float[]{q[0], q[1], q[2], q[3]};
    }

    public static float[] getQuat4fFromAxisAngle(float x, float y, float z, float angle) {
        float[] newQuat = new float[4];
        Quat4f.setFromAxisAngle4f(newQuat, x, y, z, angle);
        return newQuat;
    }

    public static float[] getQuat4fFromAxisAngleDegrees(float x, float y, float z, float degrees) {
        float[] newQuat = new float[4];
        Quat4f.setFromAxisAngle4f(newQuat, x, y, z, degrees * ((float)Math.PI / 180));
        return newQuat;
    }

    public static float[] getQuat4fFromRollPitchYawDegrees(float roll, float pitch, float yaw) {
        float[] newQuat = new float[4];
        Quat4f.setFromRollPitchYawDegrees(newQuat, roll, pitch, yaw);
        return newQuat;
    }

    public static void add(float[] dst, float[] a) {
        Vec4f.add(dst, a);
    }

    public static void sub(float[] dst, float[] a) {
        Vec4f.sub(dst, a);
    }

    public static boolean equals(float[] a, float[] b) {
        return Vec4f.equals(a, b);
    }

    public static boolean equals(float[] a, int aIndex, float[] b, int bIndex) {
        return Vec4f.equals(a, aIndex, b, bIndex);
    }

    public static boolean epsilonEquals(float[] a, float[] b, float epsilon) {
        return Vec4f.epsilonEquals(a, b, epsilon);
    }

    public static boolean epsilonEquals(float[] a, float bs, float bx, float by, float bz, float epsilon) {
        return Vec4f.epsilonEquals(a, bs, bx, by, bz, epsilon);
    }

    public static boolean epsilonEquals(float[] a, int aIndex, float[] b, int bIndex, float epsilon) {
        return Vec4f.epsilonEquals(a, aIndex, b, bIndex, epsilon);
    }

    public static void setFromEulerAngles(float[] q, float heading, float attitude, float bank) {
        double c1 = Math.cos(heading);
        double s1 = Math.sin(heading);
        double c2 = Math.cos(attitude);
        double s2 = Math.sin(attitude);
        double c3 = Math.cos(bank);
        double s3 = Math.sin(bank);
        double w4 = Math.sqrt(1.0 + c1 * c2 + c1 * c3 - s1 * s2 * s3 + c2 * c3) / 2.0;
        q[0] = (float)w4;
        w4 = 1.0 / (w4 * 4.0);
        q[1] = (float)((c2 * s3 + c1 * s3 + s1 * s2 * c3) * w4);
        q[2] = (float)((s1 * c2 + s1 * c3 + c1 * s2 * s3) * w4);
        q[3] = (float)((-s1 * s3 + c1 * s2 * c3 + s2) * w4);
    }

    public static void setFromRollPitchYawDegrees(float[] q, float roll, float pitch, float yaw) {
        Quat4f.setFromRollPitchYaw(q, (float)Math.PI / 180 * roll, (float)Math.PI / 180 * pitch, (float)Math.PI / 180 * yaw);
    }

    public static void setFromRollPitchYaw(float[] q, float roll, float pitch, float yaw) {
        double cx = Math.cos((double)pitch / 2.0);
        double cy = Math.cos((double)yaw / 2.0);
        double cz = Math.cos((double)roll / 2.0);
        double sx = Math.sin((double)pitch / 2.0);
        double sy = Math.sin((double)yaw / 2.0);
        double sz = Math.sin((double)roll / 2.0);
        q[0] = (float)(cx * cy * cz + sx * sy * sz);
        q[1] = (float)(cx * sy * sz + sx * cy * cz);
        q[2] = (float)(cx * sy * cz - sx * cy * sz);
        q[3] = (float)(cx * cy * sz - sx * sy * cz);
    }

    public static void getRollPitchYaw(float[] q, float[] result) {
        double sqw = q[0] * q[0];
        double sqx = q[1] * q[1];
        double sqy = q[2] * q[2];
        double sqz = q[3] * q[3];
        result[0] = (float)Math.atan2(2.0f * (q[1] * q[2] + q[3] * q[0]), sqw + sqy - sqx - sqz);
        result[1] = (float)Math.asin(-2.0f * (q[3] * q[2] - q[1] * q[0]));
        result[2] = (float)Math.atan2(2.0f * (q[3] * q[1] + q[2] * q[0]), sqw + sqz - sqx - sqy);
    }

    public static void setFromVectors(float[] q, float[] a, float[] b) {
        float[] an = Vec3f.getVec3f(a);
        Vec3f.normalize(an);
        float[] h = Vec3f.getVec3f(b);
        Vec3f.normalize(h);
        Vec3f.add(h, an);
        Vec3f.normalize(h);
        q[0] = Vec3f.dot(an, h);
        q[1] = an[1] * h[2] - an[2] * h[1];
        q[2] = an[2] * h[0] - an[0] * h[2];
        q[3] = an[0] * h[1] - an[1] * h[0];
    }

    public static float[] getFromVectors(float[] a, float[] b) {
        float[] q = new float[4];
        Quat4f.setFromVectors(q, a, b);
        return q;
    }

    public static void set(float[] dst, float[] src) {
        dst[0] = src[0];
        dst[1] = src[1];
        dst[2] = src[2];
        dst[3] = src[3];
    }

    public static void set(float[] dst, int dIndex, float[] src, int sIndex) {
        dst[dIndex] = src[sIndex];
        dst[dIndex + 1] = src[sIndex + 1];
        dst[dIndex + 2] = src[sIndex + 2];
        dst[dIndex + 3] = src[sIndex + 3];
    }

    public static void set(float[] dst, float qs, float qx, float qy, float qz) {
        dst[0] = qs;
        dst[1] = qx;
        dst[2] = qy;
        dst[3] = qz;
    }

    public static void set(float[] dst, int index, float qs, float qx, float qy, float qz) {
        dst[0 + index] = qs;
        dst[1 + index] = qx;
        dst[2 + index] = qy;
        dst[3 + index] = qz;
    }

    public static void setIdentity(float[] dst) {
        dst[0] = 1.0f;
        dst[1] = 0.0f;
        dst[2] = 0.0f;
        dst[3] = 0.0f;
    }

    public static void setIdentity(float[] dst, int qIndex) {
        dst[qIndex + 0] = 1.0f;
        dst[qIndex + 1] = 0.0f;
        dst[qIndex + 2] = 0.0f;
        dst[qIndex + 3] = 0.0f;
    }

    public static boolean isIdentity(float[] dst) {
        return dst[0] == 1.0f && dst[1] == 0.0f && dst[2] == 0.0f && dst[3] == 0.0f;
    }

    public static void setFromEulerAngles(float[] q, float[] ea) {
        Quat4f.setFromEulerAngles(q, ea[0], ea[1], ea[2]);
    }

    public static void setFromAxisAngleDegrees(float[] q, float[] axis, float degrees) {
        Quat4f.setFromAxisAngle4f(q, axis[0], axis[1], axis[2], degrees * ((float)Math.PI / 180));
    }

    public static void setFromAxisAngleDegrees(float[] q, float ax, float ay, float az, float degrees) {
        Quat4f.setFromAxisAngle4f(q, ax, ay, az, degrees * ((float)Math.PI / 180));
    }

    public static void setFromAxisAngle4f(float[] q, float[] aa) {
        Quat4f.setFromAxisAngle4f(q, aa[0], aa[1], aa[2], aa[3]);
    }

    public static void setFromAxisAngle4f(float[] q, float ax, float ay, float az, float angle) {
        double mag = Math.sqrt(ax * ax + ay * ay + az * az);
        if (mag < 1.0E-6) {
            q[0] = 1.0f;
            q[1] = 0.0f;
            q[2] = 0.0f;
            q[3] = 0.0f;
        } else {
            q[0] = (float)Math.cos((double)angle / 2.0);
            float sn = (float)(Math.sin((double)angle / 2.0) / mag);
            q[1] = ax * sn;
            q[2] = ay * sn;
            q[3] = az * sn;
        }
    }

    public static void setQuat4fArrayFromAxisAngle4fArray(float[] q, float[] aa) {
        int offset = 0;
        while (offset < q.length) {
            float ax = aa[offset];
            float ay = aa[offset + 1];
            float az = aa[offset + 2];
            float angle = aa[offset + 3];
            double mag = Math.sqrt(ax * ax + ay * ay + az * az);
            if (mag < 1.0E-6) {
                q[offset + 0] = 1.0f;
                q[offset + 1] = 0.0f;
                q[offset + 2] = 0.0f;
                q[offset + 3] = 0.0f;
            } else {
                q[offset + 0] = (float)Math.cos((double)angle / 2.0);
                float sn = (float)(Math.sin((double)angle / 2.0) / mag);
                q[offset + 1] = ax * sn;
                q[offset + 2] = ay * sn;
                q[offset + 3] = az * sn;
            }
            offset += 4;
        }
    }

    public static void setFromAxisAngle4f(float[] q, int qIndex, float[] aa, int aaIndex) {
        Quat4f.setFromAxisAngle4f(q, qIndex, aa[aaIndex], aa[aaIndex + 1], aa[aaIndex + 2], aa[aaIndex + 3]);
    }

    public static void setFromAxisAngle4f(float[] q, int qIndex, float ax, float ay, float az, float angle) {
        double mag = Math.sqrt(ax * ax + ay * ay + az * az);
        if (mag < 1.0E-6) {
            q[qIndex + 0] = 1.0f;
            q[qIndex + 1] = 0.0f;
            q[qIndex + 2] = 0.0f;
            q[qIndex + 3] = 0.0f;
        } else {
            q[qIndex + 0] = (float)Math.cos((double)angle / 2.0);
            float sn = (float)(Math.sin((double)angle / 2.0) / mag);
            q[qIndex + 1] = ax * sn;
            q[qIndex + 2] = ay * sn;
            q[qIndex + 3] = az * sn;
        }
    }

    public static void setAxisAngle4fFromQuat4f(float[] aa, float[] q) {
        assert (q[0] <= 1.0f && q[0] >= -1.0f) : "q is not a normalized quaternion";
        aa[3] = (float)(2.0 * Math.acos(q[0]));
        double len = q[1] * q[1] + q[2] * q[2] + q[3] * q[3];
        if (len > 1.0E-6) {
            len = (float)(1.0 / Math.sqrt(len));
            aa[0] = (float)((double)q[1] * len);
            aa[1] = (float)((double)q[2] * len);
            aa[2] = (float)((double)q[3] * len);
        } else {
            aa[0] = 1.0f;
            aa[1] = 0.0f;
            aa[2] = 1.0f;
        }
    }

    public static float[] getAxisAngle4fFromQuat4f(float[] q) {
        float[] aa = new float[4];
        Quat4f.setAxisAngle4fFromQuat4f(aa, q);
        return aa;
    }

    public static void setFromMat3f(float[] q, float[] m) {
        double ww = 0.25 * (1.0 + (double)m[0] + (double)m[4] + (double)m[8]);
        if (ww < -1.0E-7) {
            throw new IllegalArgumentException("Quat4f.setFromMat3f: non-rotation matrix, ww= " + ww);
        }
        if (ww < 0.0) {
            ww = 0.0;
        }
        if (ww >= 1.0E-7) {
            q[0] = (float)Math.sqrt(ww);
            ww = 0.25 / (double)q[0];
            q[1] = (float)((double)(m[7] - m[5]) * ww);
            q[2] = (float)((double)(m[2] - m[6]) * ww);
            q[3] = (float)((double)(m[3] - m[1]) * ww);
        } else {
            q[0] = 0.0f;
            ww = -0.5 * (double)(m[4] + m[8]);
            if (ww < 0.0) {
                ww = 0.0;
            }
            if (ww >= 1.0E-7) {
                q[1] = (float)Math.sqrt(ww);
                ww = 0.5 / (double)q[1];
                q[2] = (float)((double)m[3] * ww);
                q[3] = (float)((double)m[6] * ww);
            } else {
                q[1] = 0.0f;
                ww = 0.5 * (1.0 - (double)m[8]);
                if (ww < 0.0) {
                    ww = 0.0;
                }
                if (ww >= 1.0E-7) {
                    q[2] = (float)Math.sqrt(ww);
                    q[3] = (float)((double)m[7] / (2.0 * (double)q[2]));
                } else {
                    q[2] = 0.0f;
                    q[3] = 1.0f;
                }
            }
        }
        Quat4f.normalize(q);
    }

    public static void setFromMat4f(float[] q, float[] m) {
        double ww = 0.25 * (1.0 + (double)m[0] + (double)m[5] + (double)m[10]);
        if (ww < -1.0E-7) {
            throw new IllegalArgumentException("Quat4f.setFromMat3f: non-rotation matrix ");
        }
        if (ww < 0.0) {
            ww = 0.0;
        }
        if (ww >= 1.0E-7) {
            q[0] = (float)Math.sqrt(ww);
            ww = 0.25 / (double)q[0];
            q[1] = (float)((double)(m[9] - m[6]) * ww);
            q[2] = (float)((double)(m[2] - m[8]) * ww);
            q[3] = (float)((double)(m[4] - m[1]) * ww);
        } else {
            q[0] = 0.0f;
            ww = -0.5 * (double)(m[5] + m[10]);
            if (ww < 0.0) {
                ww = 0.0;
            }
            if (ww >= 1.0E-7) {
                q[1] = (float)Math.sqrt(ww);
                ww = 0.5 / (double)q[1];
                q[2] = (float)((double)m[4] * ww);
                q[3] = (float)((double)m[8] * ww);
            } else {
                q[1] = 0.0f;
                ww = 0.5 * (1.0 - (double)m[10]);
                if (ww < 0.0) {
                    ww = 0.0;
                }
                if (ww >= 1.0E-7) {
                    q[2] = (float)Math.sqrt(ww);
                    q[3] = (float)((double)m[9] / (2.0 * (double)q[2]));
                } else {
                    q[2] = 0.0f;
                    q[3] = 1.0f;
                }
            }
        }
        Quat4f.normalize(q);
    }

    public static void mul(float[] c, int ci, float[] a, int ai, float[] b, int bi) {
        float cs = a[ai + 0] * b[bi + 0] - a[ai + 1] * b[bi + 1] - a[ai + 2] * b[bi + 2] - a[ai + 3] * b[bi + 3];
        float cx = a[ai + 0] * b[bi + 1] + b[bi + 0] * a[ai + 1] + a[ai + 2] * b[bi + 3] - a[ai + 3] * b[bi + 2];
        float cy = a[ai + 0] * b[bi + 2] + b[bi + 0] * a[ai + 2] + a[ai + 3] * b[bi + 1] - a[ai + 1] * b[bi + 3];
        c[ci + 3] = a[ai + 0] * b[bi + 3] + b[bi + 0] * a[ai + 3] + a[ai + 1] * b[bi + 2] - a[ai + 2] * b[bi + 1];
        c[ci + 0] = cs;
        c[ci + 1] = cx;
        c[ci + 2] = cy;
    }

    public static void mul(float[] c, float[] a, float[] b) {
        float cs = a[0] * b[0] - a[1] * b[1] - a[2] * b[2] - a[3] * b[3];
        float cx = a[0] * b[1] + b[0] * a[1] + a[2] * b[3] - a[3] * b[2];
        float cy = a[0] * b[2] + b[0] * a[2] + a[3] * b[1] - a[1] * b[3];
        c[3] = a[0] * b[3] + b[0] * a[3] + a[1] * b[2] - a[2] * b[1];
        c[0] = cs;
        c[1] = cx;
        c[2] = cy;
    }

    public static void mulConjugateRight(float[] c, float[] a, float[] b) {
        float bx = -b[1];
        float by = -b[2];
        float bz = -b[3];
        float bs = b[0];
        float cs = a[0] * bs - a[1] * bx - a[2] * by - a[3] * bz;
        float cx = a[0] * bx + bs * a[1] + a[2] * bz - a[3] * by;
        float cy = a[0] * by + bs * a[2] + a[3] * bx - a[1] * bz;
        c[3] = a[0] * bz + bs * a[3] + a[1] * by - a[2] * bx;
        c[0] = cs;
        c[1] = cx;
        c[2] = cy;
    }

    public static void mulConjugateRight(float[] c, int cIndex, float[] a, int aIndex, float[] b, int bIndex) {
        float bx = -b[1 + bIndex];
        float by = -b[2 + bIndex];
        float bz = -b[3 + bIndex];
        float bs = b[0 + bIndex];
        float cs = a[0 + aIndex] * bs - a[1 + aIndex] * bx - a[2 + aIndex] * by - a[3 + aIndex] * bz;
        float cx = a[0 + aIndex] * bx + bs * a[1 + aIndex] + a[2 + aIndex] * bz - a[3 + aIndex] * by;
        float cy = a[0 + aIndex] * by + bs * a[2 + aIndex] + a[3 + aIndex] * bx - a[1 + aIndex] * bz;
        c[3 + cIndex] = a[0 + aIndex] * bz + bs * a[3 + aIndex] + a[1 + aIndex] * by - a[2 + aIndex] * bx;
        c[0 + cIndex] = cs;
        c[1 + cIndex] = cx;
        c[2 + cIndex] = cy;
    }

    public static void mulConjugateRight(float[] a, float[] b) {
        Quat4f.mulConjugateRight(a, a, b);
    }

    public static void mulConjugateRight(float[] a, int aIndex, float[] b, int bIndex) {
        Quat4f.mulConjugateRight(a, aIndex, a, aIndex, b, bIndex);
    }

    public static void mul(float[] a, float[] b) {
        Quat4f.mul(a, a, b);
    }

    public static void mul(float[] a, int aIndex, float[] b, int bIndex) {
        Quat4f.mul(a, aIndex, a, aIndex, b, bIndex);
    }

    public static void conjugate(float[] a, int aIndex) {
        a[aIndex + 1] = -a[aIndex + 1];
        a[aIndex + 2] = -a[aIndex + 2];
        a[aIndex + 3] = -a[aIndex + 3];
    }

    public static void conjugate(float[] a) {
        a[1] = -a[1];
        a[2] = -a[2];
        a[3] = -a[3];
    }

    public static void conjugate(float[] a, float[] b) {
        a[0] = b[0];
        a[1] = -b[1];
        a[2] = -b[2];
        a[3] = -b[3];
    }

    public static void conjugate(float[] a, int aIndex, float[] b, int bIndex) {
        a[0 + aIndex] = b[0 + bIndex];
        a[1 + aIndex] = -b[1 + bIndex];
        a[2 + aIndex] = -b[2 + bIndex];
        a[3 + aIndex] = -b[3 + bIndex];
    }

    public static void inverse(float[] a) {
        float norm = 1.0f / (a[0] * a[0] + a[1] * a[1] + a[2] * a[2] + a[3] * a[3]);
        a[0] = norm * a[0];
        a[1] = -norm * a[1];
        a[2] = -norm * a[2];
        a[3] = -norm * a[3];
    }

    public static void inverse(float[] a, float[] b) {
        float norm = 1.0f / (b[0] * b[0] + b[1] * b[1] + b[2] * b[2] + b[3] * b[3]);
        a[0] = norm * b[0];
        a[1] = -norm * b[1];
        a[2] = -norm * b[2];
        a[3] = -norm * b[3];
    }

    public static float lengthSq(float[] a) {
        return Vec4f.lengthSq(a);
    }

    public static float length(float[] a) {
        return Vec4f.length(a);
    }

    public static void normalize(float[] a, int aIndex) {
        float norm = a[aIndex + 0] * a[aIndex + 0] + a[aIndex + 1] * a[aIndex + 1] + a[aIndex + 2] * a[aIndex + 2] + a[aIndex + 3] * a[aIndex + 3];
        if (norm > 0.0f) {
            norm = 1.0f / (float)Math.sqrt(norm);
            int n = aIndex + 0;
            a[n] = a[n] * norm;
            int n2 = aIndex + 1;
            a[n2] = a[n2] * norm;
            int n3 = aIndex + 2;
            a[n3] = a[n3] * norm;
            int n4 = aIndex + 3;
            a[n4] = a[n4] * norm;
        }
    }

    public static void normalize(float[] a) {
        float norm = a[0] * a[0] + a[1] * a[1] + a[2] * a[2] + a[3] * a[3];
        if (norm > 0.0f) {
            norm = 1.0f / (float)Math.sqrt(norm);
            a[0] = a[0] * norm;
            a[1] = a[1] * norm;
            a[2] = a[2] * norm;
            a[3] = a[3] * norm;
        }
    }

    public static void normalize(float[] a, float[] b) {
        float norm = b[0] * b[0] + b[1] * b[1] + b[2] * b[2] + b[3] * b[3];
        if (norm > 0.0f) {
            norm = 1.0f / (float)Math.sqrt(norm);
            a[0] = norm * b[0];
            a[1] = norm * b[1];
            a[2] = norm * b[2];
            a[3] = norm * b[3];
        } else {
            a[0] = 0.0f;
            a[1] = 0.0f;
            a[2] = 0.0f;
            a[3] = 0.0f;
        }
    }

    public static void interpolate(float[] qr, float[] q1, float[] q2, float alpha) {
        qr[0] = q1[0];
        qr[1] = q1[1];
        qr[2] = q1[2];
        qr[3] = q1[3];
        Quat4f.interpolate(qr, q2, alpha);
    }

    public static void interpolate(float[] qr, float[] q, float alpha) {
        float s2;
        float s1;
        double cosOmega = qr[0] * q[0] + qr[1] * q[1] + qr[2] * q[2] + qr[3] * q[3];
        if (cosOmega < 0.0) {
            qr[0] = -qr[0];
            qr[1] = -qr[1];
            qr[2] = -qr[2];
            qr[3] = -qr[3];
            cosOmega = -cosOmega;
        }
        if (1.0 - cosOmega < 0.001) {
            s1 = 1.0f - alpha;
            s2 = alpha;
        } else {
            double omega = Math.acos(cosOmega);
            double sinOmega = Math.sin(omega);
            s1 = (float)(Math.sin((1.0 - (double)alpha) * omega) / sinOmega);
            s2 = (float)(Math.sin((double)alpha * omega) / sinOmega);
        }
        qr[0] = s1 * qr[0] + s2 * q[0];
        qr[1] = s1 * qr[1] + s2 * q[1];
        qr[2] = s1 * qr[2] + s2 * q[2];
        qr[3] = s1 * qr[3] + s2 * q[3];
    }

    public static void interpolate(float[] qr, int qrIndex, float[] q1, int q1Index, float[] q2, int q2Index, float alpha) {
        float s2;
        float s1;
        float q1s = q1[q1Index + 0];
        float q2s = q2[q2Index + 0];
        float q1x = q1[q1Index + 1];
        float q2x = q2[q2Index + 1];
        float q1y = q1[q1Index + 2];
        float q2y = q2[q2Index + 2];
        float q1z = q1[q1Index + 3];
        float q2z = q2[q2Index + 3];
        double cosOmega = q1s * q2s + q1x * q2x + q1y * q2y + q1z * q2z;
        if (cosOmega < 0.0) {
            q1s = -q1s;
            q1x = -q1x;
            q1y = -q1y;
            q1z = -q1z;
            cosOmega = -cosOmega;
        }
        if (1.0 - cosOmega < 0.001) {
            s1 = 1.0f - alpha;
            s2 = alpha;
        } else {
            double omega = Math.acos(cosOmega);
            double sinOmega = Math.sin(omega);
            s1 = (float)(Math.sin((1.0 - (double)alpha) * omega) / sinOmega);
            s2 = (float)(Math.sin((double)alpha * omega) / sinOmega);
        }
        qr[qrIndex + 0] = s1 * q1s + s2 * q2s;
        qr[qrIndex + 1] = s1 * q1x + s2 * q2x;
        qr[qrIndex + 2] = s1 * q1y + s2 * q2y;
        qr[qrIndex + 3] = s1 * q1z + s2 * q2z;
    }

    public static void interpolateArrays(float[] qr, float[] q1, float[] q2, float alpha) {
        int offset = 0;
        while (offset < qr.length) {
            Quat4f.interpolate(qr, offset, q1, offset, q2, offset, alpha);
            offset += 4;
        }
    }

    public static float[] transformVec3f(float[] q, int qIndex, float[] v, int vIndex) {
        float qs = -q[qIndex + 1] * v[vIndex] - q[qIndex + 2] * v[vIndex + 1] - q[qIndex + 3] * v[vIndex + 2];
        float qx = q[qIndex + 0] * v[vIndex] + q[qIndex + 2] * v[vIndex + 2] - q[qIndex + 3] * v[vIndex + 1];
        float qy = q[qIndex + 0] * v[vIndex + 1] + q[qIndex + 3] * v[vIndex] - q[qIndex + 1] * v[vIndex + 2];
        float qz = q[qIndex + 0] * v[vIndex + 2] + q[qIndex + 1] * v[vIndex + 1] - q[qIndex + 2] * v[vIndex];
        v[vIndex] = q[qIndex + 0] * qx - qs * q[qIndex + 1] - qy * q[qIndex + 3] + qz * q[qIndex + 2];
        v[vIndex + 1] = q[qIndex + 0] * qy - qs * q[qIndex + 2] - qz * q[qIndex + 1] + qx * q[qIndex + 3];
        v[vIndex + 2] = q[qIndex + 0] * qz - qs * q[qIndex + 3] - qx * q[qIndex + 2] + qy * q[qIndex + 1];
        return v;
    }

    public static void transformVec3f(float[] q, int qIndex, float[] src, int srcIndex, float[] dst, int dstIndex) {
        float qs = -q[qIndex + 1] * src[srcIndex] - q[qIndex + 2] * src[srcIndex + 1] - q[qIndex + 3] * src[srcIndex + 2];
        float qx = q[qIndex + 0] * src[srcIndex] + q[qIndex + 2] * src[srcIndex + 2] - q[qIndex + 3] * src[srcIndex + 1];
        float qy = q[qIndex + 0] * src[srcIndex + 1] + q[qIndex + 3] * src[srcIndex] - q[qIndex + 1] * src[srcIndex + 2];
        float qz = q[qIndex + 0] * src[srcIndex + 2] + q[qIndex + 1] * src[srcIndex + 1] - q[qIndex + 2] * src[srcIndex];
        dst[dstIndex] = q[qIndex + 0] * qx - qs * q[qIndex + 1] - qy * q[qIndex + 3] + qz * q[qIndex + 2];
        dst[dstIndex + 1] = q[qIndex + 0] * qy - qs * q[qIndex + 2] - qz * q[qIndex + 1] + qx * q[qIndex + 3];
        dst[dstIndex + 2] = q[qIndex + 0] * qz - qs * q[qIndex + 3] - qx * q[qIndex + 2] + qy * q[qIndex + 1];
    }

    public static float[] transformVec3f(float[] q, float[] v) {
        float qs = -q[1] * v[0] - q[2] * v[1] - q[3] * v[2];
        float qx = q[0] * v[0] + q[2] * v[2] - q[3] * v[1];
        float qy = q[0] * v[1] + q[3] * v[0] - q[1] * v[2];
        float qz = q[0] * v[2] + q[1] * v[1] - q[2] * v[0];
        v[0] = q[0] * qx - qs * q[1] - qy * q[3] + qz * q[2];
        v[1] = q[0] * qy - qs * q[2] - qz * q[1] + qx * q[3];
        v[2] = q[0] * qz - qs * q[3] - qx * q[2] + qy * q[1];
        return v;
    }

    public static String toString(float[] a, int aIndex) {
        return "(" + a[aIndex] + ", " + a[aIndex + 1] + "," + a[aIndex + 2] + "," + a[aIndex + 3] + ")";
    }

    public static String toString(float[] a) {
        return "(" + a[0] + ", " + a[1] + ", " + a[2] + ", " + a[3] + ")";
    }

    public static String toString(float[] a, int fieldwidth, int precision) {
        return Quat4f.toString(a, "%" + fieldwidth + "." + precision + "f");
    }

    public static String toString(float[] a, String fmt) {
        StringBuffer buf = new StringBuffer(30);
        buf.append('(');
        buf.append(String.format(fmt, Float.valueOf(a[0])));
        buf.append(',');
        buf.append(String.format(fmt, Float.valueOf(a[1])));
        buf.append(',');
        buf.append(String.format(fmt, Float.valueOf(a[2])));
        buf.append(',');
        buf.append(String.format(fmt, Float.valueOf(a[3])));
        buf.append(')');
        return buf.toString();
    }

    public static String explainQuat4f(float[] q, int fieldwidth, int precision) {
        float[] aa = Quat4f.getAxisAngle4fFromQuat4f(q);
        StringBuffer buf = new StringBuffer();
        buf.append("\nrotation axis = ");
        buf.append(Vec3f.toString(aa, fieldwidth, precision));
        buf.append("   angle = ");
        buf.append(String.format("%6.3f", Float.valueOf(aa[3])));
        buf.append("  (");
        buf.append(String.format("%5.1f", (double)(aa[3] * 180.0f) / Math.PI));
        buf.append(" degrees)");
        return buf.toString();
    }

    public static String explainQuat4f(float[] q) {
        return Quat4f.explainQuat4f(q, 6, 3);
    }

    public static void pow(float[] qout, float p, float[] qin) {
        double alpha = 2.0 * Math.acos(qin[0]);
        double a = alpha <= 0.019 ? 1.0 / (0.5 + alpha * alpha / 48.0) : alpha / Math.sin(alpha * 0.5);
        double vx = a * (double)qin[1] * (double)p;
        double vy = a * (double)qin[2] * (double)p;
        double vz = a * (double)qin[3] * (double)p;
        alpha = Math.sqrt(vx * vx + vy * vy + vz * vz);
        a = alpha <= 0.019 ? 0.5 + alpha * alpha / 48.0 : Math.sin(alpha * 0.5) / alpha;
        Quat4f.set(qout, (float)Math.cos(alpha * 0.5), (float)(a * vx), (float)(a * vy), (float)(a * vz));
    }

    public static void pow(float[] qin, float p) {
        Quat4f.pow(qin, p, qin);
    }

    public static void setAngularVelocityFromQuat4f(float[] avel, float[] q, float[] qrate) {
        avel[0] = -qrate[0] * q[1] + q[0] * qrate[1] - qrate[2] * q[3] + qrate[3] * q[2];
        avel[1] = -qrate[0] * q[2] + q[0] * qrate[2] - qrate[3] * q[1] + qrate[1] * q[3];
        avel[2] = -qrate[0] * q[3] + q[0] * qrate[3] - qrate[1] * q[2] + qrate[2] * q[1];
        Vec3f.scale(2.0f, avel);
    }

    public static void setAngularVelocityFromQuat4f(float[] avel, int aVelIndex, float[] q, int qIndex, float[] qrate, int qRateIndex) {
        avel[aVelIndex] = -qrate[qRateIndex + 0] * q[qIndex + 1] + q[qIndex + 0] * qrate[qRateIndex + 1] - qrate[qRateIndex + 2] * q[qIndex + 3] + qrate[qRateIndex + 3] * q[qIndex + 2];
        avel[aVelIndex + 1] = -qrate[qRateIndex + 0] * q[qIndex + 2] + q[qIndex + 0] * qrate[qRateIndex + 2] - qrate[qRateIndex + 3] * q[qIndex + 1] + qrate[qRateIndex + 1] * q[qIndex + 3];
        avel[aVelIndex + 2] = -qrate[qRateIndex + 0] * q[qIndex + 3] + q[qIndex + 0] * qrate[qRateIndex + 3] - qrate[qRateIndex + 1] * q[qIndex + 2] + qrate[qRateIndex + 2] * q[qIndex + 1];
        Vec3f.scale(2.0f, avel, aVelIndex);
    }

    public static void setAngularAccelerationFromQuat4f(float[] aacc, float[] q, float[] qratediff) {
        aacc[0] = -qratediff[0] * q[1] + q[0] * qratediff[1] - qratediff[2] * q[3] + qratediff[3] * q[2];
        aacc[1] = -qratediff[0] * q[2] + q[0] * qratediff[2] - qratediff[3] * q[1] + qratediff[1] * q[3];
        aacc[2] = -qratediff[0] * q[3] + q[0] * qratediff[3] - qratediff[1] * q[2] + qratediff[2] * q[1];
        Vec3f.scale(2.0f, aacc);
    }

    public static void setAngularAccelerationFromQuat4f(float[] aacc, int aaccIndex, float[] q, int qIndex, float[] qratediff, int qRateDiffIndex) {
        aacc[aaccIndex] = -qratediff[qRateDiffIndex + 0] * q[qIndex + 1] + q[qIndex + 0] * qratediff[qRateDiffIndex + 1] - qratediff[qRateDiffIndex + 2] * q[qIndex + 3] + qratediff[qRateDiffIndex + 3] * q[qIndex + 2];
        aacc[aaccIndex + 1] = -qratediff[qRateDiffIndex + 0] * q[qIndex + 2] + q[qIndex + 0] * qratediff[qRateDiffIndex + 2] - qratediff[qRateDiffIndex + 3] * q[qIndex + 1] + qratediff[qRateDiffIndex + 1] * q[qIndex + 3];
        aacc[aaccIndex + 2] = -qratediff[qRateDiffIndex + 0] * q[qIndex + 3] + q[qIndex + 0] * qratediff[qRateDiffIndex + 3] - qratediff[qRateDiffIndex + 1] * q[qIndex + 2] + qratediff[qRateDiffIndex + 2] * q[qIndex + 1];
        Vec3f.scale(2.0f, aacc, aaccIndex);
    }

    public static void smooth(float[] q, float eps) {
        if (Math.abs(q[0] - 1.0f) < eps) {
            q[0] = 1.0f;
            q[1] = 0.0f;
            q[2] = 0.0f;
            q[3] = 0.0f;
        } else if (Math.abs(q[0] + 1.0f) < eps) {
            q[0] = -1.0f;
            q[1] = 0.0f;
            q[2] = 0.0f;
            q[3] = 0.0f;
        }
    }
}

