/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.NumMath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumMathTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDiff() {
        double[] sinBuf = new double[100];
        double[] sincosBuf = new double[200];
        double[] sinDiffBuf = new double[100];
        double[] sincosDiffBuf = new double[200];
        int i = 0;
        while (i < 100) {
            sinBuf[i] = Math.sin((double)i * 0.01);
            sincosBuf[i * 2] = Math.sin((double)i * 0.01);
            sincosBuf[i * 2 + 1] = Math.cos((double)i * 0.01);
            ++i;
        }
        NumMath.diff(sinDiffBuf, sinBuf, 0.01);
        i = 0;
        while (i < 99) {
            Assert.assertTrue((Math.abs(sinDiffBuf[i] - Math.cos((double)i * 0.01)) < 5.0E-4 ? 1 : 0) != 0);
            ++i;
        }
        NumMath.diff(sincosDiffBuf, sincosBuf, 0.01, 2);
        i = 1;
        while (i < 99) {
            Assert.assertTrue((Math.abs(sincosDiffBuf[i * 2] - Math.cos((double)i * 0.01)) < 5.0E-4 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(sincosDiffBuf[i * 2 + 1] + Math.sin((double)i * 0.01)) < 5.0E-4 ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((Math.abs(sincosDiffBuf[0] - Math.cos(0.0)) < 0.005 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(sincosDiffBuf[1] + Math.sin(0.0)) < 0.005 ? 1 : 0) != 0);
    }

    @Test
    public void testDiff2() {
        double[] sinBuf = new double[100];
        double[] sincosBuf = new double[200];
        double[] sinDiff2Buf = new double[100];
        double[] sincosDiff2Buf = new double[200];
        int i = 0;
        while (i < 100) {
            sinBuf[i] = Math.sin((double)i * 0.01);
            sincosBuf[i * 2] = Math.sin((double)i * 0.01);
            sincosBuf[i * 2 + 1] = Math.cos((double)i * 0.01);
            ++i;
        }
        NumMath.diff2(sinDiff2Buf, sinBuf, 0.01);
        i = 1;
        while (i < 99) {
            Assert.assertTrue((Math.abs(sinDiff2Buf[i] + Math.sin((double)i * 0.01)) < 5.0E-4 ? 1 : 0) != 0);
            ++i;
        }
        i = 1;
        while (i < 99) {
            Assert.assertTrue((Math.abs(NumMath.diff2(sinBuf[i - 1], sinBuf[i], sinBuf[i + 1], 0.01) + Math.sin((double)i * 0.01)) < 5.0E-4 ? 1 : 0) != 0);
            ++i;
        }
        NumMath.diff2(sincosDiff2Buf, sincosBuf, 0.01, 2);
        i = 1;
        while (i < 99) {
            Assert.assertTrue((Math.abs(sincosDiff2Buf[i * 2] + Math.sin((double)i * 0.01)) < 5.0E-4 ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(sincosDiff2Buf[i * 2 + 1] + Math.cos((double)i * 0.01)) < 5.0E-4 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testInterpolate() {
        double[] sinBuf = new double[100];
        double[] sincosBuf = new double[200];
        double[] dst = new double[2];
        int i = 0;
        while (i < 100) {
            sinBuf[i] = Math.sin((double)i * 0.01);
            sincosBuf[i * 2] = Math.sin((double)i * 0.01);
            sincosBuf[i * 2 + 1] = Math.cos((double)i * 0.01);
            ++i;
        }
        Assert.assertTrue((Math.abs(NumMath.interpolate(sinBuf, 0.01, 0.5) - Math.sin(0.5)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(NumMath.interpolate(sinBuf, 0.01, 0.511) - Math.sin(0.511)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01, 0.5);
        Assert.assertTrue((Math.abs(dst[0] - Math.sin(0.5)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dst[1] - Math.cos(0.5)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01, 0.511);
        Assert.assertTrue((Math.abs(dst[0] - Math.sin(0.511)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dst[1] - Math.cos(0.511)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01, 0.0);
        Assert.assertTrue((Math.abs(dst[0] - Math.sin(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dst[1] - Math.cos(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01, -1.0);
        Assert.assertTrue((Math.abs(dst[0] - Math.sin(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dst[1] - Math.cos(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, (double)0.01f, (double)0.99f);
        Assert.assertTrue((Math.abs(dst[0] - Math.sin(0.99)) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dst[1] - Math.cos(0.99)) < 0.01 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01, 1.0);
        Assert.assertTrue((Math.abs(dst[0] - Math.sin(1.0)) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dst[1] - Math.cos(1.0)) < 0.01 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01, 2.0);
        Assert.assertTrue((Math.abs(dst[0] - Math.sin(1.0)) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(dst[1] - Math.cos(1.0)) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testInterpolateFloat() {
        float[] sinBuf = new float[100];
        float[] sincosBuf = new float[200];
        float[] dst = new float[2];
        int i = 0;
        while (i < 100) {
            sinBuf[i] = (float)Math.sin((double)i * 0.01);
            sincosBuf[i * 2] = (float)Math.sin((double)i * 0.01);
            sincosBuf[i * 2 + 1] = (float)Math.cos((double)i * 0.01);
            ++i;
        }
        Assert.assertTrue((Math.abs((double)NumMath.interpolate(sinBuf, 0.01f, 0.5f) - Math.sin(0.5)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)NumMath.interpolate(sinBuf, 0.01f, 0.511f) - Math.sin(0.511)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01f, 0.5f);
        Assert.assertTrue((Math.abs((double)dst[0] - Math.sin(0.5)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)dst[1] - Math.cos(0.5)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01f, 0.511f);
        Assert.assertTrue((Math.abs((double)dst[0] - Math.sin(0.511)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)dst[1] - Math.cos(0.511)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01f, 0.0f);
        Assert.assertTrue((Math.abs((double)dst[0] - Math.sin(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)dst[1] - Math.cos(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01f, -1.0f);
        Assert.assertTrue((Math.abs((double)dst[0] - Math.sin(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)dst[1] - Math.cos(0.0)) < 5.0E-4 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01f, 0.99f);
        Assert.assertTrue((Math.abs((double)dst[0] - Math.sin(0.99)) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)dst[1] - Math.cos(0.99)) < 0.01 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01f, 1.0f);
        Assert.assertTrue((Math.abs((double)dst[0] - Math.sin(1.0)) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)dst[1] - Math.cos(1.0)) < 0.01 ? 1 : 0) != 0);
        NumMath.interpolate(dst, sincosBuf, 0.01f, 2.0f);
        Assert.assertTrue((Math.abs((double)dst[0] - Math.sin(1.0)) < 0.01 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)dst[1] - Math.cos(1.0)) < 0.01 ? 1 : 0) != 0);
    }
}

