/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

public final class NumMath {
    private NumMath() {
    }

    public static void diff(double[] dst, double[] x, double h) {
        int i = 1;
        while (i < x.length - 1) {
            dst[i] = (x[i + 1] - x[i - 1]) / (2.0 * h);
            ++i;
        }
        dst[0] = (x[1] - x[0]) / h;
    }

    public static void diff2(double[] dst, double[] x, double h) {
        int i = 1;
        while (i < x.length - 1) {
            dst[i] = (x[i + 1] - 2.0 * x[i] + x[i - 1]) / (h * h);
            ++i;
        }
    }

    public static float diff(float xPrev, float xNext, float h) {
        return (xNext - xPrev) / (2.0f * h);
    }

    public static double diff(double xPrev, double xNext, double h) {
        return (xNext - xPrev) / (2.0 * h);
    }

    public static float diff2(float xPrev, float xCurr, float xNext, float h) {
        return (xNext - 2.0f * xCurr + xPrev) / (h * h);
    }

    public static double diff2(double xPrev, double xCurr, double xNext, double h) {
        return (xNext - 2.0 * xCurr + xPrev) / (h * h);
    }

    public static void diff(double[] dst, double[] x, double h, int width) {
        int i = 1;
        while (i < x.length / width - 1) {
            int j = 0;
            while (j < width) {
                dst[i * width + j] = (x[(i + 1) * width + j] - x[(i - 1) * width + j]) / (2.0 * h);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < width) {
            dst[j] = (x[width + j] - x[j]) / h;
            ++j;
        }
    }

    public static void diff(float[] dst, float[] x, float h, int width) {
        int i = 1;
        while (i < x.length / width - 1) {
            int j = 0;
            while (j < width) {
                dst[i * width + j] = (x[(i + 1) * width + j] - x[(i - 1) * width + j]) / (2.0f * h);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < width) {
            dst[j] = (x[width + j] - x[j]) / h;
            ++j;
        }
    }

    public static void diff2(double[] dst, double[] x, double h, int width) {
        int i = 1;
        while (i < x.length / width - 1) {
            int j = 0;
            while (j < width) {
                dst[i * width + j] = (x[(i + 1) * width + j] - 2.0 * x[i * width + j] + x[(i - 1) * width + j]) / (h * h);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < width) {
            dst[i] = dst[width + i];
            ++i;
        }
    }

    public static void diff2(float[] dst, float[] x, float h, int width) {
        int i = 1;
        while (i < x.length / width - 1) {
            int j = 0;
            while (j < width) {
                dst[i * width + j] = (x[(i + 1) * width + j] - 2.0f * x[i * width + j] + x[(i - 1) * width + j]) / (h * h);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < width) {
            dst[i] = dst[width + i];
            ++i;
        }
    }

    public static double interpolate(double[] x, double h, double t) {
        int i = (int)(t / h);
        if (i > x.length - 1) {
            return x[x.length - 1];
        }
        if (i < 0) {
            return x[0];
        }
        return (t - (double)i * h) * (x[i + 1] - x[i]) / h + x[i];
    }

    public static float interpolate(float[] x, float h, float t) {
        int i = (int)(t / h);
        if (i > x.length - 1) {
            return x[x.length - 1];
        }
        if (i < 0) {
            return x[0];
        }
        return (t - (float)i * h) * (x[i + 1] - x[i]) / h + x[i];
    }

    public static void interpolate(double[] dst, double[] x, double h, double t) {
        int i = (int)(t / h);
        int width = dst.length;
        if (i > x.length / width - width) {
            System.arraycopy(x, x.length - width, dst, 0, width);
            return;
        }
        if (i <= 0) {
            System.arraycopy(x, 0, dst, 0, width);
            return;
        }
        int j = 0;
        while (j < width) {
            int k = i * width + j;
            dst[j] = (t - (double)i * h) * (x[k + width] - x[k]) / h + x[k];
            ++j;
        }
    }

    public static void interpolate(float[] dst, float[] x, float h, float t) {
        int i = (int)(t / h);
        int width = dst.length;
        if (i > x.length / width - width) {
            System.arraycopy(x, x.length - width, dst, 0, width);
            return;
        }
        if (i < 0) {
            System.arraycopy(x, 0, dst, 0, width);
            return;
        }
        int j = 0;
        while (j < width) {
            int k = i * width + j;
            dst[j] = (t - (float)i * h) * (x[k + width] - x[k]) / h + x[k];
            ++j;
        }
    }
}

