/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Mat;
import hmi.math.Mat3f;
import hmi.math.Mat4f;
import hmi.math.Vec3f;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MatTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testInvertMatrix() {
        float[] A = new float[9];
        float[] Ainv = new float[9];
        Mat3f.set(A, 2.0f, 3.0f, -6.0f, 1.0f, -6.0f, 8.0f, 3.0f, -2.0f, 1.0f);
        Mat.invertMatrix(A, 3, Ainv);
        float[] Prod = new float[9];
        Mat3f.mul(Prod, A, Ainv);
    }

    @Test
    public void testMul() {
        float[] m1 = Mat4f.getMat4f();
        int i = 0;
        while (i < 16) {
            m1[i] = i + 2;
            ++i;
        }
        float[] m2 = Mat4f.getMat4f();
        int i2 = 0;
        while (i2 < 16) {
            m2[i2] = i2 + 4;
            ++i2;
        }
        float[] m3 = Mat4f.getMat4f();
        float[] m4 = Mat4f.getMat4f();
        Mat4f.mul(m3, m1, m2);
        Mat.mul(m4, m1, 4, m2, 4);
        Assert.assertTrue((boolean)Mat4f.epsilonEquals(m4, m3, 1.0E-6f));
        float[] v1 = new float[3];
        float[] v2 = new float[3];
        float[] v3 = new float[1];
        Vec3f.set(v1, 1.0f, 2.0f, 3.0f);
        Vec3f.set(v2, 3.0f, 4.0f, 5.0f);
        Mat.mul(v3, v1, 3, v2, 1);
        Assert.assertTrue((Math.abs(Vec3f.dot(v1, v2) - v3[0]) < 1.0E-6f ? 1 : 0) != 0);
    }
}

