/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Bezier2f;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Bezier2fTest {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void basics() {
        float[] px = new float[]{0.0f, 2.0f, 3.0f, 6.0f, 9.0f, 10.0f, 15.0f};
        float[] py = new float[]{0.0f, 2.0f, 2.0f, 0.0f, -2.0f, 4.0f, 0.0f};
        Bezier2f bez = new Bezier2f(px, py);
        float[] p = new float[2];
        bez.eval(p, 0.0f);
        bez.eval(p, 0.4f);
        bez.eval(p, 0.5f);
        bez.eval(p, 0.8f);
        bez.eval(p, 1.0f);
    }

    @Test
    public void mergedCoordTest() {
        float[] points = new float[]{0.0f, 0.0f, 2.0f, 2.0f, 3.0f, 2.0f, 6.0f, 0.0f, 9.0f, -2.0f, 10.0f, 4.0f, 15.0f, 0.0f};
        Bezier2f bez = new Bezier2f(points);
        float[] p = new float[2];
        bez.eval(p, 0.0f);
        bez.eval(p, 0.4f);
        bez.eval(p, 0.5f);
        bez.eval(p, 0.8f);
        bez.eval(p, 1.0f);
    }

    @Test
    public void pointsVectorsWeightsTest() {
        float[] p0 = new float[]{0.0f, 0.0f};
        float[] v0 = new float[]{1.0f, 1.0f};
        float[] p1 = new float[]{6.0f, 0.0f};
        float[] v1 = new float[]{3.0f, -2.0f};
        float[] p2 = new float[]{15.0f, 0.0f};
        float[] v2 = new float[]{5.0f, -4.0f};
        float[][] points = new float[][]{p0, p1, p2};
        float[][] vectors = new float[][]{v0, v1, v2};
        float[] weights = new float[]{2.0f, 1.0f, 1.0f, 1.0f};
        Bezier2f bez = Bezier2f.bezier2fFromPointsVectorsWeights(points, vectors, weights);
        float fminus = bez.evalFX(-1.0f);
        System.out.println("fminus=" + fminus);
        float f0 = bez.evalFX(0.0f);
        System.out.println("f0=" + f0);
        float f3 = bez.evalFX(3.0f);
        System.out.println("f3=" + f3);
        float f6 = bez.evalFX(6.0f);
        System.out.println("f6=" + f6);
        float f8 = bez.evalFX(8.0f);
        System.out.println("f8=" + f8);
        float f12 = bez.evalFX(12.0f);
        System.out.println("f12=" + f12);
        float f15 = bez.evalFX(15.0f);
        System.out.println("f15=" + f15);
    }

    @Test
    public void pointsVectorsSingleWeightsTest() {
        float[] p0 = new float[]{0.0f, 0.0f};
        float[] v0 = new float[]{1.0f, 1.0f};
        float[] p1 = new float[]{6.0f, 0.0f};
        float[] v1 = new float[]{3.0f, -2.0f};
        float[] p2 = new float[]{15.0f, 0.0f};
        float[] v2 = new float[]{5.0f, -4.0f};
        float[][] points = new float[][]{p0, p1, p2};
        float[][] vectors = new float[][]{v0, v1, v2};
        float[] weights = new float[]{2.0f, 1.0f, 1.0f};
        Bezier2f bez = Bezier2f.bezier2fFromPointsVectorsSingleWeights(points, vectors, weights);
        float fminus = bez.evalFX(-1.0f);
        System.out.println("fminus=" + fminus);
        float f0 = bez.evalFX(0.0f);
        System.out.println("f0=" + f0);
        float f3 = bez.evalFX(3.0f);
        System.out.println("f3=" + f3);
        float f6 = bez.evalFX(6.0f);
        System.out.println("f6=" + f6);
        float f8 = bez.evalFX(8.0f);
        System.out.println("f8=" + f8);
        float f12 = bez.evalFX(12.0f);
        System.out.println("f12=" + f12);
        float f15 = bez.evalFX(15.0f);
        System.out.println("f15=" + f15);
    }

    @Test
    public void evalFXTest() {
        float[] px = new float[]{0.0f, 2.0f, 3.0f, 6.0f, 9.0f, 10.0f, 15.0f};
        float[] py = new float[]{0.0f, 2.0f, 2.0f, 0.0f, -2.0f, 4.0f, 0.0f};
        Bezier2f bez = new Bezier2f(px, py);
        float fminus = bez.evalFX(-1.0f);
        System.out.println("fminus=" + fminus);
        float f0 = bez.evalFX(0.0f);
        System.out.println("f0=" + f0);
        float f3 = bez.evalFX(3.0f);
        System.out.println("f3=" + f3);
        float f6 = bez.evalFX(6.0f);
        System.out.println("f6=" + f6);
        float f8 = bez.evalFX(8.0f);
        System.out.println("f8=" + f8);
        float f12 = bez.evalFX(12.0f);
        System.out.println("f12=" + f12);
        float f15 = bez.evalFX(15.0f);
        System.out.println("f15=" + f15);
    }
}

