/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import hmi.math.Bezier1f;

public class Bezier2f {
    private Bezier1f xspline;
    private Bezier1f yspline;
    private float low = 0.0f;
    private float high = 1.0f;
    private int np;
    private int nseg;
    private static final float EPS = 1.0E-7f;

    public Bezier2f(float[][] points, float[][] controlPoints) {
    }

    public Bezier2f(float[] points) {
        this.xspline = new Bezier1f(points, 0, 2);
        this.yspline = new Bezier1f(points, 1, 2);
        this.np = points.length / 2;
        this.nseg = (this.np - 1) / 3;
    }

    public Bezier2f(float[] xcoords, float[] ycoords) {
        this.xspline = new Bezier1f(xcoords);
        this.yspline = new Bezier1f(ycoords);
        this.np = xcoords.length;
        this.nseg = (this.np - 1) / 3;
    }

    public static Bezier2f bezier2fFromPointsVectorsWeights(float[][] points2f, float[][] vectors2f, float[] weights) {
        float w;
        int nip = points2f.length;
        int np = 3 * nip - 2;
        if (vectors2f.length != nip) {
            throw new RuntimeException("Bezier2f.bezier2fFromPointsVectorsWeights: number of vectors (" + vectors2f.length + ") should be equal to number of interpolated points (" + nip + ")");
        }
        int ncp = 2 * nip - 2;
        if (weights.length != ncp) {
            throw new RuntimeException("Bezier2f.bezier2fFromPointsVectorsWeights: number of weights (" + weights.length + ")  for " + nip + " interpolated points should be equal to : (" + ncp + ")");
        }
        float[] points = new float[2 * np];
        int i = 0;
        while (i < nip) {
            points[6 * i] = points2f[i][0];
            points[6 * i + 1] = points2f[i][1];
            ++i;
        }
        i = 0;
        while (i < nip - 1) {
            w = weights[2 * i];
            points[6 * i + 2] = points2f[i][0] + w * vectors2f[i][0];
            points[6 * i + 3] = points2f[i][1] + w * vectors2f[i][1];
            ++i;
        }
        i = 1;
        while (i < nip) {
            w = weights[2 * i - 1];
            points[6 * i - 2] = points2f[i][0] - w * vectors2f[i][0];
            points[6 * i - 1] = points2f[i][1] - w * vectors2f[i][1];
            ++i;
        }
        Bezier2f result = new Bezier2f(points);
        return result;
    }

    public static Bezier2f bezier2fFromPointsVectorsSingleWeights(float[][] points2f, float[][] vectors2f, float[] weights) {
        int nip = points2f.length;
        if (weights.length != nip) {
            throw new RuntimeException("Bezier2f.bezier2fFromPointsVectorsSingleWeights: number of weights (" + weights.length + ") should be equal to number of interpolated points (" + nip + ")");
        }
        float[] w = new float[2 * nip - 2];
        int i = 1;
        while (i < nip - 1) {
            w[2 * i - 1] = weights[i];
            w[2 * i] = weights[i];
            ++i;
        }
        w[0] = weights[0];
        w[2 * nip - 3] = weights[nip - 1];
        return Bezier2f.bezier2fFromPointsVectorsWeights(points2f, vectors2f, w);
    }

    public void setRange(float low, float high) {
        this.low = low;
        this.high = high;
        this.xspline.setRange(low, high);
        this.yspline.setRange(low, high);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Bezier2f[ ");
        buf.append(" ]");
        return buf.toString();
    }

    public float[] eval(float[] result, float u) {
        float ru;
        int index;
        if (u < this.low) {
            u = this.low;
        }
        if (u > this.high) {
            u = this.high;
        }
        if ((index = (int)Math.floor(ru = (float)this.nseg * (u - this.low) / (this.high - this.low))) >= this.nseg) {
            index = this.nseg - 1;
        }
        float t = ru - (float)index;
        float s = 1.0f - t;
        float b0 = s * s * s;
        float b1 = 3.0f * t * s * s;
        float b2 = 3.0f * t * t * s;
        float b3 = t * t * t;
        result[0] = this.xspline.eval4(3 * index, b0, b1, b2, b3);
        result[1] = this.yspline.eval4(3 * index, b0, b1, b2, b3);
        return result;
    }

    public float evalFX(float x) {
        return this.evalFX(x, this.low, this.high);
    }

    public float evalFX(float x, float low, float high) {
        float uhigh;
        float ulow;
        if (this.xspline.eval(low) <= this.xspline.eval(high)) {
            ulow = low;
            uhigh = high;
        } else {
            ulow = high;
            uhigh = low;
        }
        if (x <= this.xspline.eval(ulow)) {
            return this.yspline.eval(ulow);
        }
        if (x >= this.xspline.eval(uhigh)) {
            return this.yspline.eval(uhigh);
        }
        float umid = (ulow + uhigh) / 2.0f;
        while (Math.abs(uhigh - ulow) > 1.0E-7f) {
            float xmid = this.xspline.eval(umid);
            if (xmid < x) {
                ulow = umid;
            } else {
                uhigh = umid;
            }
            umid = (ulow + uhigh) / 2.0f;
        }
        return this.yspline.eval(umid);
    }
}

