/*
 * Decompiled with CFR 0.152.
 */
package hmi.math;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bezier1f {
    private Logger logger = LoggerFactory.getLogger((String)Bezier1f.class.getName());
    private float[] p;
    private int np;
    private int nseg;
    private float low = 0.0f;
    private float high = 1.0f;
    private static final float EPS = 1.0E-7f;

    public Bezier1f(float[] points) {
        this(points, 0, 1);
    }

    public Bezier1f(float[] points, int offset, int stride) {
        if (points == null) {
            throw new RuntimeException("Bezier curve with null points array");
        }
        this.np = points.length / stride - offset / stride;
        this.p = new float[this.np];
        int i = 0;
        while (i < this.np) {
            this.p[i] = points[offset + i * stride];
            ++i;
        }
        this.nseg = (this.np - 1) / 3;
    }

    public void setRange(float ulow, float uhigh) {
        this.low = ulow;
        this.high = uhigh;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Bezier[ ");
        int i = 0;
        while (i < this.np - 1) {
            buf.append(this.p[i]);
            buf.append(", ");
            ++i;
        }
        buf.append(this.p[this.np - 1]);
        buf.append(" ]");
        return buf.toString();
    }

    public float eval(float u) {
        float ru;
        int index;
        if (u < this.low) {
            u = this.low;
        }
        if (u > this.high) {
            u = this.high;
        }
        if ((index = (int)Math.floor(ru = (float)this.nseg * (u - this.low) / (this.high - this.low))) >= this.nseg) {
            index = this.nseg - 1;
        }
        float t = ru - (float)index;
        float s = 1.0f - t;
        float b0 = s * s * s;
        float b1 = 3.0f * t * s * s;
        float b2 = 3.0f * t * t * s;
        float b3 = t * t * t;
        return this.eval4(3 * index, b0, b1, b2, b3);
    }

    protected float eval4(int i, float b0, float b1, float b2, float b3) {
        return b0 * this.p[i] + b1 * this.p[i + 1] + b2 * this.p[i + 2] + b3 * this.p[i + 3];
    }

    public float evalInverse(float x) {
        float xlow = this.p[0];
        float xhigh = this.p[this.np - 1];
        float ulow = this.low;
        float uhigh = this.high;
        if (xlow > xhigh) {
            float tmp = xhigh;
            xhigh = xlow;
            xlow = tmp;
            tmp = uhigh;
            uhigh = ulow;
            ulow = tmp;
        }
        if (x <= xlow) {
            return ulow;
        }
        if (x >= xhigh) {
            return uhigh;
        }
        float umid = (ulow + uhigh) / 2.0f;
        float udiff = Math.abs(uhigh - ulow);
        float xmid = this.eval(umid);
        while (udiff > 1.0E-7f) {
            if (xmid < x) {
                ulow = umid;
                xlow = xmid;
            } else {
                uhigh = umid;
                xhigh = xmid;
            }
            umid = (ulow + uhigh) / 2.0f;
            xmid = this.eval(umid);
            udiff = Math.abs(uhigh - ulow);
        }
        this.logger.debug("evalInverse {} = {}", (Object)Float.valueOf(x), (Object)Float.valueOf(umid));
        return umid;
    }
}

