/*
 * Decompiled with CFR 0.152.
 */
package hmi.jnaoqiembodiment.loader;

import asap.environment.AsapVirtualHuman;
import asap.environment.EmbodimentLoader;
import asap.environment.Loader;
import asap.utils.Environment;
import hmi.jnaoqiembodiment.NaoQiEmbodiment;
import hmi.xml.XMLScanException;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;

public class NaoQiEmbodimentLoader
implements EmbodimentLoader {
    private String id = "";
    private NaoQiEmbodiment embodiment;

    public String getId() {
        return this.id;
    }

    public void readXML(XMLTokenizer tokenizer, String newId, AsapVirtualHuman avh, Environment[] environments, Loader ... requiredLoaders) throws IOException {
        this.id = newId;
        NaoQiElement nq = null;
        if (tokenizer.atSTag(NaoQiElement.xmlTag())) {
            nq = new NaoQiElement();
            nq.readXML(tokenizer);
        }
        if (nq == null) {
            throw new XMLScanException("No inner noaqi element in NaoQiEmbodimentLoader");
        }
        this.embodiment = new NaoQiEmbodiment(this.id, nq.getIp(), nq.getPort());
    }

    public void unload() {
    }

    public NaoQiEmbodiment getEmbodiment() {
        return this.embodiment;
    }

    private static class NaoQiElement
    extends XMLStructureAdapter {
        private String ip;
        private int port;
        private static final String XMLTAG = "naoqi";

        private NaoQiElement() {
        }

        public static String xmlTag() {
            return XMLTAG;
        }

        public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
            this.ip = this.getRequiredAttribute("ip", attrMap, tokenizer);
            this.port = this.getRequiredIntAttribute("port", attrMap, tokenizer);
            super.decodeAttributes(attrMap, tokenizer);
        }

        public String getXMLTag() {
            return XMLTAG;
        }

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }
    }
}

