/*
 * Decompiled with CFR 0.152.
 */
package hmi.jnaoqiembodiment;

import asap.utils.EulerHeadEmbodiment;
import com.aldebaran.proxy.DCMProxy;
import hmi.jnaoqiembodiment.NaoDCMUtils;

public class NaoHeadEmbodiment
implements EulerHeadEmbodiment {
    private final String id;
    private DCMProxy dcmProxy;

    public NaoHeadEmbodiment(String id, DCMProxy dcmProxy) {
        this.dcmProxy = dcmProxy;
        this.id = id;
        NaoDCMUtils.smoothlySetStiffness("HeadYaw", dcmProxy);
        NaoDCMUtils.smoothlySetStiffness("HeadPitch", dcmProxy);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setHeadRollPitchYawDegrees(float roll, float pitch, float yaw) {
        NaoDCMUtils.setJointRotation("HeadYaw", (float)Math.toRadians(yaw), this.dcmProxy);
        NaoDCMUtils.setJointRotation("HeadPitch", (float)Math.toRadians(pitch), this.dcmProxy);
    }

    public void shutdown() {
        NaoDCMUtils.smoothlyResetStiffness("HeadYaw", this.dcmProxy);
        NaoDCMUtils.smoothlyResetStiffness("HeadPitch", this.dcmProxy);
    }

    static {
        System.loadLibrary("JNaoQi");
    }
}

