// Generated by delombok at Fri Jul 12 17:03:40 CEST 2013
package hmi.jcomponentenvironment.loader;

import hmi.environmentbase.EmbodimentLoader;
import hmi.environmentbase.Environment;
import hmi.environmentbase.Loader;
import hmi.jcomponentenvironment.JComponentEmbodiment;
import hmi.jcomponentenvironment.JComponentEnvironment;
import hmi.util.ArrayUtils;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
/**
 * Loader for JComponentEmbodiments from a JComponentEnvironment
 * @author Herwin
 * 
 */

public class JComponentEmbodimentLoader implements EmbodimentLoader {
	
	private String id = "";
	private JComponentEmbodiment embodiment;
	
	public JComponentEmbodiment getEmbodiment() {
		return embodiment;
	}
	
	private class JComponentInfo extends XMLStructureAdapter {
		
		private String id;
		
		public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
			id = getRequiredAttribute("id", attrMap, tokenizer);
		}
		
		public String getXMLTag() {
			return XMLTAG;
		}
		public static final String XMLTAG = "JComponent";
		
		@java.lang.SuppressWarnings("all")
		public String getId() {
			return this.id;
		}
	}
	
	@Override
	public void readXML(XMLTokenizer tokenizer, String loaderId, String vhId, String vhName, Environment[] environments, Loader... requiredLoaders) throws IOException {
		id = loaderId;
		JComponentEnvironment jce = ArrayUtils.getFirstClassOfType(environments, JComponentEnvironment.class);
		if (jce == null) {
			throw tokenizer.getXMLScanException("JComponentEmbodimentLoader requires an JComponentEnvironment");
		}
		JComponentInfo jci = null;
		if (tokenizer.atSTag()) {
			String tag = tokenizer.getTagName();
			if (tag.equals(JComponentInfo.XMLTAG)) {
				jci = new JComponentInfo();
				jci.readXML(tokenizer);
			}
		}
		if (jci == null) {
			throw tokenizer.getXMLScanException("JComponentEmbodimentLoader requires an JComponent section");
		}
		embodiment = jce.getJComponentEmbodiment(jci.getId());
		if (embodiment == null) {
			throw tokenizer.getXMLScanException("No JComponent with id " + jci.getId() + "registered in the environment");
		}
	}
	
	@Override
	public void unload() {
	}
	
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}
	
	@java.lang.SuppressWarnings("all")
	public void setId(final String id) {
		this.id = id;
	}
}