/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util.basicobjects;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;

public class SimpleLightState
implements GLRenderObject {
    private float[] ambient = new float[4];
    private float[] diffuse = new float[4];
    private float[] specular = new float[4];
    private float[] position = new float[4];
    private float[] originpos = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private boolean enabled = true;
    private int gl_light;

    public SimpleLightState(int gl_light) {
        this.setAmbientColor(0.0f, 0.0f, 0.0f);
        this.setDiffuseColor(1.0f, 1.0f, 1.0f);
        this.setSpecularColor(0.0f, 0.0f, 0.0f);
        this.setDirection(0.0f, 0.0f, 1.0f);
        this.gl_light = gl_light;
        this.enabled = true;
    }

    public void setAmbientColor(float r, float g, float b) {
        this.ambient[0] = r;
        this.ambient[1] = g;
        this.ambient[2] = b;
        this.ambient[3] = 1.0f;
    }

    public void setDiffuseColor(float r, float g, float b) {
        this.diffuse[0] = r;
        this.diffuse[1] = g;
        this.diffuse[2] = b;
        this.diffuse[3] = 1.0f;
    }

    public void setSpecularColor(float r, float g, float b) {
        this.specular[0] = r;
        this.specular[1] = g;
        this.specular[2] = b;
        this.specular[3] = 1.0f;
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        this.position[3] = 1.0f;
    }

    public void setPosition(float[] pos) {
        this.setPosition(pos[0], pos[1], pos[2]);
    }

    public float[] getPosition() {
        return this.position;
    }

    public void setDirection(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        this.position[3] = 0.0f;
    }

    public synchronized void setEnabled(boolean e) {
        this.enabled = e;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        gl.glLightfv(this.gl_light, 4608, this.ambient);
        gl.glLightfv(this.gl_light, 4609, this.diffuse);
        gl.glLightfv(this.gl_light, 4610, this.specular);
        if (this.enabled) {
            gl.glEnable(this.gl_light);
        } else {
            gl.glDisable(this.gl_light);
        }
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (!this.enabled) {
            return;
        }
        gl.glLightfv(this.gl_light, 4611, this.originpos);
    }
}

