/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.VJoint;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.GShape;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.graphics.util.ColladaReader;
import hmi.graphics.util.DaeHumanoidLoader;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class SegmentedDaeHumanoidLoader
implements DaeHumanoidLoader {
    private VJoint avatarAnimationRootJoint;
    private VGLNode avatarRenderNode;
    private VJoint avatarRenderRootJoint;
    private GLScene glScene;
    private GNode gnode;

    @Override
    public VJoint getAvatarAnimationRootJoint() {
        return this.avatarAnimationRootJoint;
    }

    @Override
    public VGLNode getAvatarRenderNode() {
        return this.avatarRenderNode;
    }

    @Override
    public VJoint getAvatarRenderRootJoint() {
        return this.avatarRenderRootJoint;
    }

    @Override
    public GLScene getGLScene() {
        return this.glScene;
    }

    public GNode getGnode() {
        return this.gnode;
    }

    private SegmentedDaeHumanoidLoader() {
    }

    public SegmentedDaeHumanoidLoader(String id, Resources resources, String daeFile, String colladaRenamingFile, float colladaScalingFactor, String colladaIncludeDir, boolean setToHAnim) throws IOException {
        ColladaReader.addColladaDirectory(colladaIncludeDir);
        BufferedReader colladaReader = resources.getReader(daeFile);
        Collada col = new Collada(new XMLTokenizer((Reader)colladaReader), new Resources(colladaIncludeDir));
        String renaming = "";
        if (colladaRenamingFile != null && !colladaRenamingFile.equals("")) {
            renaming = resources.read(colladaRenamingFile);
        }
        GScene gscene = ColladaTranslator.colladaToGScene(col, renaming, colladaScalingFactor, false);
        this.gnode = null;
        for (GNode rNode : gscene.getRootNodes()) {
            rNode.removeLinearTransforms();
            this.gnode = rNode.getPartBySid("HumanoidRoot");
            if (this.gnode == null) continue;
            break;
        }
        this.gnode.removeLinearTransforms();
        VertexAttribute.setShowVertexAttributeData(false);
        GMesh.showGMeshData(false);
        this.glScene = ScenegraphTranslator.fromGSceneToGLScene(gscene);
        for (VJoint r : this.glScene.getVJointRoots()) {
            this.avatarRenderRootJoint = r.getPart("HumanoidRoot");
            if (this.avatarRenderRootJoint == null) continue;
            break;
        }
        if (setToHAnim) {
            float[] armDir = Vec3f.getVec3f();
            Vec3f.set((float[])armDir, (float)0.0f, (float)-1.0f, (float)0.0f);
            this.alignJoint("r_shoulder", "r_elbow", armDir);
            this.alignJoint("l_shoulder", "l_elbow", armDir);
            if (this.avatarRenderRootJoint.getPart("l_thumb1") != null && this.avatarRenderRootJoint.getPart("l_thumb2") != null) {
                float[] thumbDir = Vec3f.getVec3f();
                Vec3f.set((float[])thumbDir, (float)0.0f, (float)-1.0f, (float)1.0f);
                this.alignJoint("l_thumb1", "l_thumb2", thumbDir);
                this.alignJoint("l_thumb2", "l_thumb3", thumbDir);
                Vec3f.set((float[])thumbDir, (float)0.0f, (float)-1.0f, (float)1.0f);
                this.alignJoint("r_thumb1", "r_thumb2", thumbDir);
                this.alignJoint("r_thumb2", "r_thumb3", thumbDir);
            }
        }
        this.glScene = ScenegraphTranslator.fromGSceneToGLScene(gscene);
        this.avatarRenderNode = new VGLNode(this.avatarRenderRootJoint, this.glScene.getGLShapeList());
        this.avatarAnimationRootJoint = this.avatarRenderRootJoint.masterCloneTree();
        this.avatarAnimationRootJoint.setId("HumanoidRoot_" + id);
        this.avatarAnimationRootJoint.setSid("HumanoidRoot");
        this.avatarAnimationRootJoint.setName("The HumanoidRoot " + id);
        GLShape state = new GLShape();
        state.addGLState(new GLFill());
        this.avatarRenderNode.getGLShapeList().prepend(state);
    }

    private void alignJoint(String jointName, String nextJoint, float[] dir) {
        Vec3f.normalize((float[])dir);
        float[] q = Quat4f.getQuat4f();
        float[] axis = Vec3f.getVec3f();
        float[] thumbCurr = Vec3f.getVec3f();
        VJoint th2 = this.avatarRenderRootJoint.getPart(nextJoint);
        VJoint th1 = this.avatarRenderRootJoint.getPart(jointName);
        th2.getPathTranslation(th1, thumbCurr);
        Vec3f.normalize((float[])thumbCurr);
        Vec3f.cross((float[])axis, (float[])dir, (float[])thumbCurr);
        float angle = (float)Math.acos(Vec3f.dot((float[])thumbCurr, (float[])dir));
        Quat4f.setFromAxisAngle4f((float[])q, (float)axis[0], (float)axis[1], (float)axis[2], (float)angle);
        Quat4f.inverse((float[])q);
        this.deformMesh(jointName, this.gnode, q);
        this.rotateVJoint(this.avatarRenderRootJoint.getPartById(jointName), q);
    }

    private void deformMesh(String name, GNode node, float[] q) {
        GNode startNode = this.findNode(node, name);
        this.rotateMeshInNodes(startNode, q);
    }

    private void rotateVJoint(VJoint v, float[] q) {
        float[] vec = Vec3f.getVec3f();
        v.setRotation(q);
        v.getPathTranslation(null, vec);
        this.transJoint(v, vec);
        v.setRotation(1.0f, 0.0f, 0.0f, 0.0f);
    }

    private void transJoint(VJoint v, float[] vPrev) {
        float[] vec = Vec3f.getVec3f();
        for (VJoint vj : v.getChildren()) {
            vj.getPathTranslation(null, vec);
            Vec3f.sub((float[])vec, (float[])vPrev);
            vj.setTranslation(vec);
            vj.getPathTranslation(null, vec);
            this.transJoint(vj, vec);
        }
    }

    private GNode findNode(GNode start, String name) {
        for (GNode n : start.getGNodes()) {
            if (n.getId().equals(name)) {
                return n;
            }
            GNode n2 = this.findNode(n, name);
            if (n2 == null) continue;
            return n2;
        }
        return null;
    }

    private void rotateMeshInNodes(GNode startNode, float[] q) {
        float[] m = Mat4f.getMat4f();
        Mat4f.setIdentity((float[])m);
        Mat4f.setRotation((float[])m, (float[])q);
        for (GShape gs : startNode.getGShapes()) {
            gs.getGMesh().affineTransform(m);
        }
        for (GNode node : startNode.getGNodes()) {
            this.rotateMeshInNodes(node, q);
        }
    }
}

