/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.VJoint;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.util.ColladaReader;
import hmi.graphics.util.DaeHumanoidLoader;
import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class SeamlessDaeHumanoidLoader
implements DaeHumanoidLoader {
    private VJoint avatarAnimationRootJoint;
    private VGLNode avatarRenderNode;
    private VJoint avatarRenderRootJoint;
    private GLScene glScene;

    @Override
    public VJoint getAvatarAnimationRootJoint() {
        return this.avatarAnimationRootJoint;
    }

    @Override
    public VGLNode getAvatarRenderNode() {
        return this.avatarRenderNode;
    }

    @Override
    public VJoint getAvatarRenderRootJoint() {
        return this.avatarRenderRootJoint;
    }

    @Override
    public GLScene getGLScene() {
        return this.glScene;
    }

    private SeamlessDaeHumanoidLoader() {
    }

    public SeamlessDaeHumanoidLoader(String id, Resources resources, String daeFile, String colladaRenamingFile, float colladaScalingFactor, String colladaIncludeDir, boolean setToHAnim, String colladaRenderRootNode) throws IOException {
        ColladaReader.addColladaDirectory(colladaIncludeDir);
        BufferedReader colladaReader = resources.getReader(daeFile);
        Collada col = new Collada(new XMLTokenizer((Reader)colladaReader), new Resources(colladaIncludeDir));
        String renaming = "";
        if (colladaRenamingFile != null && !colladaRenamingFile.equals("")) {
            renaming = resources.read(colladaRenamingFile);
        }
        GScene gscene = ColladaTranslator.colladaToGScene(col, renaming, colladaScalingFactor, setToHAnim);
        this.glScene = ScenegraphTranslator.fromGSceneToGLScene(gscene);
        this.avatarAnimationRootJoint = this.glScene.getVJoint("HumanoidRoot");
        this.avatarRenderRootJoint = this.glScene.getVJoint(colladaRenderRootNode);
        this.avatarAnimationRootJoint.setId("HumanoidRoot_" + id);
        this.avatarAnimationRootJoint.setSid("HumanoidRoot");
        this.avatarAnimationRootJoint.setName("The HumanoidRoot " + id);
        this.avatarRenderNode = new VGLNode(this.avatarRenderRootJoint, this.glScene.getGLShapeList());
        GLShape state = new GLShape();
        state.addGLState(new GLFill());
        this.avatarRenderNode.getGLShapeList().prepend(state);
    }
}

