/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.VJoint;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.opengl.GLShaderProgramLoader;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.graphics.opengl.renderobjects.MaterialState;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.opengl.state.GLFill;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.util.ColladaReader;
import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class LoadSeamlessDaeHumanoidInTPose {
    private VJoint animationJoint;
    private VGLNode avatarRenderNode;
    private VJoint renderJoint;
    private GLScene scene;
    private static final float SCALE = 0.01f;

    public VJoint getAnimationJoint() {
        return this.animationJoint;
    }

    public VGLNode getAvatarRenderNode() {
        return this.avatarRenderNode;
    }

    public VJoint getRenderJoint() {
        return this.renderJoint;
    }

    public GLScene getScene() {
        return this.scene;
    }

    public LoadSeamlessDaeHumanoidInTPose(String id, Resources resources, String daeFile, String renamingFile, String textureDir, String colladaDir, String shaderDir, String renderJointName, String skeletonRootName) {
        String renaming;
        Collada col;
        GLTextureLoader.addTextureDirectory(textureDir);
        ColladaReader.addColladaDirectory(colladaDir);
        GLShaderProgramLoader.addShaderDirectory(shaderDir);
        BufferedReader colladaReader = resources.getReader(daeFile);
        try {
            col = new Collada(new XMLTokenizer((Reader)colladaReader), new Resources(colladaDir));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            renaming = resources.read(renamingFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        GScene gscene = ColladaTranslator.colladaToGScene(col, renaming, 0.01f);
        this.scene = ScenegraphTranslator.fromGSceneToGLScene(gscene);
        this.renderJoint = this.scene.getVJoint(renderJointName);
        this.animationJoint = this.scene.getVJoint(skeletonRootName);
        this.animationJoint.setId("HumanoidRoot_" + id);
        this.animationJoint.setSid("HumanoidRoot");
        this.animationJoint.setName("The HumanoidRoot " + id);
        this.avatarRenderNode = new VGLNode(this.renderJoint, this.scene.getGLShapeList());
        MaterialState matState = new MaterialState();
        matState.mat_diffuse = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        matState.mat_specular = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        matState.mat_ambient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        matState.mat_emission = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        GLShape matShape = new GLShape();
        matShape.addGLState(matState);
        GLShape state = new GLShape();
        state.addGLState(new GLFill());
        this.avatarRenderNode.getGLShapeList().prepend(state);
    }
}

