/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.VJoint;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.GShape;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class LoadDaeHumanoidInTPose {
    private VJoint animationJoint;
    private VGLNode avatarNode;
    private VJoint renderJoint;
    private GNode gnode;

    public VJoint getAnimationJoint() {
        return this.animationJoint;
    }

    public VGLNode getAvatarNode() {
        return this.avatarNode;
    }

    public VJoint getRenderJoint() {
        return this.renderJoint;
    }

    public GNode getGnode() {
        return this.gnode;
    }

    private LoadDaeHumanoidInTPose() {
    }

    public LoadDaeHumanoidInTPose(Resources resources, String daeFile) {
        Collada col;
        BufferedReader colladaReader = resources.getReader(daeFile);
        try {
            col = new Collada(new XMLTokenizer((Reader)colladaReader));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        GScene gscene = ColladaTranslator.colladaSceneToGScene(col, col.getScene());
        this.gnode = null;
        for (GNode rNode : gscene.getRootNodes()) {
            rNode.removeLinearTransforms();
            this.gnode = rNode.getPartBySid("HumanoidRoot");
            if (this.gnode == null) continue;
            break;
        }
        this.gnode.removeLinearTransforms();
        VertexAttribute.setShowVertexAttributeData(false);
        GMesh.showGMeshData(false);
        GLScene gls = ScenegraphTranslator.fromGSceneToGLScene(gscene);
        for (VJoint r : gls.getVJointRoots()) {
            this.renderJoint = r.getPart("HumanoidRoot");
            if (this.renderJoint == null) continue;
            break;
        }
        float[] armDir = Vec3f.getVec3f();
        Vec3f.set((float[])armDir, (float)0.0f, (float)-1.0f, (float)0.0f);
        this.alignJoint("r_shoulder", "r_elbow", armDir);
        this.alignJoint("l_shoulder", "l_elbow", armDir);
        float[] thumbDir = Vec3f.getVec3f();
        Vec3f.set((float[])thumbDir, (float)0.0f, (float)-1.0f, (float)1.0f);
        this.alignJoint("l_thumb1", "l_thumb2", thumbDir);
        this.alignJoint("l_thumb2", "l_thumb3", thumbDir);
        Vec3f.set((float[])thumbDir, (float)0.0f, (float)-1.0f, (float)1.0f);
        this.alignJoint("r_thumb1", "r_thumb2", thumbDir);
        this.alignJoint("r_thumb2", "r_thumb3", thumbDir);
        this.avatarNode = new VGLNode(this.renderJoint, ScenegraphTranslator.fromGSceneToGLScene(gscene).getGLShapeList());
        this.animationJoint = this.renderJoint.masterCloneTree();
    }

    private void alignJoint(String jointName, String nextJoint, float[] dir) {
        Vec3f.normalize((float[])dir);
        float[] q = Quat4f.getQuat4f();
        float[] axis = Vec3f.getVec3f();
        float[] thumbCurr = Vec3f.getVec3f();
        VJoint th2 = this.renderJoint.getPart(nextJoint);
        VJoint th1 = this.renderJoint.getPart(jointName);
        th2.getPathTranslation(th1, thumbCurr);
        Vec3f.normalize((float[])thumbCurr);
        Vec3f.cross((float[])axis, (float[])dir, (float[])thumbCurr);
        float angle = (float)Math.acos(Vec3f.dot((float[])thumbCurr, (float[])dir));
        Quat4f.setFromAxisAngle4f((float[])q, (float)axis[0], (float)axis[1], (float)axis[2], (float)angle);
        Quat4f.inverse((float[])q);
        this.deformMesh(jointName, this.gnode, q);
        this.rotateVJoint(this.renderJoint.getPartById(jointName), q);
    }

    private void deformMesh(String name, GNode node, float[] q) {
        GNode startNode = this.findNode(node, name);
        this.rotateMeshInNodes(startNode, q);
    }

    private void rotateVJoint(VJoint v, float[] q) {
        float[] vec = Vec3f.getVec3f();
        v.setRotation(q);
        v.getPathTranslation(null, vec);
        this.transJoint(v, vec);
        v.setRotation(1.0f, 0.0f, 0.0f, 0.0f);
    }

    private void transJoint(VJoint v, float[] vPrev) {
        float[] vec = Vec3f.getVec3f();
        for (VJoint vj : v.getChildren()) {
            vj.getPathTranslation(null, vec);
            Vec3f.sub((float[])vec, (float[])vPrev);
            vj.setTranslation(vec);
            vj.getPathTranslation(null, vec);
            this.transJoint(vj, vec);
        }
    }

    private GNode findNode(GNode start, String name) {
        for (GNode n : start.getGNodes()) {
            if (n.getId().equals(name)) {
                return n;
            }
            GNode n2 = this.findNode(n, name);
            if (n2 == null) continue;
            return n2;
        }
        return null;
    }

    private void rotateMeshInNodes(GNode startNode, float[] q) {
        float[] m = Mat4f.getMat4f();
        Mat4f.setIdentity((float[])m);
        Mat4f.setRotation((float[])m, (float[])q);
        for (GShape gs : startNode.getGShapes()) {
            gs.getGMesh().affineTransform(m);
        }
        for (GNode node : startNode.getGNodes()) {
            this.rotateMeshInNodes(node, q);
        }
    }
}

