/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.animation.VJoint;
import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GScene;
import hmi.graphics.scenegraph.VertexAttribute;
import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LoadDaeHumanoid {
    private VJoint animationJoint;
    private VGLNode avatarNode;
    private VJoint renderJoint;
    private GNode gnode;

    public VJoint getAnimationJoint() {
        return this.animationJoint;
    }

    public VGLNode getAvatarNode() {
        return this.avatarNode;
    }

    public VJoint getRenderJoint() {
        return this.renderJoint;
    }

    public LoadDaeHumanoid(Resources resources, String daeFile) {
        Collada col;
        BufferedReader colladaReader = resources.getReader(daeFile);
        try {
            col = new Collada(new XMLTokenizer((Reader)colladaReader));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        GScene gscene = ColladaTranslator.colladaSceneToGScene(col, col.getScene());
        this.gnode = null;
        for (GNode rNode : gscene.getRootNodes()) {
            rNode.removeLinearTransforms();
            this.gnode = rNode.getPartBySid("HumanoidRoot");
            if (this.gnode == null) continue;
            break;
        }
        VertexAttribute.setShowVertexAttributeData(false);
        GMesh.showGMeshData(false);
        GLScene gls = ScenegraphTranslator.fromGSceneToGLScene(gscene);
        for (VJoint r : gls.getVJointRoots()) {
            this.renderJoint = r.getPart("HumanoidRoot");
            if (this.renderJoint == null) continue;
            break;
        }
        this.avatarNode = new VGLNode(this.renderJoint, ScenegraphTranslator.fromGSceneToGLScene(gscene).getGLShapeList());
        this.animationJoint = this.renderJoint.masterCloneTree();
    }
}

