/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.util;

import hmi.graphics.collada.Collada;
import hmi.graphics.collada.scenegraph.ColladaTranslator;
import hmi.graphics.opengl.scenegraph.GLScene;
import hmi.graphics.opengl.scenegraph.ScenegraphTranslator;
import hmi.graphics.scenegraph.GScene;
import hmi.util.ResourcePool;
import hmi.util.Resources;
import hmi.xml.XMLTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColladaReader {
    private static ResourcePool pool = new ResourcePool();
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.graphics.scenegraph");
    public static final String DEFAULT_COLLADA_RESOURCE_DIR = "dae";

    private ColladaReader() {
    }

    public static GLScene read(String colladaResourceDir, String colladaFileName) throws IOException {
        return ColladaReader.read(colladaResourceDir, colladaFileName, null, 1.0f);
    }

    public static GLScene read(String colladaResourceDir, String colladaFileName, String jointRenamingFileName, float scale) throws IOException {
        Resources resources = new Resources(colladaResourceDir);
        return ColladaReader.readGLSceneFromResourceFile(resources, colladaFileName, jointRenamingFileName, scale);
    }

    public static GLScene readGLSceneFromResourceFile(Resources resources, String colladaFileName, String jointRenamingFileName, float scale) throws IOException {
        GLScene glscene;
        GScene gscene = ColladaReader.readGSceneFromResourceFile(resources, colladaFileName, jointRenamingFileName, scale);
        if (gscene == null) {
            logger.warn("readGLSceneFromResourceFile: null gscene");
        }
        if (gscene == null) {
            logger.warn("readGLSceneFromResourceFile: null gscene");
        }
        if ((glscene = ScenegraphTranslator.fromGSceneToGLScene(gscene)) == null) {
            logger.warn("readGLSceneFromResourceFile: null gslcene");
        }
        if (glscene == null) {
            logger.warn("readGLSceneFromResourceFile: null gslcene");
        }
        return glscene;
    }

    public static GScene readGSceneFromResourceFile(Resources resources, String colladaFileName, String jointRenamingFileName, float scale) throws IOException {
        BufferedReader colladaReader = resources.getReader(colladaFileName);
        if (colladaReader == null) {
            logger.error("Null colladaReader");
        }
        Collada col = new Collada(new XMLTokenizer((Reader)colladaReader), resources);
        colladaReader.close();
        String renaming = resources.read(jointRenamingFileName);
        boolean setToHAnim = true;
        GScene gscene = ColladaTranslator.colladaToGScene(col, renaming, scale, setToHAnim);
        return gscene;
    }

    public static void addColladaDirectory(String dir) {
        pool.addResourceDirectory(dir);
    }

    public static GScene getGScene(String resourceName, String jointRenamingFileName, float scale) {
        try {
            GScene gscene = (GScene)((Object)pool.getResource(resourceName, new Object[]{jointRenamingFileName, Float.valueOf(scale)}));
            return gscene;
        }
        catch (IOException e) {
            logger.error("ColladaReader: " + e);
            return null;
        }
    }

    public static GLScene getGLScene(String resourceName, String jointRenamingFileName, float scale) {
        try {
            GScene gscene = (GScene)((Object)pool.getResource(resourceName, new Object[]{jointRenamingFileName, Float.valueOf(scale)}));
            GLScene glscene = ScenegraphTranslator.fromGSceneToGLScene(gscene);
            return glscene;
        }
        catch (IOException e) {
            logger.error("ColladaReader: " + e);
            return null;
        }
    }

    static {
        ResourcePool.ResourceLoader loader = new ResourcePool.ResourceLoader(){

            public Object loadResource(Resources res, String resourceName, Object[] par) throws IOException {
                String jointRenamingFileName = (String)par[0];
                float scale = ((Float)par[1]).floatValue();
                return ColladaReader.readGSceneFromResourceFile(res, resourceName, jointRenamingFileName, scale);
            }
        };
        pool.setResourceLoader(loader);
        pool.addResourceDirectory(DEFAULT_COLLADA_RESOURCE_DIR);
    }
}

