/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.graphics.scenegraph.GScene;
import hmi.math.Vec4f;
import hmi.util.Console;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;

public class VertexWeights
extends XMLStructureAdapter {
    private int[] jcount;
    private int[] jointIndices;
    private float[] jointWeights;
    private int[] offsets;
    private static Logger logger = GScene.getLogger();
    private static final float DEFAULT_EPSMIN = 0.1f;
    private static final float DEFAULT_EPSPLUS = 0.05f;
    private static final int JCOUNTSPERLINE = 60;
    private static final int INDICESPERLINE = 60;
    private static final int WEIGHTSPERLINE = 30;
    private static final String XMLTAG = "vertexweights";

    public VertexWeights() {
    }

    public VertexWeights(int[] jcount, int[] jointIndices, float[] jointWeights) {
        this.jcount = jcount;
        this.jointIndices = jointIndices;
        this.jointWeights = jointWeights;
        this.offsets = new int[jcount.length];
        this.calculateOffsets();
    }

    public VertexWeights(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    private int calculateOffsets() {
        int p = 0;
        for (int i = 0; i < this.jcount.length; ++i) {
            this.offsets[i] = p;
            p += this.jcount[i];
        }
        return p;
    }

    public int[] getJointIndices() {
        return this.jointIndices;
    }

    public float[] getJointWeights() {
        return this.jointWeights;
    }

    public int[] getJCounts() {
        return this.jcount;
    }

    protected void remapData(int nrOfDistinctVertices, int[] map) {
        this.checkAccumulatedWeights(0.1f, 0.05f, true);
        int[] oldVcount = this.jcount;
        int[] oldIndices = this.jointIndices;
        float[] oldWeights = this.jointWeights;
        int[] oldOffsets = this.offsets;
        this.jcount = new int[nrOfDistinctVertices];
        for (int i = 0; i < nrOfDistinctVertices; ++i) {
            this.jcount[i] = oldVcount[map[i]];
        }
        this.offsets = new int[nrOfDistinctVertices];
        int newSize = this.calculateOffsets();
        this.jointIndices = new int[newSize];
        this.jointWeights = new float[newSize];
        for (int i = 0; i < nrOfDistinctVertices; ++i) {
            int oldOffset = oldOffsets[map[i]];
            int newOffset = this.offsets[i];
            int vc = this.jcount[i];
            for (int j = 0; j < vc; ++j) {
                this.jointIndices[newOffset + j] = oldIndices[oldOffset + j];
                this.jointWeights[newOffset + j] = oldWeights[oldOffset + j];
            }
        }
        this.checkAccumulatedWeights(0.1f, 0.05f, true);
    }

    public boolean checkAccumulatedWeights(float epsmin, float epsplus, boolean showdeviations) {
        boolean result = true;
        int p = 0;
        for (int i = 0; i < this.jcount.length; ++i) {
            float accumulatedWeight = 0.0f;
            for (int j = 0; j < this.jcount[i]; ++j) {
                accumulatedWeight += this.jointWeights[p + j];
            }
            if (accumulatedWeight < 1.0f - epsmin || accumulatedWeight > 1.0f + epsplus) {
                result = false;
                if (showdeviations) {
                    Console.println((String)("checkAccumulatedWeights, vertex " + i + " accumulated weight: " + accumulatedWeight));
                }
            }
            p += this.jcount[i];
        }
        return result;
    }

    public float[] getVertexWeightColors(boolean useWeights, float[][] colorCoding) {
        int nrOfVertices = this.jcount.length;
        float[] colors = new float[4 * nrOfVertices];
        float[] accuColor = Vec4f.getVec4f();
        int p = 0;
        for (int i = 0; i < this.jcount.length; ++i) {
            Vec4f.set((float[])accuColor, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            for (int j = 0; j < this.jcount[i]; ++j) {
                int index = this.jointIndices[p + j];
                float w = useWeights ? this.jointWeights[p + j] : 1.0f;
                Vec4f.scaleAdd((float[])accuColor, (float)w, (float[])colorCoding[index], (float[])accuColor);
            }
            Vec4f.set((float[])colors, (int)(4 * i), (float[])accuColor, (int)0);
            p += this.jcount[i];
        }
        return colors;
    }

    public String toString() {
        return this.toXMLString();
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.jcount != null) {
            VertexWeights.appendIntArrayElement((StringBuilder)buf, (String)"jcount", (int[])this.jcount, (char)' ', (XMLFormatting)fmt, (int)60);
        }
        if (this.jointIndices != null) {
            VertexWeights.appendIntArrayElement((StringBuilder)buf, (String)"jointindices", (int[])this.jointIndices, (char)' ', (XMLFormatting)fmt, (int)60);
        }
        if (this.jointWeights != null) {
            VertexWeights.appendFloatArrayElement((StringBuilder)buf, (String)"jointweights", (float[])this.jointWeights, (char)' ', (XMLFormatting)fmt, (int)30);
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            int count;
            String tag = tokenizer.getTagName();
            if (tag.equals("jcount")) {
                count = this.getRequiredIntAttribute("count", tokenizer.getAttributes(), tokenizer);
                this.jcount = new int[count];
                tokenizer.takeSTag("jcount");
                VertexWeights.decodeIntArray((String)tokenizer.takeOptionalCharData(), (int[])this.jcount);
                tokenizer.takeETag("jcount");
                continue;
            }
            if (tag.equals("jointindices")) {
                count = this.getRequiredIntAttribute("count", tokenizer.getAttributes(), tokenizer);
                this.jointIndices = new int[count];
                tokenizer.takeSTag("jointindices");
                VertexWeights.decodeIntArray((String)tokenizer.takeOptionalCharData(), (int[])this.jointIndices);
                tokenizer.takeETag("jointindices");
                continue;
            }
            if (tag.equals("jointweights")) {
                count = this.getRequiredIntAttribute("count", tokenizer.getAttributes(), tokenizer);
                this.jointWeights = new float[count];
                tokenizer.takeSTag("jointweights");
                VertexWeights.decodeFloatArray((String)tokenizer.takeOptionalCharData(), (float[])this.jointWeights);
                tokenizer.takeETag("jointweights");
                continue;
            }
            logger.warn(tokenizer.getErrorMessage("VertexWeights: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

