/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.Console;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class Skeletons {
    private Skeletons() {
    }

    public static Map<String, String> getColladaRenaming(String renamingList, List<GNode> rootNodes) {
        StringTokenizer tok = new StringTokenizer(renamingList);
        int numTokens = tok.countTokens();
        if (numTokens % 2 != 0) {
            throw new IllegalArgumentException("Collada translator: joint renaming list with odd number of Strings");
        }
        int numPairs = numTokens / 2;
        Pattern[] patterns = new Pattern[numPairs];
        String[] replacements = new String[numPairs];
        for (int i = 0; i < numPairs; ++i) {
            patterns[i] = Pattern.compile(tok.nextToken());
            replacements[i] = tok.nextToken();
        }
        HashMap<String, String> renaming = new HashMap<String, String>();
        block1: for (int i = 0; i < patterns.length; ++i) {
            for (GNode rnode : rootNodes) {
                GNode nod = rnode.getPartByNamePattern(patterns[i]);
                if (nod == null) continue;
                String sid = nod.getSid();
                if (sid == null) {
                    sid = nod.getName();
                }
                if (sid == null) continue block1;
                renaming.put(sid, replacements[i]);
                continue block1;
            }
        }
        return renaming;
    }

    private static void alignSegment(VJoint skeletonRoot, String parentSid, String childSid, float[] vec) {
        VJoint parent = skeletonRoot.getPartBySid(parentSid);
        VJoint child = skeletonRoot.getPartBySid(childSid);
        if (parent != null && child != null) {
            float[] a = child.getRelativePositionFrom(parent);
            float[] q = Quat4f.getFromVectors((float[])a, (float[])vec);
            float[] r = Quat4f.getQuat4f();
            parent.getPathRotation(null, r);
            float[] rinv = Quat4f.getQuat4f();
            Quat4f.conjugate((float[])rinv, (float[])r);
            float[] s = Quat4f.getQuat4f();
            Quat4f.mul((float[])s, (float[])rinv, (float[])q);
            Quat4f.mul((float[])s, (float[])r);
            parent.rotate(s);
            Quat4f.transformVec3f((float[])q, (float[])a);
        } else {
            Console.println((String)("No " + parentSid + " or " + childSid + " for skeleton " + skeletonRoot.getName()));
        }
    }

    public static void setHAnimPose(VJoint skeletonRoot) {
        float[] downVec = Vec3f.getVec3f((float)0.0f, (float)-1.0f, (float)0.0f);
        Skeletons.alignSegment(skeletonRoot, "l_shoulder", "l_elbow", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_elbow", "l_wrist", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_index1", "l_index2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_index2", "l_index3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_index3", "l_index_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_middle1", "l_middle2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_middle2", "l_middle3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_middle3", "l_middle_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_ring1", "l_ring2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_ring2", "l_ring3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_ring3", "l_ring_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_pinky1", "l_pinky2", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_pinky2", "l_pinky3", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_pinky3", "l_pinky_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_shoulder", "r_elbow", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_elbow", "r_wrist", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_index1", "r_index2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_index2", "r_index3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_index3", "r_index_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_middle1", "r_middle2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_middle2", "r_middle3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_middle3", "r_middle_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_ring1", "r_ring2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_ring2", "r_ring3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_ring3", "r_ring_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_pinky1", "r_pinky2", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_pinky2", "r_pinky3", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_pinky3", "r_pinky_distal_tip", downVec);
        Skeletons.alignSegment(skeletonRoot, "l_hip", "l_knee", downVec);
        Skeletons.alignSegment(skeletonRoot, "r_hip", "r_knee", downVec);
        float[] qHipAnkle = Quat4f.getQuat4f();
        skeletonRoot.calculateMatrices();
        VJoint rAnkle = skeletonRoot.getPart("r_ankle");
        VJoint rHip = skeletonRoot.getPart("r_hip");
        rAnkle.getPathRotation(rHip.getParent(), qHipAnkle);
        Quat4f.inverse((float[])qHipAnkle);
        skeletonRoot.getPart("r_ankle").setRotation(qHipAnkle);
        VJoint lAnkle = skeletonRoot.getPart("l_ankle");
        VJoint lHip = skeletonRoot.getPart("l_hip");
        lAnkle.getPathRotation(lHip.getParent(), qHipAnkle);
        Quat4f.inverse((float[])qHipAnkle);
        skeletonRoot.getPart("l_ankle").setRotation(qHipAnkle);
    }

    private static void prepareBindPose(VJoint joint, float[] parentRotation) {
        float[] localRotation = Quat4f.getQuat4f();
        float[] combinedRotation = Quat4f.getQuat4f();
        float[] localTranslation = Vec3f.getVec3f();
        joint.getTranslation(localTranslation);
        Quat4f.transformVec3f((float[])parentRotation, (float[])localTranslation);
        joint.setTranslation(localTranslation);
        joint.getRotation(localRotation);
        Quat4f.mul((float[])combinedRotation, (float[])parentRotation, (float[])localRotation);
        List children = joint.getChildren();
        for (VJoint child : children) {
            Skeletons.prepareBindPose(child, combinedRotation);
        }
    }

    public static void setNeutralPoses(List<GNode> skeletonRoots, List<GSkinnedMesh> skinnedMeshList, List<GNode> roots) {
        for (GNode skeletonRoot : skeletonRoots) {
            VJoint root = skeletonRoot.getVJoint();
            Skeletons.prepareBindPose(root, Quat4f.getIdentity());
        }
        for (GNode root : roots) {
            root.getVJoint().calculateMatrices();
        }
        for (GSkinnedMesh gsm : skinnedMeshList) {
            gsm.setBindPose();
        }
        for (GNode skelRoot : skeletonRoots) {
            skelRoot.clearJointRotations();
        }
    }
}

