/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GMesh;
import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.VertexWeights;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.util.Console;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GSkinnedMesh
extends GMesh {
    private String[] skeletonIds;
    private String[] jointNames;
    private String[] jointSIDs;
    private int[] parentIndex;
    private VertexWeights vertexWeights;
    private float[][] inverseBindMatrices;
    private float[][] originalInverseBindMatrices;
    private GNode[] skeletonRoots;
    private GNode[] jointNodes;
    private float[][] jointMatrices;
    private float[][] jointPositions;
    private static final int JINFOTAB = 3;
    private static final int JINFOFIELDWIDTH = 6;
    private static final int JINFOPRECISION = 1;
    private static boolean showCalc = true;
    private static final int SHOWPOSFIELDWIDTH = 4;
    private static final int SHOWPOSPRECISION = 3;
    private static final int NUMJOINTSSHOWN = 20;
    private static final int FIELDWIDTH = 4;
    private static final int PRECISION = 2;
    private static final float EPSILON1 = 0.01f;
    private static final float EPSILON2 = 1.0E-4f;
    private static final int COLORCODINGSIZE = 10;
    private static final int COLORSIZE = 4;
    private static final int INDICESPERLINE = 30;
    private static final int STRINGSPERLINE = 10;
    private static final int FLOATSPERLINE = 16;
    private static final String XMLTAG = "gskinnedmesh";

    public GSkinnedMesh() {
    }

    public GSkinnedMesh(GMesh base) {
        super(base);
        this.setId("skinned-" + this.getId());
    }

    public GSkinnedMesh(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public void setSkeletonIds(String[] skeletonIds) {
        this.skeletonIds = skeletonIds;
    }

    public String[] getSkeletonIds() {
        return this.skeletonIds;
    }

    public void setJointSIDs(String[] jointSIDs) {
        this.jointSIDs = jointSIDs;
    }

    public String[] getJointSIDs() {
        return this.jointSIDs;
    }

    public void setJointNames(String[] names) {
        this.jointNames = names;
    }

    public String[] getJointNames() {
        return this.jointNames;
    }

    public void renameJointSIDs(Map<String, String> renaming) {
        for (int i = 0; i < this.jointSIDs.length; ++i) {
            String newName = renaming.get(this.jointSIDs[i]);
            if (newName == null) continue;
            this.jointSIDs[i] = newName;
        }
    }

    public GNode getJointGNode(String sid) {
        for (int i = 0; i < this.jointSIDs.length; ++i) {
            if (!this.jointSIDs[i].equals(sid)) continue;
            return this.jointNodes[i];
        }
        return null;
    }

    public VJoint getVJoint(String sid) {
        for (int i = 0; i < this.jointSIDs.length; ++i) {
            if (!this.jointSIDs[i].equals(sid)) continue;
            return this.jointNodes[i].getVJoint();
        }
        return null;
    }

    public void printJointNames() {
        if (this.jointSIDs == null) {
            for (int j = 0; j < this.jointSIDs.length; ++j) {
                Console.println((String)("Joint[" + j + "]=" + this.jointSIDs[j]));
            }
        } else {
            for (int j = 0; j < this.jointSIDs.length; ++j) {
                Console.println((String)("Joint[" + j + "]=" + this.jointSIDs[j] + "   (" + this.jointSIDs[j] + ")"));
            }
        }
    }

    public int[] getParentIndex() {
        return this.parentIndex;
    }

    public void setInvBindMatrices(float[][] matrices) {
        this.inverseBindMatrices = matrices;
        this.originalInverseBindMatrices = matrices;
    }

    public float[][] getInvBindMatrices() {
        return this.inverseBindMatrices;
    }

    public float[][] getOriginalInvBindMatrices() {
        return this.originalInverseBindMatrices;
    }

    public void printInvBindMatrices() {
        for (int m = 0; m < this.inverseBindMatrices.length; ++m) {
            Console.println((String)("InvBindMatrix[" + m + "]=" + Mat4f.toString((float[])this.inverseBindMatrices[m], (int)3, (int)6, (int)1)));
        }
    }

    public VJoint[] getVJoints() {
        VJoint[] vjoints = new VJoint[this.jointNodes.length];
        for (int i = 0; i < this.jointNodes.length; ++i) {
            vjoints[i] = this.jointNodes[i].getVJoint();
        }
        return vjoints;
    }

    public GNode[] getSkeletonRoots() {
        return this.skeletonRoots;
    }

    public void printJointInfo() {
        if (this.jointSIDs.length != this.inverseBindMatrices.length) {
            Console.println((String)("GSkinnedMesh.printJointInfo warning: jointSIDs.length=" + this.jointSIDs.length + "  inverseBindMatrices.length=" + this.inverseBindMatrices.length));
        }
        for (int j = 0; j < this.jointSIDs.length; ++j) {
            Console.println((String)("Joint[" + j + "]=" + this.jointSIDs[j]));
            if (j >= this.inverseBindMatrices.length) continue;
            Console.println((String)("InvBindMatrix[" + j + "]=" + Mat4f.toString((float[])this.inverseBindMatrices[j], (int)3, (int)6, (int)1)));
        }
    }

    public void setVertexWeights(VertexWeights vertexWeights) {
        this.vertexWeights = vertexWeights;
    }

    public VertexWeights getVertexWeights() {
        return this.vertexWeights;
    }

    @Override
    public void unifyIndices() {
        if (this.hasUnifiedIndexData()) {
            throw new IllegalStateException("GSkinnedMesh.unifyIndices cannot be called twice");
        }
        int[] map = this.calculateTuples();
        if (this.vertexWeights != null) {
            this.vertexWeights.remapData(this.getNrOfVertices(), map);
        }
    }

    public void resolveSkeletonIds(List<GNode> jointRoots) {
        if (this.skeletonIds == null) {
            Console.println((String)"GSkinnedMesh.resolveJoints: no skeleton Ids defined");
            return;
        }
        this.skeletonRoots = new GNode[this.skeletonIds.length];
        for (int i = 0; i < this.skeletonIds.length; ++i) {
            GNode root;
            String skeletonId = this.skeletonIds[i];
            GNode skeletonRoot = null;
            Iterator<GNode> i$ = jointRoots.iterator();
            while (i$.hasNext() && (skeletonRoot = (root = i$.next()).getPartById(skeletonId)) == null) {
            }
            if (skeletonRoot == null) {
                Console.println((String)("GSkinnedMesh.resolveJoints: Cannot find skeleton " + skeletonId));
                continue;
            }
            this.skeletonRoots[i] = skeletonRoot;
        }
    }

    public void resolveJoints(List<GNode> jointRoots) {
        int i;
        if (this.jointNodes == null) {
            this.jointNodes = new GNode[this.jointSIDs.length];
            this.jointNames = new String[this.jointSIDs.length];
            this.jointMatrices = new float[this.jointSIDs.length][];
            this.parentIndex = new int[this.jointSIDs.length];
            this.jointPositions = new float[this.jointSIDs.length][];
            for (i = 0; i < this.jointSIDs.length; ++i) {
                this.jointPositions[i] = Vec3f.getVec3f();
            }
        }
        this.resolveSkeletonIds(jointRoots);
        for (i = 0; i < this.skeletonRoots.length; ++i) {
            GNode skeletonRoot = this.skeletonRoots[i];
            block2: for (int n = 0; n < this.jointSIDs.length; ++n) {
                GNode jointNode = skeletonRoot.getPartBySid(this.jointSIDs[n]);
                if (jointNode == null) continue;
                if (this.jointNodes[n] != null) {
                    Console.println((String)("Warning - GSkinnedMesh: resolveJoints: double definition for joint " + this.jointSIDs[n]));
                }
                this.jointNodes[n] = jointNode;
                this.jointNames[n] = jointNode.getName();
                this.jointMatrices[n] = jointNode.getVJoint().getGlobalMatrix();
                String parentSid = jointNode.getParent().getSid();
                this.parentIndex[n] = -1;
                for (int p = 0; p < this.jointSIDs.length; ++p) {
                    if (!this.jointSIDs[p].equals(parentSid)) continue;
                    this.parentIndex[n] = p;
                    continue block2;
                }
            }
        }
        for (int n = 0; n < this.jointSIDs.length; ++n) {
            if (this.jointNodes[n] != null) continue;
            Console.println((String)("Warning - GSkinnedMesh:  could not find GNode for joint " + this.jointSIDs[n]));
        }
    }

    public void showPositions(int limit) {
        float[] zero = Vec3f.getZero();
        float[] bm = Mat4f.getMat4f();
        float[] jp = Vec3f.getVec3f();
        float[] bp = Vec3f.getVec3f();
        int max = limit < this.jointSIDs.length ? limit : this.jointSIDs.length;
        for (int i = 0; i < max; ++i) {
            Mat4f.invertAffine((float[])bm, (float[])this.inverseBindMatrices[i]);
            Mat4f.getTranslation((float[])bp, (float[])bm);
            Mat4f.transformPoint((float[])this.jointMatrices[i], (float[])jp, (float[])zero);
            Console.println((String)("joint[ " + i + "] " + this.jointNames[i] + "\nbind position=" + Vec3f.toString((float[])bp, (int)4, (int)3) + "\nskel position=" + Vec3f.toString((float[])jp, (int)4, (int)3)));
        }
    }

    public void writeBindMatrixRotations() {
        if (this.inverseBindMatrices == null) {
            throw new IllegalArgumentException("GSkinnedMesh.adjustBindMatrices: no inverse bind matrices defined");
        }
        String qFileName = "BindQuaternions.txt";
        try {
            PrintWriter qout = new PrintWriter(qFileName);
            qout.print("<SkeletonInterpolator rotationEncoding=\"quaternions\" parts=\"");
            for (int i = 0; i < this.jointSIDs.length; ++i) {
                qout.print(this.jointSIDs[i]);
                qout.print(" ");
            }
            qout.println("\" encoding=\"R\">");
            qout.print("0.0   ");
            float[] qbm = Quat4f.getQuat4f();
            for (int i = 0; i < this.jointSIDs.length; ++i) {
                float[] bm = this.inverseBindMatrices[i];
                Quat4f.setFromMat4f((float[])qbm, (float[])bm);
                qout.print(qbm[0]);
                qout.print(" ");
                qout.print(qbm[1]);
                qout.print(" ");
                qout.print(qbm[2]);
                qout.print(" ");
                qout.print(qbm[3]);
                qout.print("   ");
            }
            qout.println();
            qout.println("</SkeletonInterpolator>");
            qout.close();
        }
        catch (Exception e) {
            Console.println((String)("writeBindMatrixRotations: " + e));
        }
    }

    public void adjustBindPose() {
        if (this.inverseBindMatrices == null) {
            throw new IllegalArgumentException("GSkinnedMesh.adjustBindMatrices: no inverse bind matrices defined");
        }
        this.originalInverseBindMatrices = new float[this.inverseBindMatrices.length][16];
        for (int i = 0; i < this.inverseBindMatrices.length; ++i) {
            Mat4f.set((float[])this.originalInverseBindMatrices[i], (float[])this.inverseBindMatrices[i]);
        }
        float[] bm = Mat4f.getMat4f();
        float[] negCenter = Vec3f.getVec3f();
        float[] transVec = Vec3f.getVec3f();
        for (int i = 0; i < this.jointSIDs.length; ++i) {
            Mat4f.invertAffine((float[])bm, (float[])this.inverseBindMatrices[i]);
            Mat4f.getTranslation((float[])this.jointPositions[i], (float[])bm);
        }
        GNode skeletonParent = this.jointNodes[0].getParent();
        for (int i = 0; i < this.jointSIDs.length; ++i) {
            if (this.parentIndex[i] < 0) {
                if (skeletonParent == null) {
                    Vec3f.set((float[])transVec, (float[])this.jointPositions[i]);
                } else {
                    float[] parTranslation = new float[3];
                    skeletonParent.getTranslation(parTranslation);
                    Vec3f.sub((float[])transVec, (float[])this.jointPositions[i], (float[])parTranslation);
                }
            } else {
                Vec3f.sub((float[])transVec, (float[])this.jointPositions[i], (float[])this.jointPositions[this.parentIndex[i]]);
            }
            this.jointNodes[i].clearLocalLinearTransform();
            this.jointNodes[i].setTranslation(transVec);
            Vec3f.negate((float[])negCenter, (float[])this.jointPositions[i]);
            Mat4f.clearRotationScale((float[])this.inverseBindMatrices[i]);
            Mat4f.setTranslation((float[])this.inverseBindMatrices[i], (float[])negCenter);
        }
        if (skeletonParent != null) {
            skeletonParent.clearLocalLinearTransform();
        }
    }

    @Override
    public void linearTransform(float[] mat3x3) {
        float[] mat4x4 = Mat4f.from3x3((float[])mat3x3);
        this.affineTransform(mat4x4);
    }

    @Override
    public void affineTransform(float[] ma) {
        super.affineTransform(ma);
        if (this.jointSIDs != null) {
            for (int i = 0; i < this.jointSIDs.length; ++i) {
                Mat4f.transformAffineMatrix((float[])ma, (float[])this.inverseBindMatrices[i]);
            }
        }
    }

    public void setBindPose() {
        if (this.inverseBindMatrices == null) {
            this.inverseBindMatrices = new float[this.jointMatrices.length][16];
        }
        for (int i = 0; i < this.inverseBindMatrices.length; ++i) {
            float[] rotations = Mat4f.getMat4f();
            Mat4f.set((float[])rotations, (float[])this.jointNodes[i].getVJoint().getGlobalMatrix());
            float[] zeroVec = Vec3f.getZero();
            Mat4f.setTranslation((float[])rotations, (float[])zeroVec);
            Mat4f.mul((float[])this.inverseBindMatrices[i], (float[])rotations, (float[])this.inverseBindMatrices[i]);
        }
    }

    public void addVertexWeightColors(boolean useWeights, String[] names, float[][] colorCoding3) {
        int[] indices = this.getJointIndices(names);
        float[][] colorCoding = new float[this.jointSIDs.length][4];
        for (int i = 0; i < this.jointSIDs.length; ++i) {
            colorCoding[i] = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        }
        for (int k = 0; k < indices.length; ++k) {
            if (indices[k] < 0) {
                Console.println((String)("GSkinnedMesh.addVertexWeightColors joint name  " + names[k] + " not present in skeleton"));
                continue;
            }
            colorCoding[indices[k]][0] = colorCoding3[k][0];
            colorCoding[indices[k]][1] = colorCoding3[k][1];
            colorCoding[indices[k]][2] = colorCoding3[k][2];
            colorCoding[indices[k]][3] = 1.0f;
        }
        float[] colors = this.vertexWeights.getVertexWeightColors(useWeights, colorCoding);
        this.setVertexData(-1, "color", 4, colors);
    }

    public int[] getJointIndices(String[] names) {
        int[] indices = new int[names.length];
        block0: for (int i = 0; i < names.length; ++i) {
            String jn = names[i];
            indices[i] = -1;
            for (int j = 0; j < this.jointSIDs.length; ++j) {
                if (!this.jointSIDs[j].equals(jn)) continue;
                indices[i] = j;
                continue block0;
            }
        }
        return indices;
    }

    public float[][] getColorCoding() {
        float[][] colorCoding = new float[10][4];
        return colorCoding;
    }

    @Override
    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        super.appendAttributeString(buf, fmt);
        return buf;
    }

    @Override
    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        super.decodeAttributes(attrMap, tokenizer);
    }

    @Override
    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        GSkinnedMesh.appendStringArrayElement((StringBuilder)buf, (String)"skeletonids", (String[])this.skeletonIds, (char)' ', (XMLFormatting)fmt, (int)10);
        GSkinnedMesh.appendStringArrayElement((StringBuilder)buf, (String)"jointnames", (String[])this.jointNames, (char)' ', (XMLFormatting)fmt, (int)10);
        GSkinnedMesh.appendStringArrayElement((StringBuilder)buf, (String)"jointsids", (String[])this.jointSIDs, (char)' ', (XMLFormatting)fmt, (int)10);
        GSkinnedMesh.appendIntArrayElement((StringBuilder)buf, (String)"parentindices", (int[])this.parentIndex, (char)' ', (XMLFormatting)fmt, (int)30);
        if (this.vertexWeights != null) {
            buf.append('\n');
            this.vertexWeights.appendXML(buf, fmt);
        }
        if (this.inverseBindMatrices != null) {
            buf.append('\n');
            GSkinnedMesh.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt);
            GSkinnedMesh.appendOpenSTag((StringBuilder)buf, (String)"inversebindmatrices");
            GSkinnedMesh.appendAttribute((StringBuilder)buf, (String)"count", (int)this.inverseBindMatrices.length);
            GSkinnedMesh.appendCloseSTag((StringBuilder)buf);
            fmt.indent();
            for (int i = 0; i < this.inverseBindMatrices.length; ++i) {
                GSkinnedMesh.appendFloatArrayElement((StringBuilder)buf, (String)"matrix", (float[])this.inverseBindMatrices[i], (char)' ', (XMLFormatting)fmt, (int)16);
            }
            buf.append('\n');
            GSkinnedMesh.appendSpaces((StringBuilder)buf, (XMLFormatting)fmt.unIndent());
            GSkinnedMesh.appendETag((StringBuilder)buf, (String)"inversebindmatrices");
        }
        super.appendContent(buf, fmt);
        return buf;
    }

    @Override
    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("skeletonids")) {
                this.skeletonIds = GSkinnedMesh.decodeStringArrayElement((String)"skeletonids", (XMLTokenizer)tokenizer);
                continue;
            }
            if (tag.equals("jointnames")) {
                this.jointNames = GSkinnedMesh.decodeStringArrayElement((String)"jointnames", (XMLTokenizer)tokenizer);
                continue;
            }
            if (tag.equals("jointsids")) {
                this.jointSIDs = GSkinnedMesh.decodeStringArrayElement((String)"jointsids", (XMLTokenizer)tokenizer);
                continue;
            }
            if (tag.equals("parentindices")) {
                this.parentIndex = GSkinnedMesh.decodeIntArrayElement((String)"parentindices", (XMLTokenizer)tokenizer);
                continue;
            }
            if (tag.equals("vertexweights")) {
                this.vertexWeights = new VertexWeights(tokenizer);
                continue;
            }
            if (tag.equals("inversebindmatrices")) {
                int count = this.getRequiredIntAttribute("count", tokenizer.getAttributes(), tokenizer);
                this.inverseBindMatrices = new float[count][16];
                tokenizer.takeSTag("inversebindmatrices");
                for (int i = 0; i < count; ++i) {
                    tokenizer.takeSTag("matrix");
                    GSkinnedMesh.decodeFloatArray((String)tokenizer.takeOptionalCharData(), (float[])this.inverseBindMatrices[i]);
                    tokenizer.takeETag("matrix");
                }
                tokenizer.takeETag("inversebindmatrices");
                continue;
            }
            super.decodeContent(tokenizer);
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    @Override
    public String getXMLTag() {
        return XMLTAG;
    }
}

