/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.graphics.scenegraph.GNode;
import hmi.graphics.scenegraph.GSkinnedMesh;
import hmi.graphics.scenegraph.Skeletons;
import hmi.math.Mat4f;
import hmi.math.Quat4f;
import hmi.math.Vec3f;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GScene
extends XMLStructureAdapter {
    private List<GNode> rootNodes = new ArrayList<GNode>();
    private List<GSkinnedMesh> skinnedMeshList = new ArrayList<GSkinnedMesh>();
    private List<GNode> skeletonRoots = new ArrayList<GNode>();
    private String xmlVersion = "0.0";
    private static Logger logger = LoggerFactory.getLogger((String)"hmi.graphics.scenegraph");
    private static final boolean writeBindMatrices = false;
    private static final String XMLTAG = "gscene";

    public GScene() {
    }

    public GScene(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public static Logger getLogger() {
        return logger;
    }

    public void addOriginMarker() {
    }

    public void addRootNode(GNode root) {
        this.rootNodes.add(root);
    }

    public List<GNode> getRootNodes() {
        return this.rootNodes;
    }

    public List<GNode> getSkeletonRoots() {
        return this.skeletonRoots;
    }

    public void addSkinnedMeshes(List<GSkinnedMesh> skinnedMeshes) {
        this.skinnedMeshList.addAll(skinnedMeshes);
    }

    public List<GSkinnedMesh> getSkinnedMeshes() {
        return this.skinnedMeshList;
    }

    public void calculateVJointMatrices() {
        for (GNode root : this.rootNodes) {
            root.getVJoint().calculateMatrices();
        }
    }

    public void clearRotations() {
        for (GNode skelRoot : this.skeletonRoots) {
            skelRoot.clearRotations();
        }
    }

    public void rotateScaleSkinnedMeshes(float x, float y, float z, float angle, float scale) {
        float[] q = Quat4f.getQuat4f();
        Quat4f.setFromAxisAngle4f((float[])q, (float)x, (float)y, (float)z, (float)angle);
        float[] t = Vec3f.getZero();
        this.affineTransformMeshes(t, q, scale);
    }

    public void affineTransformMeshes(float[] t, float[] q, float s) {
        float[] mat4x4 = Mat4f.getMat4f();
        float[] zerovec = Vec3f.getZero();
        Mat4f.setFromTRS((float[])mat4x4, (float[])zerovec, (float[])q, (float)s);
        for (GSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.affineTransform(mat4x4);
        }
        for (GNode skelRoot : this.skeletonRoots) {
            skelRoot.affineTransform(mat4x4);
            skelRoot.affineTransformGShapes(mat4x4);
            skelRoot.getVJoint().translate(t);
        }
    }

    public void renameJoints(String renamingList) {
        if (renamingList != null) {
            Map<String, String> renaming = Skeletons.getColladaRenaming(renamingList, this.rootNodes);
            for (GNode rnode : this.skeletonRoots) {
                rnode.renameJoints(renaming);
            }
            for (GSkinnedMesh skm : this.skinnedMeshList) {
                skm.renameJointSIDs(renaming);
            }
        }
    }

    public void resolveSkinnedMeshJoints() {
        for (GSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.resolveJoints(this.rootNodes);
            GNode[] meshSkeletonRoots = gsm.getSkeletonRoots();
            for (int i = 0; i < meshSkeletonRoots.length; ++i) {
                GNode skelRoot = meshSkeletonRoots[i];
                if (this.skeletonRoots.contains((Object)skelRoot)) continue;
                this.skeletonRoots.add(skelRoot);
            }
        }
    }

    public void adjustBindPoses() {
        for (GSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.adjustBindPose();
        }
    }

    public void prepareSkinnedMeshes(String renamingList, float scale, boolean setToHAnim) {
        this.resolveSkinnedMeshJoints();
        this.renameJoints(renamingList);
        this.calculateVJointMatrices();
        this.adjustBindPoses();
        this.calculateVJointMatrices();
        this.rotateScaleSkinnedMeshes(1.0f, 0.0f, 0.0f, -1.5707964f, scale);
        if (setToHAnim) {
            this.setHAnimPoses();
            this.calculateVJointMatrices();
        }
        Skeletons.setNeutralPoses(this.skeletonRoots, this.skinnedMeshList, this.rootNodes);
    }

    public void setHAnimPoses() {
        for (GNode skeletonRoot : this.skeletonRoots) {
            Skeletons.setHAnimPose(skeletonRoot.getVJoint());
        }
    }

    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        GScene.appendAttribute((StringBuilder)buf, (String)"version", (String)this.xmlVersion);
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.xmlVersion = this.getOptionalAttribute("version", attrMap, "0.0");
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        GScene.appendSTag((StringBuilder)buf, (String)"rootnodes", (XMLFormatting)fmt);
        GScene.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.rootNodes);
        GScene.appendETag((StringBuilder)buf, (String)"rootnodes", (XMLFormatting)fmt);
        GScene.appendSTag((StringBuilder)buf, (String)"skeletonroots", (XMLFormatting)fmt);
        GScene.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.skeletonRoots);
        GScene.appendETag((StringBuilder)buf, (String)"skeletonroots", (XMLFormatting)fmt);
        GScene.appendSTag((StringBuilder)buf, (String)"skinnedmeshes", (XMLFormatting)fmt);
        GScene.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.skinnedMeshList);
        GScene.appendETag((StringBuilder)buf, (String)"skinnedmeshes", (XMLFormatting)fmt);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("rootnodes")) {
                tokenizer.takeSTag("rootnodes");
                this.rootNodes = GScene.decodeXMLStructureList((XMLTokenizer)tokenizer, (String)"gnode", GNode.class);
                tokenizer.takeETag("rootnodes");
                continue;
            }
            if (tag.equals("skeletonroots")) {
                tokenizer.takeSTag("skeletonroots");
                this.skeletonRoots = GScene.decodeXMLStructureList((XMLTokenizer)tokenizer, (String)"gnode", GNode.class);
                tokenizer.takeETag("skeletonroots");
                continue;
            }
            if (tag.equals("skinnedmeshes")) {
                tokenizer.takeSTag("skinnedmeshes");
                this.skinnedMeshList = GScene.decodeXMLStructureList((XMLTokenizer)tokenizer, (String)"gskinnedmesh", GSkinnedMesh.class);
                tokenizer.takeETag("skinnedmeshes");
                continue;
            }
            System.out.println(tokenizer.getErrorMessage("Scene: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }
}

