/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.scenegraph.GShape;
import hmi.math.Mat3f;
import hmi.math.Vec3f;
import hmi.util.Console;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GNode
extends XMLStructureAdapter {
    private String id;
    private String sid;
    private String name;
    private String type;
    private GNode parent;
    private List<GNode> gnodes;
    private List<GShape> gshapes;
    private VJoint joint = new VJoint();
    private static final List<GNode> EMPTYGNODELIST = new ArrayList<GNode>(0);
    private static final List<GShape> EMPTYGSHAPELIST = new ArrayList<GShape>(0);
    private float[] vec = Vec3f.getVec3f();
    private static final int LISTSIZE = 4;
    private static final String XMLTAG = "gnode";

    public GNode() {
    }

    public GNode(String id) {
        this();
        this.setId(id);
    }

    public GNode(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public void setId(String id) {
        this.id = id == null ? null : id.intern();
        this.joint.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setSid(String sid) {
        this.sid = sid == null ? null : sid.intern();
        this.joint.setSid(sid);
    }

    public String getSid() {
        return this.sid;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.intern();
        this.joint.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setType(String type) {
        this.type = type == null ? null : type.intern();
    }

    public String getType() {
        return this.type;
    }

    public List<GNode> selectGNodes() {
        return this.selectGNodes(null, null);
    }

    public List<GNode> selectGNodes(Predicate select) {
        return this.selectGNodes(select, null);
    }

    public List<GNode> selectGNodes(Predicate select, Predicate prune) {
        return this.selectGNodes(select, prune, new ArrayList<GNode>());
    }

    public List<GNode> selectGNodes(Predicate select, Predicate prune, ArrayList<GNode> list) {
        if (select == null || select.valid(this)) {
            list.add(this);
        }
        if (prune == null || !prune.valid(this)) {
            for (GNode gchild : this.gnodes) {
                gchild.selectGNodes(select, prune, list);
            }
        }
        return list;
    }

    public VJoint getVJoint() {
        return this.joint;
    }

    public void addGNode(GNode sn) {
        if (this.gnodes == null) {
            this.gnodes = new ArrayList<GNode>(4);
        }
        if (sn.parent != null) {
            sn.parent.removeGNode(sn);
        }
        this.gnodes.add(sn);
        sn.parent = this;
        this.joint.addChild(sn.getVJoint());
    }

    public void removeGNode(GNode sn) {
        if (this.gnodes == null) {
            return;
        }
        this.gnodes.remove((Object)sn);
    }

    public List<GNode> getGNodes() {
        if (this.gnodes == null) {
            return EMPTYGNODELIST;
        }
        return this.gnodes;
    }

    public GNode getParent() {
        return this.parent;
    }

    public void addGShape(GShape gshape) {
        if (this.gshapes == null) {
            this.gshapes = new ArrayList<GShape>(4);
        }
        this.gshapes.add(gshape);
    }

    public void addGShapes(List<GShape> gshapeList) {
        if (this.gshapes == null) {
            this.gshapes = new ArrayList<GShape>(4);
        }
        this.gshapes.addAll(gshapeList);
    }

    public List<GShape> getGShapes() {
        if (this.gshapes == null) {
            return EMPTYGSHAPELIST;
        }
        return this.gshapes;
    }

    public boolean hasGShapes() {
        if (this.getGShapes().size() > 0) {
            return true;
        }
        for (GNode childNode : this.getGNodes()) {
            if (!childNode.hasGShapes()) continue;
            return true;
        }
        return false;
    }

    public GNode getPartBySid(String sid) {
        if (this.sid != null && this.sid.equals(sid)) {
            return this;
        }
        for (GNode childNode : this.getGNodes()) {
            GNode gn = childNode.getPartBySid(sid);
            if (gn == null) continue;
            return gn;
        }
        return null;
    }

    public GNode getPartById(String id) {
        if (this.id != null && this.id.equals(id)) {
            return this;
        }
        for (GNode childNode : this.getGNodes()) {
            GNode gn = childNode.getPartById(id);
            if (gn == null) continue;
            return gn;
        }
        return null;
    }

    public GNode getPartByNamePattern(String namePattern) {
        return this.getPartByNamePattern(Pattern.compile(namePattern));
    }

    public GNode getPartByNamePattern(Pattern namePat) {
        if (this.name != null && namePat.matcher(this.name).matches()) {
            return this;
        }
        for (GNode childNode : this.getGNodes()) {
            GNode gn = childNode.getPartByNamePattern(namePat);
            if (gn == null) continue;
            return gn;
        }
        return null;
    }

    public void renameJoints(Map<String, String> renaming) {
        String newName = null;
        if (this.sid != null) {
            newName = renaming.get(this.sid);
        }
        if (newName == null && this.name != null) {
            newName = renaming.get(this.name);
        }
        if (newName == null && this.id != null) {
            newName = renaming.get(this.id);
        }
        if (newName == null && this.name != null) {
            newName = this.name;
        }
        if (newName == null && this.sid != null) {
            newName = this.sid;
        }
        if (newName == null && this.id != null) {
            newName = this.id;
        }
        if (newName != null) {
            this.setSid(newName);
            this.setName(newName);
        }
        for (GNode childNode : this.getGNodes()) {
            childNode.renameJoints(renaming);
        }
    }

    public void setTranslation(float[] translation) {
        this.joint.setTranslation(translation);
    }

    public void getTranslation(float[] result) {
        this.joint.getTranslation(result);
    }

    public void setRotation(float[] rotation) {
        this.joint.setRotation(rotation);
    }

    public void setScale(float[] scaleVec) {
        this.joint.setScale(scaleVec);
    }

    public void setSkewMatrix(float[] skewMatrix) {
        this.joint.setSkewMatrix(skewMatrix);
    }

    public void setLocalTransform(float[] m) {
        this.joint.setLocalTransform(m);
    }

    public float[] getLocalMatrix() {
        return this.joint.getLocalMatrix();
    }

    public float[] getGlobalMatrix() {
        return this.joint.getGlobalMatrix();
    }

    public void clearLocalLinearTransform() {
        this.joint.clearLocalLinearTransform();
    }

    public void clearRotations() {
        this.joint.clearRotation();
        for (GNode child : this.getGNodes()) {
            child.clearRotations();
        }
    }

    public void clearJointRotations() {
        if (this.type.equals("JOINT") || this.type.equals("Joint")) {
            this.joint.clearRotation();
        }
        for (GNode child : this.getGNodes()) {
            child.clearJointRotations();
        }
    }

    public void affineTransform(float[] mat4x4) {
        this.joint.affineTransform(mat4x4);
        for (GNode child : this.getGNodes()) {
            child.affineTransform(mat4x4);
        }
    }

    public void affineTransformGShapes(float[] mat4x4) {
        for (GShape gshape : this.getGShapes()) {
            gshape.affineTransform(mat4x4);
        }
        for (GNode child : this.getGNodes()) {
            child.affineTransformGShapes(mat4x4);
        }
    }

    public void removeLinearTransforms() {
        this.removeLinearTransforms(Mat3f.getIdentity());
    }

    public void removeLinearTransforms(float[] mat3x3) {
        float[] localLinear = Mat3f.from4x4((float[])this.joint.getLocalMatrix());
        float[] combinedTransform = Mat3f.getMat3f();
        Mat3f.mul((float[])combinedTransform, (float[])mat3x3, (float[])localLinear);
        for (GShape gs : this.getGShapes()) {
            gs.getGMesh().linearTransform(combinedTransform);
        }
        this.joint.getTranslation(this.vec);
        Mat3f.transform((float[])mat3x3, (float[])this.vec);
        this.joint.setTranslation(this.vec);
        this.joint.clearLocalLinearTransform();
        for (GNode child : this.getGNodes()) {
            child.removeLinearTransforms(combinedTransform);
        }
    }

    public String toString() {
        return this.toXMLString();
    }

    public StringBuilder appendAttributes(StringBuilder buf) {
        super.appendAttributes(buf);
        GNode.appendAttribute((StringBuilder)buf, (String)"id", (String)this.id);
        GNode.appendAttribute((StringBuilder)buf, (String)"sid", (String)this.sid);
        GNode.appendAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        GNode.appendAttribute((StringBuilder)buf, (String)"type", (String)this.type);
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        this.id = this.getOptionalAttribute("id", attrMap);
        if (this.id != null) {
            this.id = this.id.intern();
        }
        this.sid = this.getOptionalAttribute("sid", attrMap);
        if (this.sid != null) {
            this.sid = this.sid.intern();
        }
        this.name = this.getOptionalAttribute("name", attrMap);
        if (this.name != null) {
            this.name = this.name.intern();
        }
        this.type = this.getOptionalAttribute("type", attrMap);
        if (this.type != null) {
            this.type = this.type.intern();
        }
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        GNode.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.gnodes);
        GNode.appendXMLStructureList((StringBuilder)buf, (XMLFormatting)fmt, this.gshapes);
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals(GNode.xmlTag())) {
                this.addGNode(new GNode(tokenizer));
                continue;
            }
            if (tag.equals(GShape.xmlTag())) {
                this.addGShape(new GShape(tokenizer));
                continue;
            }
            Console.println((String)tokenizer.getErrorMessage("GNode: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public static interface Predicate {
        public boolean valid(GNode var1);
    }
}

