/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.scenegraph;

import hmi.graphics.scenegraph.GTexture;
import hmi.util.Console;
import hmi.xml.XMLFormatting;
import hmi.xml.XMLStructure;
import hmi.xml.XMLStructureAdapter;
import hmi.xml.XMLTokenizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;

public class GMaterial
extends XMLStructureAdapter {
    private String name = "";
    private String shader = "";
    private float[] emissionColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float[] ambientColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float[] diffuseColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float[] specularColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float shininess = 0.0f;
    private GTexture diffuseTexture;
    private GTexture transparentTexture;
    private String opaqueMode = "";
    private boolean transparencyEnabled = false;
    private float repeatS = 1.0f;
    private float repeatT = 1.0f;
    private float offsetS = 0.0f;
    private float offsetT = 0.0f;
    private boolean repeatSettingsTransferred = false;
    private static final int LIGHT_ATTRIBUTE_SIZE = 4;
    private static final String XMLTAG = "gmaterial";
    private static final int DIFFUSE_TEXTURE_BIT = 1;
    private static final int TRANSPARENT_TEXTURE_BIT = 2;

    public GMaterial() {
    }

    public GMaterial(String name) {
        this();
        this.name = name;
    }

    public GMaterial(XMLTokenizer tokenizer) throws IOException {
        this();
        this.readXML(tokenizer);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setShader(String shader) {
        this.shader = shader.intern();
    }

    public String getShader() {
        return this.shader;
    }

    public void setEmissionColor(float[] emissionColor) {
        this.emissionColor = emissionColor;
    }

    public float[] getEmissionColor() {
        return this.emissionColor;
    }

    public void setAmbientColor(float[] ambientColor) {
        this.ambientColor = ambientColor;
    }

    public float[] getAmbientColor() {
        return this.ambientColor;
    }

    public void setDiffuseColor(float[] diffuseColor) {
        this.diffuseColor = diffuseColor;
    }

    public float[] getDiffuseColor() {
        return this.diffuseColor;
    }

    public void setSpecularColor(float[] specularColor) {
        this.specularColor = specularColor;
    }

    public float[] getSpecularColor() {
        return this.specularColor;
    }

    public void setShininess(float shininess) {
        this.shininess = shininess;
    }

    public float getShininess() {
        return this.shininess;
    }

    public void setDiffuseTexture(GTexture texture) {
        this.diffuseTexture = texture;
    }

    public GTexture getDiffuseTexture() {
        return this.diffuseTexture;
    }

    public void setTransparencyEnabled(boolean mode) {
        this.transparencyEnabled = mode;
    }

    public boolean isTransparencyEnabled() {
        return this.transparencyEnabled;
    }

    public void setTransparentTexture(GTexture texture) {
        this.transparentTexture = texture;
    }

    public GTexture getTransparentTexture() {
        return this.transparentTexture;
    }

    public void setOpaqueMode(String opaqueMode) {
        this.opaqueMode = opaqueMode;
    }

    public String getOpaqueMode() {
        return this.opaqueMode;
    }

    public String transferRepeatSettings(GTexture gtex) {
        if (!this.repeatSettingsTransferred) {
            this.repeatS = gtex.getRepeatS();
            this.repeatT = gtex.getRepeatT();
            this.offsetS = gtex.getOffsetS();
            this.offsetT = gtex.getOffsetT();
            this.repeatSettingsTransferred = true;
            return null;
        }
        if (this.repeatS != gtex.getRepeatS() || this.repeatT != gtex.getRepeatT()) {
            return "Material " + this.name + " has textures with different repeat factors";
        }
        if (this.offsetS != gtex.getOffsetS() || this.offsetT != gtex.getOffsetT()) {
            return "Material " + this.name + " has textures with different offsets";
        }
        return null;
    }

    public float getRepeatS() {
        return this.repeatS;
    }

    public float getRepeatT() {
        return this.repeatT;
    }

    public float getOffsetS() {
        return this.offsetS;
    }

    public float getOffsetT() {
        return this.offsetT;
    }

    public StringBuilder appendAttributeString(StringBuilder buf, XMLFormatting fmt) {
        GMaterial.appendAttribute((StringBuilder)buf, (String)"name", (String)this.name);
        GMaterial.appendAttribute((StringBuilder)buf, (String)"shader", (String)this.shader);
        GMaterial.appendAttribute((StringBuilder)buf, (String)"emission", (float[])this.emissionColor, (char)' ', (XMLFormatting)fmt, (int)4);
        GMaterial.appendAttribute((StringBuilder)buf, (String)"ambient", (float[])this.ambientColor, (char)' ', (XMLFormatting)fmt, (int)4);
        GMaterial.appendAttribute((StringBuilder)buf, (String)"diffuse", (float[])this.diffuseColor, (char)' ', (XMLFormatting)fmt, (int)4);
        GMaterial.appendAttribute((StringBuilder)buf, (String)"specular", (float[])this.specularColor, (char)' ', (XMLFormatting)fmt, (int)4);
        if (this.shininess != 0.0f) {
            GMaterial.appendAttribute((StringBuilder)buf, (String)"shininess", (float)this.shininess);
        }
        if (!this.opaqueMode.equals("")) {
            GMaterial.appendAttribute((StringBuilder)buf, (String)"opaqueMode", (String)this.opaqueMode);
        }
        if (this.transparencyEnabled) {
            GMaterial.appendAttribute((StringBuilder)buf, (String)"transparencyEnabled", (boolean)this.transparencyEnabled);
        }
        return buf;
    }

    public void decodeAttributes(HashMap<String, String> attrMap, XMLTokenizer tokenizer) {
        String sh;
        String sp;
        String df;
        String am;
        this.name = this.getOptionalAttribute("name", attrMap, "").intern();
        this.shader = this.getOptionalAttribute("shader", attrMap, "").intern();
        String em = this.getOptionalAttribute("emission", attrMap);
        if (em != null) {
            this.emissionColor = GMaterial.decodeFloatArray((String)em, (float[])this.emissionColor);
        }
        if ((am = this.getOptionalAttribute("ambient", attrMap)) != null) {
            this.ambientColor = GMaterial.decodeFloatArray((String)am, (float[])this.ambientColor);
        }
        if ((df = this.getOptionalAttribute("diffuse", attrMap)) != null) {
            this.diffuseColor = GMaterial.decodeFloatArray((String)df, (float[])this.diffuseColor);
        }
        if ((sp = this.getOptionalAttribute("specular", attrMap)) != null) {
            this.specularColor = GMaterial.decodeFloatArray((String)sp, (float[])this.specularColor);
        }
        if ((sh = this.getOptionalAttribute("shininess", attrMap)) != null) {
            this.shininess = GMaterial.decodeFloat((String)sh);
        }
        this.opaqueMode = this.getOptionalAttribute("opaqueMode", attrMap, "").intern();
        this.transparencyEnabled = this.getOptionalBooleanAttribute("transparencyEnabled", attrMap, false);
        super.decodeAttributes(attrMap, tokenizer);
    }

    public StringBuilder appendContent(StringBuilder buf, XMLFormatting fmt) {
        if (this.diffuseTexture != null) {
            GMaterial.appendSTag((StringBuilder)buf, (String)"diffuse", (XMLFormatting)fmt);
            this.appendXMLStructure(buf, fmt.indent(), (XMLStructure)this.diffuseTexture);
            GMaterial.appendETag((StringBuilder)buf, (String)"diffuse", (XMLFormatting)fmt.unIndent());
        }
        if (this.transparentTexture != null) {
            GMaterial.appendSTag((StringBuilder)buf, (String)"transparent", (XMLFormatting)fmt);
            this.appendXMLStructure(buf, fmt, (XMLStructure)this.transparentTexture);
            GMaterial.appendETag((StringBuilder)buf, (String)"transparent", (XMLFormatting)fmt);
        }
        return buf;
    }

    public void decodeContent(XMLTokenizer tokenizer) throws IOException {
        while (tokenizer.atSTag()) {
            String tag = tokenizer.getTagName();
            if (tag.equals("diffuse")) {
                tokenizer.takeSTag("diffuse");
                this.diffuseTexture = new GTexture(tokenizer);
                this.transferRepeatSettings(this.diffuseTexture);
                tokenizer.takeETag("diffuse");
                continue;
            }
            if (tag.equals("transparent")) {
                tokenizer.takeSTag("transparent");
                this.transparentTexture = new GTexture(tokenizer);
                this.transferRepeatSettings(this.transparentTexture);
                tokenizer.takeETag("transparent");
                continue;
            }
            Console.println((String)tokenizer.getErrorMessage("GMaterial: skip : " + tokenizer.getTagName()));
            tokenizer.skipTag();
        }
    }

    public boolean hasContent() {
        return this.diffuseTexture != null || this.transparentTexture != null;
    }

    public static String xmlTag() {
        return XMLTAG;
    }

    public String getXMLTag() {
        return XMLTAG;
    }

    public void writeBinary(DataOutput dataOut) throws IOException {
        int i;
        dataOut.writeUTF(this.name);
        dataOut.writeUTF(this.shader);
        for (i = 0; i < 4; ++i) {
            dataOut.writeFloat(this.emissionColor[i]);
        }
        for (i = 0; i < 4; ++i) {
            dataOut.writeFloat(this.ambientColor[i]);
        }
        for (i = 0; i < 4; ++i) {
            dataOut.writeFloat(this.diffuseColor[i]);
        }
        for (i = 0; i < 4; ++i) {
            dataOut.writeFloat(this.specularColor[i]);
        }
        dataOut.writeFloat(this.shininess);
        dataOut.writeUTF(this.opaqueMode);
        dataOut.writeBoolean(this.transparencyEnabled);
        int texBits = 0;
        if (this.diffuseTexture != null) {
            texBits |= 1;
        }
        if (this.transparentTexture != null) {
            texBits |= 2;
        }
        dataOut.writeInt(texBits);
        if ((texBits & 1) != 0) {
            this.diffuseTexture.writeBinary(dataOut);
        }
        if ((texBits & 2) != 0) {
            this.transparentTexture.writeBinary(dataOut);
        }
    }

    public void readBinary(DataInput dataIn) throws IOException {
        int i;
        this.name = dataIn.readUTF().intern();
        this.shader = dataIn.readUTF().intern();
        for (i = 0; i < 4; ++i) {
            this.emissionColor[i] = dataIn.readFloat();
        }
        for (i = 0; i < 4; ++i) {
            this.ambientColor[i] = dataIn.readFloat();
        }
        for (i = 0; i < 4; ++i) {
            this.diffuseColor[i] = dataIn.readFloat();
        }
        for (i = 0; i < 4; ++i) {
            this.specularColor[i] = dataIn.readFloat();
        }
        this.shininess = dataIn.readFloat();
        this.opaqueMode = dataIn.readUTF().intern();
        this.transparencyEnabled = dataIn.readBoolean();
        int texBits = dataIn.readInt();
        if ((texBits & 1) != 0) {
            this.diffuseTexture = new GTexture();
            this.diffuseTexture.readBinary(dataIn);
        }
        if ((texBits & 2) != 0) {
            this.transparentTexture = new GTexture();
            this.transparentTexture.readBinary(dataIn);
        }
    }
}

