/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;

public final class GLTextureStateComponent
implements GLStateComponent {
    private int glId;
    private int scId;
    private int target;
    private int glEnumi;

    public GLTextureStateComponent(int target, int glId, int glEnumi) {
        this.glId = glId;
        this.scId = GLState.getSCId(glId);
        this.checkLegal(this.scId);
        this.target = target;
        this.glEnumi = glEnumi;
    }

    private void checkLegal(int scId) {
        if (33 <= scId && scId < 49) {
            return;
        }
        throw new IllegalArgumentException("GLTextureStateComponent: unknown scId: " + scId);
    }

    @Override
    public int getSCId() {
        return this.scId;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.glRender(gl);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        gl.glTexParameteri(this.target, this.glId, this.glEnumi);
    }

    public String toString() {
        return "<" + GLState.getGLName(this.glId) + " (" + GLState.getGLName(this.target) + ") = " + this.glEnumi + ">";
    }
}

