/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.state.GLStateComponent;

public class GLStateComponentList
implements GLRenderObject {
    private int arraySize = 0;
    private GLStateComponent[] stateComp;
    private int[] compId;
    private int size = 0;
    private static final int DEFAULTSIZE = 4;

    private void ensureArraySize(int requestedSize) {
        if (requestedSize <= this.arraySize) {
            return;
        }
        if (this.arraySize == 0) {
            this.arraySize = 4;
        }
        while (this.arraySize < requestedSize) {
            this.arraySize *= 2;
        }
        GLStateComponent[] newStateComp = new GLStateComponent[this.size];
        int[] newCompId = new int[this.arraySize];
        if (this.stateComp != null) {
            System.arraycopy(this.stateComp, 0, newStateComp, 0, this.size);
            System.arraycopy(this.compId, 0, newCompId, 0, this.size);
        }
        this.stateComp = newStateComp;
        this.compId = newCompId;
    }

    public void addStateComponent(GLStateComponent sc) {
        this.ensureArraySize(this.size + 1);
        int scId = sc.getSCId();
        int index = this.findIndex(scId);
        for (int i = this.size - 1; i >= index; --i) {
            this.stateComp[i + 1] = this.stateComp[i];
            this.compId[i + 1] = this.compId[i];
        }
        this.compId[index] = scId;
        this.stateComp[index] = sc;
        ++this.size;
    }

    public GLStateComponent getStateComponent(int scId) {
        int index = this.findIndex(scId);
        return this.compId[index] == scId ? this.stateComp[index] : null;
    }

    public final int findIndex(int scId) {
        if (this.size == 0 || scId <= this.compId[0]) {
            return 0;
        }
        if (scId > this.compId[this.size - 1]) {
            return this.size;
        }
        int low = 0;
        int high = this.size - 1;
        while (high - low > 1) {
            int mid = (low + high) / 2;
            if (this.compId[mid] == scId) {
                return mid;
            }
            if (this.compId[mid] < scId) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return high;
    }

    public StringBuilder appendContent(StringBuilder buf, int tab) {
        for (int i = 0; i < this.size; ++i) {
            buf.append(this.compId[i]);
            buf.append(" (stateComp) ");
        }
        return buf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("GLStateComponentList[");
        this.appendContent(buf, 0);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void glInit(GLRenderContext glc) {
        for (int i = 0; i < this.size; ++i) {
            this.stateComp[i].glInit(glc);
        }
    }

    @Override
    public void glRender(GLRenderContext glc) {
        for (int i = 0; i < this.size; ++i) {
            this.stateComp[i].glRender(glc);
        }
    }
}

