/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;
import hmi.graphics.util.BufferUtil;
import java.nio.FloatBuffer;

public final class GLStateComponentIF4
implements GLStateComponent {
    private int glId;
    private int scId;
    private int glEnumi;
    private FloatBuffer glBufferfv;

    public GLStateComponentIF4(int glEnumi, int glId, float[] glValfv) {
        this.glId = glId;
        this.scId = GLState.getSCId(glId);
        this.checkLegal(this.scId);
        this.glEnumi = glEnumi;
        this.glBufferfv = BufferUtil.directFloatBuffer(4);
        this.glBufferfv.put(glValfv);
        this.glBufferfv.rewind();
    }

    private void checkLegal(int scId) {
        if (1 <= scId && scId < 24) {
            return;
        }
        if (24 <= scId && scId < 33) {
            return;
        }
        if (33 <= scId && scId < 49) {
            return;
        }
        String glName = GLState.getGLName(this.glId);
        throw new IllegalArgumentException("GLStateComponentIF4: unknown glId: " + scId + " (" + glName + ")");
    }

    @Override
    public int getSCId() {
        return this.scId;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.glRender(gl);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        this.glBufferfv.rewind();
        if (this.scId < 24) {
            gl.glLightfv(this.glEnumi, this.glId, this.glBufferfv);
        } else if (this.scId < 33) {
            gl.glMaterialfv(this.glEnumi, this.glId, this.glBufferfv);
        } else {
            gl.glTexParameterfv(this.glEnumi, this.glId, this.glBufferfv);
        }
    }

    private String fbts(FloatBuffer buf) {
        if (buf == null) {
            return "null";
        }
        return "[" + buf.get(0) + ", " + buf.get(1) + ", " + buf.get(2) + ", " + buf.get(3) + "]";
    }

    public String toString() {
        return "<" + GLState.getGLName(this.glId) + " (" + GLState.getGLName(this.glEnumi) + ") = " + this.fbts(this.glBufferfv) + ">";
    }
}

