/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;

public class GLStateComponentIF
implements GLStateComponent {
    private int glId;
    private int scId;
    private int glEnumi;
    private float glVal;

    public GLStateComponentIF(int glEnumi, int glId, float glVal) {
        this.glId = glId;
        this.scId = GLState.getSCId(glId);
        this.checkLegal(this.scId);
        this.glEnumi = glEnumi;
        this.glVal = glVal;
    }

    private void checkLegal(int scId) {
        if (1 <= scId && scId < 24) {
            return;
        }
        if (24 <= scId && scId < 33) {
            return;
        }
        if (33 <= scId && scId < 49) {
            return;
        }
        throw new IllegalArgumentException("GLStateComponentIF: unknown scId: " + scId);
    }

    @Override
    public final int getSCId() {
        return this.scId;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.glRender(gl);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (this.scId < 24) {
            gl.glLightf(this.glEnumi, this.glId, this.glVal);
        } else if (this.scId < 33) {
            gl.glMaterialf(this.glEnumi, this.glId, this.glVal);
        } else {
            gl.glTexParameterf(this.glEnumi, this.glId, this.glVal);
        }
    }

    public String toString() {
        return "<" + GLState.getGLName(this.glId) + " (" + GLState.getGLName(this.glEnumi) + ") = " + this.glVal + ">";
    }
}

