/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;

public final class GLStateComponentI
implements GLStateComponent {
    private int glId;
    private int scId;
    private int glEnumi;

    public GLStateComponentI(int glId, int glEnumi) {
        this.glId = glId;
        this.scId = GLState.getSCId(glId);
        this.glEnumi = glEnumi;
        this.checkLegal(glId);
    }

    private void checkLegal(int glId) {
        if (glId == 34016 || glId == 2885 || glId == 2886 || glId == 33272) {
            return;
        }
        throw new IllegalArgumentException("GLStateComponentI: unknown glId: " + glId);
    }

    @Override
    public int getSCId() {
        return this.scId;
    }

    @Override
    public void glInit(GLRenderContext glc) {
        this.glRender(glc);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (this.glId == 34016) {
            gl.glActiveTexture(this.glEnumi);
        } else if (this.glId == 2885) {
            gl.glCullFace(this.glEnumi);
        } else if (this.glId == 2886) {
            gl.glFrontFace(this.glEnumi);
        } else if (this.glId == 33272) {
            gl.glLightModeli(33272, this.glEnumi);
        }
    }

    public String toString() {
        return "<" + GLState.getGLName(this.glId) + " = " + this.glEnumi + ">";
    }
}

