/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;
import hmi.graphics.util.BufferUtil;
import java.nio.FloatBuffer;

public final class GLStateComponentF4
implements GLStateComponent {
    private int glId;
    private int scId;
    private FloatBuffer glBufferfv;
    private float r;
    private float g;
    private float b;
    private float a;

    public GLStateComponentF4(int glId, float[] glValfv) {
        this.glId = glId;
        this.scId = GLState.getSCId(glId);
        if (glId == 2899) {
            this.glBufferfv = BufferUtil.directFloatBuffer(4);
            this.glBufferfv.put(glValfv);
            this.glBufferfv.rewind();
        } else if (glId == 3106 || glId == 2944) {
            this.r = glValfv[0];
            this.g = glValfv[1];
            this.b = glValfv[2];
            this.a = glValfv[3];
        } else {
            throw new IllegalArgumentException("GLStateComponentF4: unknown glId: " + glId);
        }
    }

    @Override
    public int getSCId() {
        return this.scId;
    }

    @Override
    public void glInit(GLRenderContext glc) {
        this.glRender(glc);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        this.glBufferfv.rewind();
        if (this.glId == 2899) {
            gl.glLightModelfv(2899, this.glBufferfv);
        } else if (this.glId == 3106) {
            gl.glClearColor(this.r, this.g, this.b, this.a);
        } else {
            gl.glClearAccum(this.r, this.g, this.b, this.a);
        }
    }
}

