/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.GLTexture;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;
import hmi.graphics.util.BufferUtil;
import java.nio.FloatBuffer;

public class GLMaterial
implements GLStateComponent {
    private static int scid = -1;
    private FloatBuffer emission;
    private FloatBuffer ambient;
    private FloatBuffer diffuse;
    private FloatBuffer specular;
    private float shininess;
    private GLTexture diffuseTexture;
    private GLTexture transparentTexture;
    private int diffuseTextureUnit;
    private int transparentTextureUnit;
    private float repeatS = 1.0f;
    private float repeatT = 1.0f;
    private float offsetS = 0.0f;
    private float offsetT = 0.0f;
    private boolean alphaBlendingEnabled = false;
    private int srcFactor;
    private int destFactor;
    private GLShader shader;
    private static final int VEC4_SIZE = 4;
    float dr;
    float dg;
    float db;
    float da;

    public GLMaterial() {
        if (scid <= 0) {
            scid = GLState.createSCId();
        }
        this.init();
    }

    private void init() {
        float[] black = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        this.emission = BufferUtil.directFloatBuffer(4);
        this.emission.put(black);
        this.emission.rewind();
        this.ambient = BufferUtil.directFloatBuffer(4);
        this.ambient.put(black);
        this.ambient.rewind();
        this.diffuse = BufferUtil.directFloatBuffer(4);
        this.diffuse.put(black);
        this.diffuse.rewind();
        this.specular = BufferUtil.directFloatBuffer(4);
        this.specular.put(black);
        this.specular.rewind();
        this.shininess = 1.0f;
    }

    public void setGLShader(GLShader shader) {
        this.shader = shader;
    }

    public boolean getAlphaBlendingEnabled() {
        return this.alphaBlendingEnabled;
    }

    public void setAlphaBlendingEnabled(boolean mode) {
        this.alphaBlendingEnabled = mode;
    }

    public void setBlendSrcFactor(int srcFactor) {
        this.srcFactor = srcFactor;
    }

    public void setBlendDestFactor(int destFactor) {
        this.destFactor = destFactor;
    }

    public void setEmissionColor(float[] emission) {
        if (emission != null) {
            this.emission.clear();
            this.emission.put(emission);
            this.emission.rewind();
        }
    }

    public void setAmbientColor(float[] ambient) {
        if (ambient != null) {
            this.ambient.clear();
            this.ambient.put(ambient);
            this.ambient.rewind();
        }
    }

    public void setDiffuseColor(float[] diffuse) {
        if (diffuse != null) {
            this.dr = diffuse[0];
            this.dg = diffuse[1];
            this.db = diffuse[2];
            this.da = diffuse[3];
        }
    }

    public void setSpecularColor(float[] specular) {
        if (specular != null) {
            this.specular.clear();
            this.specular.put(specular);
            this.specular.rewind();
        }
    }

    public void setShininess(float shininess) {
        this.shininess = shininess;
    }

    public void setDiffuseTexture(GLTexture glTex, int texUnit) {
        this.diffuseTexture = glTex;
        this.diffuseTextureUnit = texUnit;
    }

    public void setTransparantTexture(GLTexture glTex, int texUnit) {
        this.transparentTexture = glTex;
        this.transparentTextureUnit = texUnit;
    }

    public void setRepeatS(float r) {
        this.repeatS = r;
    }

    public float getRepeatS() {
        return this.repeatS;
    }

    public void setRepeatT(float r) {
        this.repeatT = r;
    }

    public float getRepeatT() {
        return this.repeatT;
    }

    public void setOffsetS(float r) {
        this.offsetS = r;
    }

    public float getOffsetS() {
        return this.offsetS;
    }

    public void setOffsetT(float r) {
        this.offsetT = r;
    }

    public float getOffsetT() {
        return this.offsetT;
    }

    @Override
    public final int getSCId() {
        return scid;
    }

    public final boolean eq(GLMaterial glm) {
        return false;
    }

    @Override
    public final void glInit(GLRenderContext gl) {
        if (this.shader != null) {
            this.shader.setValue("diffuseColor", Float.valueOf(this.dr), Float.valueOf(this.dg), Float.valueOf(this.db), Float.valueOf(this.da));
        }
        if (this.diffuseTexture != null) {
            this.diffuseTexture.glInit(gl);
            this.shader.setValue("TextureSampler", this.diffuseTextureUnit);
            this.shader.setValue("repeatS", Float.valueOf(this.repeatS));
            this.shader.setValue("repeatT", Float.valueOf(this.repeatT));
            this.shader.setValue("offsetS", Float.valueOf(this.offsetS));
            this.shader.setValue("offsetT", Float.valueOf(this.offsetT));
        }
        if (this.transparentTexture != null) {
            this.transparentTexture.glInit(gl);
            this.shader.setValue("TransparentSampler", this.transparentTextureUnit);
        }
        if (this.shader != null) {
            this.shader.glInit(gl);
        }
    }

    @Override
    public final void glRender(GLRenderContext gl) {
        if (this.alphaBlendingEnabled) {
            gl.glEnable(3042);
            gl.glBlendFunc(this.srcFactor, this.destFactor);
            gl.glDepthMask(false);
        } else {
            gl.glDisable(3042);
            gl.glDepthMask(true);
        }
        if (this.diffuseTexture != null) {
            this.diffuseTexture.glRender(gl);
        }
        if (this.transparentTexture != null) {
            this.transparentTexture.glRender(gl);
        }
        gl.glMaterialfv(1028, 5632, this.emission);
        gl.glMaterialfv(1028, 4608, this.ambient);
        gl.glMaterialfv(1028, 4609, this.diffuse);
        gl.glMaterialfv(1028, 4610, this.specular);
        gl.glMaterialf(1028, 5633, this.shininess);
        if (this.shader != null) {
            this.shader.glRender(gl);
        } else {
            gl.glUseProgram(0);
        }
    }

    private String fbts(FloatBuffer buf) {
        if (buf == null) {
            return "null";
        }
        return "[" + buf.get(0) + ", " + buf.get(1) + ", " + buf.get(2) + ", " + buf.get(3) + "]";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("GLMaterial[");
        buf.append("\n  shader=" + this.shader);
        buf.append("\n  emission=" + this.fbts(this.emission));
        buf.append("\n  ambient=" + this.fbts(this.ambient));
        buf.append("\n  diffuse=" + this.fbts(this.diffuse));
        buf.append("\n  specular=" + this.fbts(this.specular));
        buf.append("\n  shininess=" + this.shininess);
        if (this.diffuseTexture != null) {
            buf.append("\n  diffuseTexture=" + this.diffuseTexture);
        }
        if (this.transparentTexture != null) {
            buf.append("\n  transparentTexture=" + this.transparentTexture);
        }
        buf.append("\n]");
        return buf.toString();
    }
}

