/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.state;

import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.state.GLState;
import hmi.graphics.opengl.state.GLStateComponent;

public class GLCapability
implements GLStateComponent {
    private boolean enabled;
    private int glId;
    private int scId;

    public GLCapability(int glId, boolean enabled) {
        this.glId = glId;
        this.enabled = enabled;
        this.scId = GLState.getSCId(glId);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GLCapability) {
            GLCapability glcap = (GLCapability)obj;
            return glcap.scId == this.scId && glcap.enabled == this.enabled;
        }
        return false;
    }

    public int hashCode() {
        return this.scId;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.glRender(gl);
    }

    @Override
    public final void glRender(GLRenderContext gl) {
        if (this.enabled) {
            gl.glEnable(this.glId);
        } else {
            gl.glDisable(this.glId);
        }
    }

    @Override
    public final int getSCId() {
        return this.scId;
    }

    public String toString() {
        return "<" + GLState.getGLName(this.glId) + " = " + this.enabled + ">";
    }
}

