/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.scenegraph.GLNodeMarker;

public class VGLNode
implements GLRenderObject {
    private VJoint root;
    private GLRenderList shapeList;
    private GLRenderObject marker;

    public VGLNode(String name) {
        this(name, 1);
    }

    public VGLNode(String name, int capacity) {
        this.root = new VJoint(name);
        this.shapeList = new GLRenderList(capacity);
    }

    public VGLNode(VJoint root, GLRenderList shapeList) {
        this.root = root;
        this.shapeList = shapeList;
    }

    public GLRenderList getGLShapeList() {
        return this.shapeList;
    }

    public VJoint getRoot() {
        return this.root;
    }

    public void prependGLShape(GLShape glShape) {
        this.shapeList.prepend(glShape);
    }

    public void addGLShape(GLShape glShape) {
        this.shapeList.add(glShape);
        glShape.linkToTransformMatrix(this.root.getGlobalMatrix());
    }

    public void addChild(VGLNode childNode) {
        this.root.addChild(childNode.root);
        this.shapeList.addAll(childNode.shapeList);
    }

    public void addMarker(GLRenderObject marker) {
        this.marker = marker;
    }

    public void addMarker() {
        this.marker = new GLNodeMarker(0, "");
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.shapeList.glInit(gl);
        if (this.marker != null) {
            this.marker.glInit(gl);
        }
    }

    @Override
    public void glRender(GLRenderContext gl) {
        this.shapeList.glRender(gl);
        if (this.marker != null) {
            this.marker.glRender(gl);
        }
    }

    public String toString() {
        return "VGLNode(" + this.root.toString() + "\n" + this.shapeList.toString() + ")";
    }
}

