/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.graphics.opengl.GLShader;
import hmi.graphics.opengl.GLTexture;
import hmi.graphics.opengl.GLTextureLoader;
import hmi.graphics.opengl.state.GLMaterial;
import hmi.graphics.scenegraph.GMaterial;
import hmi.graphics.scenegraph.GTexture;
import hmi.util.Console;

public final class GMaterialTranslator {
    private GMaterialTranslator() {
    }

    public static GLMaterial fromGMaterialToGLMaterial(GMaterial gmaterial) {
        String shader;
        GLMaterial glmaterial = new GLMaterial();
        glmaterial.setEmissionColor(gmaterial.getEmissionColor());
        glmaterial.setAmbientColor(gmaterial.getAmbientColor());
        glmaterial.setDiffuseColor(gmaterial.getDiffuseColor());
        glmaterial.setSpecularColor(gmaterial.getSpecularColor());
        glmaterial.setShininess(gmaterial.getShininess());
        GTexture gDiffuseTex = gmaterial.getDiffuseTexture();
        if (gDiffuseTex != null) {
            int texUnit = 0;
            GLTexture glDiffuseTex = GMaterialTranslator.fromGTextureToGLTexture(gDiffuseTex, texUnit);
            glmaterial.setDiffuseTexture(glDiffuseTex, texUnit);
        }
        glmaterial.setRepeatS(gmaterial.getRepeatS());
        glmaterial.setRepeatT(gmaterial.getRepeatT());
        glmaterial.setOffsetS(gmaterial.getOffsetS());
        glmaterial.setOffsetT(gmaterial.getOffsetT());
        if (gmaterial.isTransparencyEnabled()) {
            glmaterial.setAlphaBlendingEnabled(true);
            glmaterial.setBlendSrcFactor(770);
            glmaterial.setBlendDestFactor(771);
            GTexture gTransparantTex = gmaterial.getTransparentTexture();
            if (gTransparantTex != null) {
                int texUnit = gDiffuseTex == null ? 0 : 1;
                GLTexture glTransparantTex = GMaterialTranslator.fromGTextureToGLTexture(gTransparantTex, texUnit);
                glmaterial.setTransparantTexture(glTransparantTex, texUnit);
            }
        }
        if ((shader = gmaterial.getShader()) != null) {
            GLShader glShader = new GLShader(shader, new String[0]);
            glmaterial.setGLShader(glShader);
        }
        return glmaterial;
    }

    public static GLTexture fromGTextureToGLTexture(GTexture gtex, int texUnit) {
        boolean rescale;
        boolean flip;
        String imageName = gtex.getImageFileName();
        String texName = imageName;
        GLTexture texture = GLTextureLoader.getGLTexture(texUnit, texName, flip = true, rescale = true);
        if (texture == null) {
            Console.println((String)("GTextureToGLTexture: Could not load texture " + texName));
        } else {
            texture.setImageFileName(imageName);
        }
        return texture;
    }
}

