/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.scenegraph;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderList;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.GLSkinnedMesh;
import hmi.util.Console;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GLScene
implements GLRenderObject {
    private ArrayList<VJoint> vjointRoots = new ArrayList();
    private ArrayList<GLSkinnedMesh> skinnedMeshList = new ArrayList();
    private GLRenderList shapeList = new GLRenderList();
    private static final float RADIUS = 0.005f;
    private static final int GRID = 16;
    private HashMap<String, Float> desiredMorphTargets = new HashMap();

    public void addVJointRoot(VJoint root) {
        this.vjointRoots.add(root);
    }

    public List<VJoint> getVJointRoots() {
        return this.vjointRoots;
    }

    public VJoint getVJoint(String partId) {
        for (VJoint vjrt : this.vjointRoots) {
            VJoint result = vjrt.getPart(partId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public GLRenderList getGLShapeList() {
        return this.shapeList;
    }

    public void prependGLShape(GLShape glShape) {
        this.shapeList.prepend(glShape);
    }

    public void addGLShapes(GLRenderList glShapes) {
        this.shapeList.addAll(glShapes);
    }

    public void addGLShape(GLShape glShape) {
        this.shapeList.add(glShape);
    }

    public void addSkinnedMeshes(List<GLSkinnedMesh> skinnedMeshes) {
        this.skinnedMeshList.addAll(skinnedMeshes);
    }

    public void addSkinnedMeshJointMarkers() {
        this.addSkinnedMeshJointMarkers(0.005f, 16);
    }

    public void addSkinnedMeshJointMarkers(float radius, int grid) {
        if (this.skinnedMeshList.size() > 0) {
            this.skinnedMeshList.get(0).addJointMarkers(radius, grid);
        }
    }

    @Override
    public void glInit(GLRenderContext glc) {
        this.shapeList.glInit(glc);
    }

    public void deform() {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.deform();
        }
    }

    public GLSkinnedMesh getGLSkinnedMesh() {
        if (this.skinnedMeshList == null || this.skinnedMeshList.size() == 0) {
            return null;
        }
        return this.skinnedMeshList.get(0);
    }

    public void morph(String targetName, float weight) {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.morph(targetName, weight);
        }
    }

    public void morph(String[] targetNames, float[] weights) {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.morph(targetNames, weights);
        }
    }

    public void morph(int[] targets, float[] weights) {
        for (GLSkinnedMesh gsm : this.skinnedMeshList) {
            gsm.morph(targets, weights);
        }
    }

    public void doMorph() {
        String[] desiredTargetNames = new String[this.desiredMorphTargets.size()];
        float[] desiredTargetWeights = new float[this.desiredMorphTargets.size()];
        int i = 0;
        Iterator<String> i$ = this.desiredMorphTargets.keySet().iterator();
        while (i$.hasNext()) {
            String targetName;
            desiredTargetNames[i] = targetName = i$.next();
            desiredTargetWeights[i] = this.desiredMorphTargets.get(targetName).floatValue();
            ++i;
        }
        this.morph(desiredTargetNames, desiredTargetWeights);
    }

    public void addMorphTargets(String[] targetNames, float[] weights) {
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = weights[i];
            Float fl = this.desiredMorphTargets.get(targetNames[i]);
            if (fl != null) {
                w += fl.floatValue();
            }
            if (w == 0.0f) {
                this.desiredMorphTargets.remove(targetNames[i]);
                continue;
            }
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }

    public void removeMorphTargets(String[] targetNames, float[] weights) {
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = -weights[i];
            Float fl = this.desiredMorphTargets.get(targetNames[i]);
            if (fl != null) {
                w += fl.floatValue();
            }
            if (w == 0.0f) {
                this.desiredMorphTargets.remove(targetNames[i]);
                continue;
            }
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }

    public void setMorphTargets(String[] targetNames, float[] weights) {
        this.desiredMorphTargets.clear();
        float w = 0.0f;
        for (int i = 0; i < targetNames.length; ++i) {
            w = weights[i];
            if (w == 0.0f) continue;
            this.desiredMorphTargets.put(targetNames[i], new Float(w));
        }
    }

    @Override
    public void glRender(GLRenderContext glc) {
        Console.println((String)"GLScene Deform...");
        this.deform();
        this.shapeList.glRender(glc);
    }

    public String toString() {
        return "GLScene(\n" + this.shapeList.toString() + ")";
    }
}

