/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.renderobjects;

import hmi.animation.VJoint;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLShape;
import hmi.graphics.opengl.renderobjects.SimpleLightGeometry;
import hmi.graphics.opengl.renderobjects.SimpleLightState;
import hmi.graphics.opengl.scenegraph.VGLNode;
import hmi.math.MatrixMath;

public class SimpleLight
extends VGLNode {
    private static final int VEC3SIZE = 3;
    private static final int VEC4SIZE = 4;
    private static final float SHADOWPLANE_HEIGHT = -0.4f;
    private static final float SHADOWPLANE_X0 = 0.0f;
    private static final float SHADOWPLANE_Z0 = 0.0f;
    private static final float SHADOWPLANE_X1 = 10.0f;
    private static final float SHADOWPLANE_Z1 = 0.0f;
    private static final float SHADOWPLANE_X2 = 5.0f;
    private static final float SHADOWPLANE_Z2 = -5.0f;
    private SimpleLightGeometry glGeometry;
    private SimpleLightState glState;
    private VJoint vjoint;
    private float[] translation = new float[3];
    private float[] position = new float[4];
    private float[] shadowMatrix;
    private float[][] points = new float[][]{{0.0f, -0.4f, 0.0f}, {10.0f, -0.4f, 0.0f}, {5.0f, -0.4f, -5.0f}};

    public SimpleLight(int gl_light, String name) {
        super(name);
        GLShape glShape = new GLShape(name);
        this.glGeometry = new SimpleLightGeometry();
        this.glState = new SimpleLightState(gl_light);
        glShape.addGLGeometry(this.glGeometry);
        glShape.addGLState(this.glState);
        this.addGLShape(glShape);
    }

    public SimpleLightState getState() {
        return this.glState;
    }

    public SimpleLightGeometry getGeometry() {
        return this.glGeometry;
    }

    public void setPosition(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        this.position[3] = 1.0f;
    }

    public void setPosition(float[] pos) {
        this.setPosition(pos[0], pos[1], pos[2]);
    }

    public float[] getPosition() {
        return this.position;
    }

    public void setDirection(float x, float y, float z) {
        this.position[0] = x;
        this.position[1] = y;
        this.position[2] = z;
        this.position[3] = 0.0f;
    }

    public synchronized void setShadowMatrix(float[] matrix) {
        this.shadowMatrix = matrix;
    }

    @Override
    public void glInit(GLRenderContext glc) {
        super.glInit(glc);
        this.vjoint = super.getRoot();
        if (this.shadowMatrix != null) {
            this.vjoint.getTranslation(this.translation);
            this.setPosition(this.translation);
            MatrixMath.makeShadowMatrix((float[][])this.points, (float[])this.position, (float[])this.shadowMatrix);
        }
    }

    @Override
    public void glRender(GLRenderContext glc) {
        if (this.shadowMatrix != null) {
            this.vjoint.getTranslation(this.translation);
            this.setPosition(this.translation);
            MatrixMath.makeShadowMatrix((float[][])this.points, (float[])this.position, (float[])this.shadowMatrix);
        }
        super.glRender(glc);
    }

    public void setShadowPlane(float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2) {
        this.points = new float[][]{{x0, y0, z0}, {x1, y1, z1}, {x2, y2, z2}};
    }
}

