/*
 * Decompiled with CFR 0.152.
 */
package hmi.graphics.opengl.geometry;

import com.sun.opengl.util.BufferUtil;
import hmi.graphics.opengl.GLRenderContext;
import hmi.graphics.opengl.GLRenderObject;
import hmi.graphics.opengl.GLShader;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class SphereGeometryFaceEditor
implements GLRenderObject {
    private float radius = 5.0f;
    private int numSlices = 32;
    private int numStacks = 16;
    private int nrOfVertices;
    private int nrOfTris;
    private float[] vertexData;
    private float[] normalData;
    private float[] texCoordData;
    private int[] indexData;
    private FloatBuffer vertexBuffer;
    private FloatBuffer normalBuffer;
    private FloatBuffer texCoordBuffer;
    private IntBuffer indexBuffer;
    private int vertexBufferId;
    private int normalBufferId;
    private int indexBufferId;
    private int texCoordBufferId;
    private int dataBufferSize;
    private int dataByteBufferSize;
    private int texCoordBufferSize;
    private int texCoordByteBufferSize;
    private int indexBufferSize;
    private int indexByteBufferSize;
    private int vertexIndex;
    private int normalIndex;
    private GLShader shader;
    float scalex;
    float scaley;
    float scalez;
    private boolean dirty = false;

    public SphereGeometryFaceEditor(float radius, int numSlices, int numStacks) {
        this.radius = radius;
        this.numSlices = numSlices;
        this.numStacks = numStacks;
        this.scalex = 1.0f;
        this.scaley = 1.0f;
        this.scalez = 1.0f;
        this.init();
        this.init();
        this.shader = new GLShader("blinnBasic", new String[0]);
        this.shader.setValue("diffuseColor", Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
    }

    public void setScalex(float scale) {
        this.scalex = scale;
        this.reinit();
    }

    public void setScaley(float scale) {
        this.scaley = scale;
        this.reinit();
    }

    public void setScalez(float scale) {
        this.scalez = scale;
        this.reinit();
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.reinit();
    }

    private void reinit() {
        this.init();
        this.dirty = true;
    }

    @Override
    public void glInit(GLRenderContext gl) {
        this.shader.glInit(gl);
        int[] progarray = new int[1];
        gl.glGetIntegerv(35725, progarray);
        int prog = progarray[0];
        this.vertexIndex = gl.glGetAttribLocation(prog, "mcPosition");
        this.normalIndex = gl.glGetAttribLocation(prog, "mcNormal");
        int[] bufNames = new int[4];
        gl.glGenBuffers(4, bufNames);
        this.vertexBufferId = bufNames[0];
        this.normalBufferId = bufNames[1];
        this.texCoordBufferId = bufNames[2];
        this.indexBufferId = bufNames[3];
        this.loadBuffers(gl);
    }

    private void loadBuffers(GLRenderContext gl) {
        gl.glBindBuffer(34962, this.vertexBufferId);
        this.vertexBuffer.rewind();
        gl.glBufferData(34962, this.dataByteBufferSize, this.vertexBuffer, 35044);
        gl.glBindBuffer(34962, this.normalBufferId);
        this.normalBuffer.rewind();
        gl.glBufferData(34962, this.dataByteBufferSize, this.normalBuffer, 35044);
        gl.glBindBuffer(34962, this.texCoordBufferId);
        this.texCoordBuffer.rewind();
        gl.glBufferData(34962, this.texCoordByteBufferSize, this.texCoordBuffer, 35044);
        gl.glBindBuffer(34963, this.indexBufferId);
        this.indexBuffer.rewind();
        gl.glBufferData(34963, this.indexByteBufferSize, this.indexBuffer, 35044);
    }

    @Override
    public void glRender(GLRenderContext gl) {
        if (this.dirty) {
            this.loadBuffers(gl);
            this.dirty = false;
        }
        this.shader.glRender(gl);
        gl.glBindBuffer(34962, this.vertexBufferId);
        gl.glEnableVertexAttribArray(this.vertexIndex);
        gl.glVertexAttribPointer(this.vertexIndex, 3, 5126, false, 0, 0L);
        gl.glBindBuffer(34962, this.normalBufferId);
        gl.glVertexAttribPointer(this.normalIndex, 3, 5126, false, 0, 0L);
        gl.glEnableVertexAttribArray(this.normalIndex);
        gl.glBindBuffer(34962, this.texCoordBufferId);
        gl.glBindBuffer(34963, this.indexBufferId);
        gl.glDrawRangeElements(4, 0, this.nrOfVertices, this.indexBufferSize, 5125, 0L);
    }

    private void init() {
        this.nrOfVertices = (this.numStacks + 1) * (this.numSlices + 1);
        this.nrOfTris = this.numStacks * this.numSlices * 2;
        this.dataBufferSize = 3 * this.nrOfVertices;
        this.texCoordBufferSize = 2 * this.nrOfVertices;
        this.indexBufferSize = 3 * this.nrOfTris;
        this.dataByteBufferSize = 4 * this.dataBufferSize;
        this.texCoordByteBufferSize = 4 * this.texCoordBufferSize;
        this.indexByteBufferSize = 4 * this.indexBufferSize;
        this.vertexData = new float[this.dataBufferSize];
        this.normalData = new float[this.dataBufferSize];
        this.texCoordData = new float[this.texCoordBufferSize];
        this.indexData = new int[this.indexBufferSize];
        this.vertexBuffer = BufferUtil.newFloatBuffer((int)this.dataBufferSize);
        this.normalBuffer = BufferUtil.newFloatBuffer((int)this.dataBufferSize);
        this.texCoordBuffer = BufferUtil.newFloatBuffer((int)this.texCoordBufferSize);
        this.indexBuffer = BufferUtil.newIntBuffer((int)this.indexBufferSize);
        double dtheta = Math.PI / (double)this.numStacks;
        double dphi = Math.PI * 2 / (double)this.numSlices;
        double ds = 1.0 / (double)this.numSlices;
        double dt = 1.0 / (double)this.numStacks;
        int vc = 0;
        for (int i = 0; i <= this.numStacks; ++i) {
            float ctheta;
            float stheta;
            if (i == 0) {
                stheta = 0.0f;
                ctheta = -1.0f;
            } else if (i == this.numStacks) {
                stheta = 0.0f;
                ctheta = 1.0f;
            } else {
                double theta = Math.PI - (double)i * dtheta;
                stheta = (float)Math.sin(theta);
                ctheta = (float)Math.cos(theta);
            }
            float t = (float)((double)i * dt);
            for (int j = 0; j <= this.numSlices; ++j) {
                float cphi;
                float sphi;
                if (j == 0 || j == this.numSlices) {
                    sphi = 0.0f;
                    cphi = 1.0f;
                } else {
                    double phi = (double)j * dphi;
                    sphi = (float)Math.sin(phi);
                    cphi = (float)Math.cos(phi);
                }
                float x = -sphi * stheta * this.scalex;
                float y = ctheta * this.scaley;
                float z = -cphi * stheta * this.scalez;
                float s = (float)((double)j * ds);
                this.vertexData[3 * vc] = this.radius * x;
                this.vertexData[3 * vc + 1] = this.radius * y;
                this.vertexData[3 * vc + 2] = this.radius * z;
                this.normalData[3 * vc] = x;
                this.normalData[3 * vc + 1] = y;
                this.normalData[3 * vc + 2] = z;
                this.texCoordData[2 * vc] = s;
                this.texCoordData[2 * vc + 1] = t;
                ++vc;
            }
        }
        int tc = 0;
        for (int i = 0; i < this.numStacks; ++i) {
            for (int j = 0; j < this.numSlices; ++j) {
                int lowerleft = i * (this.numSlices + 1) + j;
                int lowerright = lowerleft + 1;
                int upperleft = lowerleft + this.numSlices + 1;
                int upperright = upperleft + 1;
                this.indexData[3 * tc] = lowerleft;
                this.indexData[3 * tc + 1] = lowerright;
                this.indexData[3 * tc + 2] = upperleft;
                this.indexData[3 * ++tc] = upperleft;
                this.indexData[3 * tc + 1] = lowerright;
                this.indexData[3 * tc + 2] = upperright;
                ++tc;
            }
        }
        this.vertexBuffer.put(this.vertexData);
        this.normalBuffer.put(this.normalData);
        this.texCoordBuffer.put(this.texCoordData);
        this.indexBuffer.put(this.indexData);
    }
}

